/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.rss;

import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;

public final class RssUtils {
    private RssUtils() {
    }

    public static SyndFeed createFeed(String feedUri) throws Exception {
        return RssUtils.createFeed(feedUri, Thread.currentThread().getContextClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SyndFeed createFeed(String feedUri, ClassLoader classLoader) throws Exception {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classLoader);
            InputStream in = new URL(feedUri).openStream();
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed syndFeed = input.build((Reader)new XmlReader(in));
            return syndFeed;
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }
}

