/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.security;

import java.io.IOException;
import java.security.cert.CertificateException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="SWITCHYARD")
public interface BaseSecurityMessages {
    public static final BaseSecurityMessages MESSAGES = (BaseSecurityMessages)Messages.getBundle(BaseSecurityMessages.class);

    @Message(id=14401, value="Properties are not set")
    public IllegalStateException propertiesNotSet();

    @Message(id=14402, value="Property [%s] is not set.")
    public IllegalStateException propertyNotSet(String var1);

    @Message(id=14403, value="Credentials are not set.")
    public IllegalStateException credentialsNotSet();

    @Message(id=14404, value="Unable to extract Credentials from SSLSession: %s")
    public RuntimeException unableToExtractCredentials(String var1, @Cause SSLPeerUnverifiedException var2);

    @Message(id=14405, value="%s not implemented (although recognized)")
    public IllegalArgumentException valueTypeRecognizedNotImplemented(String var1);

    @Message(id=14406, value="%s not implemented")
    public IllegalArgumentException valueTypeNotImplemented(String var1);

    @Message(id=14407, value="Could not create certificate(s): %s")
    public RuntimeException couldNotCreateCert(String var1, @Cause CertificateException var2);

    @Message(id=14408, value="Failed to invoke callback: %s")
    public LoginException failedInvokeCallback(String var1, @Cause IOException var2);

    @Message(id=14410, value="CallbackHandler does not support: %s")
    public LoginException callbackHandlerNoSupport(String var1);

    @Message(id=14411, value="Problem accessing KeyStore: %s")
    public LoginException problemAccessingKeystore(String var1);

    @Message(id=14412, value="Problem verifying caller Certificate: %s")
    public LoginException problemVerifyingCallerCert(String var1);

    @Message(id=14413, value="No caller X509 Certificate provided")
    public LoginException noCallerCertificateProvided();

    @Message(id=14414, value="Options not set")
    public IllegalStateException optionsNotSet();

    @Message(id=14415, value="Option [%s] not set")
    public IllegalStateException optionNotSet(String var1);

    @Message(id=14416, value="Group name cannot be null")
    public IllegalArgumentException groupNameCannotBeNull();

    @Message(id=14417, value="Role name cannot be null")
    public IllegalArgumentException roleCannotBeNull();

    @Message(id=14418, value="User name cannot be null")
    public IllegalArgumentException userNameCannotBeNull();
}

