/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.mqtt;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.mqtt.MQTTComponent;
import org.apache.camel.component.mqtt.MQTTConfiguration;
import org.apache.camel.component.mqtt.MQTTConsumer;
import org.apache.camel.component.mqtt.MQTTProducer;
import org.apache.camel.impl.DefaultEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.fusesource.hawtbuf.Buffer;
import org.fusesource.hawtbuf.UTF8Buffer;
import org.fusesource.hawtdispatch.Task;
import org.fusesource.mqtt.client.Callback;
import org.fusesource.mqtt.client.CallbackConnection;
import org.fusesource.mqtt.client.Listener;
import org.fusesource.mqtt.client.Promise;
import org.fusesource.mqtt.client.QoS;
import org.fusesource.mqtt.client.Topic;
import org.fusesource.mqtt.client.Tracer;
import org.fusesource.mqtt.codec.CONNACK;
import org.fusesource.mqtt.codec.CONNECT;
import org.fusesource.mqtt.codec.DISCONNECT;
import org.fusesource.mqtt.codec.MQTTFrame;
import org.fusesource.mqtt.codec.PINGREQ;
import org.fusesource.mqtt.codec.PINGRESP;
import org.fusesource.mqtt.codec.PUBACK;
import org.fusesource.mqtt.codec.PUBCOMP;
import org.fusesource.mqtt.codec.PUBLISH;
import org.fusesource.mqtt.codec.PUBREC;
import org.fusesource.mqtt.codec.PUBREL;
import org.fusesource.mqtt.codec.SUBACK;
import org.fusesource.mqtt.codec.SUBSCRIBE;
import org.fusesource.mqtt.codec.UNSUBSCRIBE;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="mqtt", title="MQTT", syntax="mqtt:name", consumerClass=MQTTConsumer.class, label="messaging")
public class MQTTEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(MQTTEndpoint.class);
    private static final int PUBLISH_MAX_RECONNECT_ATTEMPTS = 3;
    private CallbackConnection connection;
    @UriPath
    @Metadata(required="true")
    private String name;
    @UriParam
    private final MQTTConfiguration configuration;
    private volatile boolean connected;
    private final List<MQTTConsumer> consumers = new CopyOnWriteArrayList<MQTTConsumer>();

    public MQTTEndpoint(final String uri, MQTTComponent component, MQTTConfiguration properties) {
        super(uri, (Component)component);
        this.configuration = properties;
        if (LOG.isTraceEnabled()) {
            this.configuration.setTracer(new Tracer(){

                public void debug(String message, Object ... args) {
                    LOG.trace("tracer.debug() " + (Object)((Object)this) + ": uri=" + uri + ", message=" + String.format(message, args));
                }

                public void onSend(MQTTFrame frame) {
                    String decoded = null;
                    try {
                        switch (frame.messageType()) {
                            case 12: {
                                decoded = new PINGREQ().decode(frame).toString();
                                break;
                            }
                            case 13: {
                                decoded = new PINGRESP().decode(frame).toString();
                                break;
                            }
                            case 1: {
                                decoded = new CONNECT().decode(frame).toString();
                                break;
                            }
                            case 14: {
                                decoded = new DISCONNECT().decode(frame).toString();
                                break;
                            }
                            case 8: {
                                decoded = new SUBSCRIBE().decode(frame).toString();
                                break;
                            }
                            case 10: {
                                decoded = new UNSUBSCRIBE().decode(frame).toString();
                                break;
                            }
                            case 3: {
                                decoded = new PUBLISH().decode(frame).toString();
                                break;
                            }
                            case 4: {
                                decoded = new PUBACK().decode(frame).toString();
                                break;
                            }
                            case 5: {
                                decoded = new PUBREC().decode(frame).toString();
                                break;
                            }
                            case 6: {
                                decoded = new PUBREL().decode(frame).toString();
                                break;
                            }
                            case 7: {
                                decoded = new PUBCOMP().decode(frame).toString();
                                break;
                            }
                            case 2: {
                                decoded = new CONNACK().decode(frame).toString();
                                break;
                            }
                            case 9: {
                                decoded = new SUBACK().decode(frame).toString();
                                break;
                            }
                            default: {
                                decoded = frame.toString();
                                break;
                            }
                        }
                    }
                    catch (Throwable e) {
                        decoded = frame.toString();
                    }
                    LOG.trace("tracer.onSend() " + (Object)((Object)this) + ":  uri=" + uri + ", frame=" + decoded);
                }

                public void onReceive(MQTTFrame frame) {
                    String decoded = null;
                    try {
                        switch (frame.messageType()) {
                            case 12: {
                                decoded = new PINGREQ().decode(frame).toString();
                                break;
                            }
                            case 13: {
                                decoded = new PINGRESP().decode(frame).toString();
                                break;
                            }
                            case 1: {
                                decoded = new CONNECT().decode(frame).toString();
                                break;
                            }
                            case 14: {
                                decoded = new DISCONNECT().decode(frame).toString();
                                break;
                            }
                            case 8: {
                                decoded = new SUBSCRIBE().decode(frame).toString();
                                break;
                            }
                            case 10: {
                                decoded = new UNSUBSCRIBE().decode(frame).toString();
                                break;
                            }
                            case 3: {
                                decoded = new PUBLISH().decode(frame).toString();
                                break;
                            }
                            case 4: {
                                decoded = new PUBACK().decode(frame).toString();
                                break;
                            }
                            case 5: {
                                decoded = new PUBREC().decode(frame).toString();
                                break;
                            }
                            case 6: {
                                decoded = new PUBREL().decode(frame).toString();
                                break;
                            }
                            case 7: {
                                decoded = new PUBCOMP().decode(frame).toString();
                                break;
                            }
                            case 2: {
                                decoded = new CONNACK().decode(frame).toString();
                                break;
                            }
                            case 9: {
                                decoded = new SUBACK().decode(frame).toString();
                                break;
                            }
                            default: {
                                decoded = frame.toString();
                                break;
                            }
                        }
                    }
                    catch (Throwable e) {
                        decoded = frame.toString();
                    }
                    LOG.trace("tracer.onReceive() " + (Object)((Object)this) + ":  uri=" + uri + ", frame=" + decoded);
                }
            });
        }
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        MQTTConsumer answer = new MQTTConsumer(this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    public Producer createProducer() throws Exception {
        return new MQTTProducer(this);
    }

    public MQTTConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    protected void doStart() throws Exception {
        super.doStart();
        this.createConnection();
    }

    protected void createConnection() {
        this.connection = this.configuration.callbackConnection();
        this.connection.listener(new Listener(){

            public void onConnected() {
                MQTTEndpoint.this.connected = true;
                LOG.info("MQTT Connection connected to {}", (Object)MQTTEndpoint.this.configuration.getHost());
            }

            public void onDisconnected() {
                LOG.debug("MQTT Connection disconnected from {}", (Object)MQTTEndpoint.this.configuration.getHost());
            }

            public void onPublish(UTF8Buffer topic, Buffer body, Runnable ack) {
                if (!MQTTEndpoint.this.consumers.isEmpty()) {
                    Exchange exchange = MQTTEndpoint.this.createExchange();
                    exchange.getIn().setBody((Object)body.toByteArray());
                    exchange.getIn().setHeader("CamelMQTTSubscribeTopic", (Object)topic.toString());
                    for (MQTTConsumer consumer : MQTTEndpoint.this.consumers) {
                        consumer.processExchange(exchange);
                    }
                }
                if (ack != null) {
                    ack.run();
                }
            }

            public void onFailure(Throwable value) {
                MQTTEndpoint.this.connected = false;
                LOG.warn("Connection to " + MQTTEndpoint.this.configuration.getHost() + " failure due " + value.getMessage() + ". Forcing a disconnect to re-connect on next attempt.");
                MQTTEndpoint.this.connection.disconnect((Callback)new Callback<Void>(){

                    public void onSuccess(Void value) {
                    }

                    public void onFailure(Throwable e) {
                        LOG.debug("Failed to disconnect from " + MQTTEndpoint.this.configuration.getHost() + ". This exception is ignored.", e);
                    }
                });
            }
        });
    }

    protected void doStop() throws Exception {
        super.doStop();
        if (this.connection != null) {
            final Promise promise = new Promise();
            this.connection.getDispatchQueue().execute(new Task(){

                public void run() {
                    MQTTEndpoint.this.connection.disconnect((Callback)new Callback<Void>(){

                        public void onSuccess(Void value) {
                            promise.onSuccess((Object)value);
                        }

                        public void onFailure(Throwable value) {
                            promise.onFailure(value);
                        }
                    });
                }
            });
            promise.await((long)this.configuration.getDisconnectWaitInSeconds(), TimeUnit.SECONDS);
        }
    }

    void connect() throws Exception {
        final Promise promise = new Promise();
        this.connection.connect((Callback)new Callback<Void>(){

            public void onSuccess(Void value) {
                LOG.debug("Connected to {}", (Object)MQTTEndpoint.this.configuration.getHost());
                Topic[] topics = MQTTEndpoint.this.createSubscribeTopics();
                if (topics != null && topics.length > 0) {
                    MQTTEndpoint.this.connection.subscribe(topics, (Callback)new Callback<byte[]>(){

                        public void onSuccess(byte[] value) {
                            promise.onSuccess((Object)value);
                            MQTTEndpoint.this.connected = true;
                        }

                        public void onFailure(Throwable value) {
                            LOG.debug("Failed to subscribe", value);
                            promise.onFailure(value);
                            MQTTEndpoint.this.connection.disconnect(null);
                            MQTTEndpoint.this.connected = false;
                        }
                    });
                } else {
                    promise.onSuccess((Object)value);
                    MQTTEndpoint.this.connected = true;
                }
            }

            public void onFailure(Throwable value) {
                LOG.warn("Failed to connect to " + MQTTEndpoint.this.configuration.getHost() + " due " + value.getMessage());
                promise.onFailure(value);
                MQTTEndpoint.this.connection.disconnect(null);
                MQTTEndpoint.this.connected = false;
            }
        });
        LOG.info("Connecting to {} using {} seconds timeout", (Object)this.configuration.getHost(), (Object)this.configuration.getConnectWaitInSeconds());
        promise.await((long)this.configuration.getConnectWaitInSeconds(), TimeUnit.SECONDS);
    }

    Topic[] createSubscribeTopics() {
        String subscribeTopicList = this.configuration.getSubscribeTopicNames();
        if (subscribeTopicList != null && !subscribeTopicList.isEmpty()) {
            String[] topicNames = subscribeTopicList.split(",");
            Topic[] topics = new Topic[topicNames.length];
            for (int i = 0; i < topicNames.length; ++i) {
                topics[i] = new Topic(topicNames[i].trim(), this.configuration.getQoS());
            }
            return topics;
        }
        String subscribeTopicName = this.configuration.getSubscribeTopicName();
        String string = subscribeTopicName = subscribeTopicName != null ? subscribeTopicName.trim() : null;
        if (subscribeTopicName != null && !subscribeTopicName.isEmpty()) {
            Topic[] topics = new Topic[]{new Topic(subscribeTopicName, this.configuration.getQoS())};
            return topics;
        }
        LOG.warn("No topic subscriptions were specified in configuration");
        return null;
    }

    boolean isConnected() {
        return this.connected;
    }

    void publish(final String topic, final byte[] payload, final QoS qoS, final boolean retain, final Callback<Void> callback) throws Exception {
        boolean done = this.isConnected();
        int attempt = 0;
        TimeoutException timeout = null;
        while (!done && attempt <= 3) {
            ++attempt;
            try {
                LOG.warn("#{} attempt to re-create connection to {} before publishing", (Object)attempt, (Object)this.configuration.getHost());
                this.createConnection();
                this.connect();
            }
            catch (TimeoutException e) {
                timeout = e;
                LOG.debug("Timed out after {} seconds after {} attempt to re-create connection to {}", new Object[]{this.configuration.getConnectWaitInSeconds(), attempt, this.configuration.getHost()});
            }
            catch (Throwable e) {
                callback.onFailure(e);
                return;
            }
            done = this.isConnected();
        }
        if (attempt > 3 && !this.isConnected()) {
            LOG.warn("Cannot re-connect to {} after {} attempts", (Object)this.configuration.getHost(), (Object)attempt);
            callback.onFailure((Throwable)timeout);
            return;
        }
        this.connection.getDispatchQueue().execute(new Task(){

            public void run() {
                LOG.debug("Publishing to {}", (Object)MQTTEndpoint.this.configuration.getHost());
                MQTTEndpoint.this.connection.publish(topic, payload, qoS, retain, callback);
            }
        });
    }

    void addConsumer(MQTTConsumer consumer) {
        this.consumers.add(consumer);
    }

    void removeConsumer(MQTTConsumer consumer) {
        this.consumers.remove((Object)consumer);
    }

    public boolean isSingleton() {
        return true;
    }
}

