/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v21.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v21.datatype.CQ;
import ca.uhn.hl7v2.model.v21.datatype.ID;
import ca.uhn.hl7v2.model.v21.datatype.ST;
import ca.uhn.hl7v2.model.v21.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class QRD
extends AbstractSegment {
    public QRD(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(TS.class, true, 1, 19, new Object[]{this.getMessage()}, "QUERY DATE/TIME");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(106)}, "QUERY FORMAT CODE");
            this.add(ID.class, true, 1, 1, new Object[]{this.getMessage(), new Integer(91)}, "QUERY PRIORITY");
            this.add(ST.class, true, 1, 10, new Object[]{this.getMessage()}, "QUERY ID");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(107)}, "DEFERRED RESPONSE TYPE");
            this.add(TS.class, false, 1, 19, new Object[]{this.getMessage()}, "DEFERRED RESPONSE DATE/TIME");
            this.add(CQ.class, true, 1, 5, new Object[]{this.getMessage()}, "QUANTITY LIMITED REQUEST");
            this.add(ST.class, true, 0, 20, new Object[]{this.getMessage()}, "WHO SUBJECT FILTER");
            this.add(ID.class, true, 0, 3, new Object[]{this.getMessage(), new Integer(48)}, "WHAT SUBJECT FILTER");
            this.add(ST.class, true, 0, 20, new Object[]{this.getMessage()}, "WHAT DEPARTMENT DATA CODE");
            this.add(ST.class, false, 0, 20, new Object[]{this.getMessage()}, "WHAT DATA CODE VALUE QUAL.");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(108)}, "QUERY RESULTS LEVEL");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating QRD - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public TS getQUERYDATETIME() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getQrd1_QUERYDATETIME() {
        TS retVal = (TS)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getQUERYFORMATCODE() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getQrd2_QUERYFORMATCODE() {
        ID retVal = (ID)this.getTypedField(2, 0);
        return retVal;
    }

    public ID getQUERYPRIORITY() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ID getQrd3_QUERYPRIORITY() {
        ID retVal = (ID)this.getTypedField(3, 0);
        return retVal;
    }

    public ST getQUERYID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ST getQrd4_QUERYID() {
        ST retVal = (ST)this.getTypedField(4, 0);
        return retVal;
    }

    public ID getDEFERREDRESPONSETYPE() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public ID getQrd5_DEFERREDRESPONSETYPE() {
        ID retVal = (ID)this.getTypedField(5, 0);
        return retVal;
    }

    public TS getDEFERREDRESPONSEDATETIME() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getQrd6_DEFERREDRESPONSEDATETIME() {
        TS retVal = (TS)this.getTypedField(6, 0);
        return retVal;
    }

    public CQ getQUANTITYLIMITEDREQUEST() {
        CQ retVal = (CQ)this.getTypedField(7, 0);
        return retVal;
    }

    public CQ getQrd7_QUANTITYLIMITEDREQUEST() {
        CQ retVal = (CQ)this.getTypedField(7, 0);
        return retVal;
    }

    public ST[] getWHOSUBJECTFILTER() {
        ST[] retVal = (ST[])this.getTypedField(8, new ST[0]);
        return retVal;
    }

    public ST[] getQrd8_WHOSUBJECTFILTER() {
        ST[] retVal = (ST[])this.getTypedField(8, new ST[0]);
        return retVal;
    }

    public int getWHOSUBJECTFILTERReps() {
        return this.getReps(8);
    }

    public ST getWHOSUBJECTFILTER(int rep) {
        ST retVal = (ST)this.getTypedField(8, rep);
        return retVal;
    }

    public ST getQrd8_WHOSUBJECTFILTER(int rep) {
        ST retVal = (ST)this.getTypedField(8, rep);
        return retVal;
    }

    public int getQrd8_WHOSUBJECTFILTERReps() {
        return this.getReps(8);
    }

    public ST insertWHOSUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(8, rep);
    }

    public ST insertQrd8_WHOSUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(8, rep);
    }

    public ST removeWHOSUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(8, rep);
    }

    public ST removeQrd8_WHOSUBJECTFILTER(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(8, rep);
    }

    public ID[] getWHATSUBJECTFILTER() {
        ID[] retVal = (ID[])this.getTypedField(9, new ID[0]);
        return retVal;
    }

    public ID[] getQrd9_WHATSUBJECTFILTER() {
        ID[] retVal = (ID[])this.getTypedField(9, new ID[0]);
        return retVal;
    }

    public int getWHATSUBJECTFILTERReps() {
        return this.getReps(9);
    }

    public ID getWHATSUBJECTFILTER(int rep) {
        ID retVal = (ID)this.getTypedField(9, rep);
        return retVal;
    }

    public ID getQrd9_WHATSUBJECTFILTER(int rep) {
        ID retVal = (ID)this.getTypedField(9, rep);
        return retVal;
    }

    public int getQrd9_WHATSUBJECTFILTERReps() {
        return this.getReps(9);
    }

    public ID insertWHATSUBJECTFILTER(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(9, rep);
    }

    public ID insertQrd9_WHATSUBJECTFILTER(int rep) throws HL7Exception {
        return (ID)super.insertRepetition(9, rep);
    }

    public ID removeWHATSUBJECTFILTER(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(9, rep);
    }

    public ID removeQrd9_WHATSUBJECTFILTER(int rep) throws HL7Exception {
        return (ID)super.removeRepetition(9, rep);
    }

    public ST[] getWHATDEPARTMENTDATACODE() {
        ST[] retVal = (ST[])this.getTypedField(10, new ST[0]);
        return retVal;
    }

    public ST[] getQrd10_WHATDEPARTMENTDATACODE() {
        ST[] retVal = (ST[])this.getTypedField(10, new ST[0]);
        return retVal;
    }

    public int getWHATDEPARTMENTDATACODEReps() {
        return this.getReps(10);
    }

    public ST getWHATDEPARTMENTDATACODE(int rep) {
        ST retVal = (ST)this.getTypedField(10, rep);
        return retVal;
    }

    public ST getQrd10_WHATDEPARTMENTDATACODE(int rep) {
        ST retVal = (ST)this.getTypedField(10, rep);
        return retVal;
    }

    public int getQrd10_WHATDEPARTMENTDATACODEReps() {
        return this.getReps(10);
    }

    public ST insertWHATDEPARTMENTDATACODE(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(10, rep);
    }

    public ST insertQrd10_WHATDEPARTMENTDATACODE(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(10, rep);
    }

    public ST removeWHATDEPARTMENTDATACODE(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(10, rep);
    }

    public ST removeQrd10_WHATDEPARTMENTDATACODE(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(10, rep);
    }

    public ST[] getWHATDATACODEVALUEQUAL() {
        ST[] retVal = (ST[])this.getTypedField(11, new ST[0]);
        return retVal;
    }

    public ST[] getQrd11_WHATDATACODEVALUEQUAL() {
        ST[] retVal = (ST[])this.getTypedField(11, new ST[0]);
        return retVal;
    }

    public int getWHATDATACODEVALUEQUALReps() {
        return this.getReps(11);
    }

    public ST getWHATDATACODEVALUEQUAL(int rep) {
        ST retVal = (ST)this.getTypedField(11, rep);
        return retVal;
    }

    public ST getQrd11_WHATDATACODEVALUEQUAL(int rep) {
        ST retVal = (ST)this.getTypedField(11, rep);
        return retVal;
    }

    public int getQrd11_WHATDATACODEVALUEQUALReps() {
        return this.getReps(11);
    }

    public ST insertWHATDATACODEVALUEQUAL(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(11, rep);
    }

    public ST insertQrd11_WHATDATACODEVALUEQUAL(int rep) throws HL7Exception {
        return (ST)super.insertRepetition(11, rep);
    }

    public ST removeWHATDATACODEVALUEQUAL(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(11, rep);
    }

    public ST removeQrd11_WHATDATACODEVALUEQUAL(int rep) throws HL7Exception {
        return (ST)super.removeRepetition(11, rep);
    }

    public ID getQUERYRESULTSLEVEL() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    public ID getQrd12_QUERYRESULTSLEVEL() {
        ID retVal = (ID)this.getTypedField(12, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new TS(this.getMessage());
            }
            case 1: {
                return new ID(this.getMessage(), new Integer(106));
            }
            case 2: {
                return new ID(this.getMessage(), new Integer(91));
            }
            case 3: {
                return new ST(this.getMessage());
            }
            case 4: {
                return new ID(this.getMessage(), new Integer(107));
            }
            case 5: {
                return new TS(this.getMessage());
            }
            case 6: {
                return new CQ(this.getMessage());
            }
            case 7: {
                return new ST(this.getMessage());
            }
            case 8: {
                return new ID(this.getMessage(), new Integer(48));
            }
            case 9: {
                return new ST(this.getMessage());
            }
            case 10: {
                return new ST(this.getMessage());
            }
            case 11: {
                return new ID(this.getMessage(), new Integer(108));
            }
        }
        return null;
    }
}

