/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v23.segment.CDM;
import ca.uhn.hl7v2.model.v23.segment.MFE;
import ca.uhn.hl7v2.model.v23.segment.PRC;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MFN_M04_MF_CDM
extends AbstractGroup {
    public MFN_M04_MF_CDM(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MFE.class, true, false, false);
            this.add(CDM.class, true, false, false);
            this.add(PRC.class, false, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating MFN_M04_MF_CDM - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.3";
    }

    public MFE getMFE() {
        MFE retVal = this.getTyped("MFE", MFE.class);
        return retVal;
    }

    public CDM getCDM() {
        CDM retVal = this.getTyped("CDM", CDM.class);
        return retVal;
    }

    public PRC getPRC() {
        PRC retVal = this.getTyped("PRC", PRC.class);
        return retVal;
    }

    public PRC getPRC(int rep) {
        PRC retVal = this.getTyped("PRC", rep, PRC.class);
        return retVal;
    }

    public int getPRCReps() {
        return this.getReps("PRC");
    }

    public List<PRC> getPRCAll() throws HL7Exception {
        return this.getAllAsList("PRC", PRC.class);
    }

    public void insertPRC(PRC structure, int rep) throws HL7Exception {
        super.insertRepetition("PRC", structure, rep);
    }

    public PRC insertPRC(int rep) throws HL7Exception {
        return (PRC)super.insertRepetition("PRC", rep);
    }

    public PRC removePRC(int rep) throws HL7Exception {
        return (PRC)super.removeRepetition("PRC", rep);
    }
}

