/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v23.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v23.datatype.CE;
import ca.uhn.hl7v2.model.v23.datatype.CP;
import ca.uhn.hl7v2.model.v23.datatype.CX;
import ca.uhn.hl7v2.model.v23.datatype.DT;
import ca.uhn.hl7v2.model.v23.datatype.FC;
import ca.uhn.hl7v2.model.v23.datatype.ID;
import ca.uhn.hl7v2.model.v23.datatype.IS;
import ca.uhn.hl7v2.model.v23.datatype.JCC;
import ca.uhn.hl7v2.model.v23.datatype.NM;
import ca.uhn.hl7v2.model.v23.datatype.SI;
import ca.uhn.hl7v2.model.v23.datatype.ST;
import ca.uhn.hl7v2.model.v23.datatype.TS;
import ca.uhn.hl7v2.model.v23.datatype.XAD;
import ca.uhn.hl7v2.model.v23.datatype.XON;
import ca.uhn.hl7v2.model.v23.datatype.XPN;
import ca.uhn.hl7v2.model.v23.datatype.XTN;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class GT1
extends AbstractSegment {
    public GT1(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(SI.class, true, 1, 4, new Object[]{this.getMessage()}, "Set ID - Guarantor");
            this.add(CX.class, false, 0, 59, new Object[]{this.getMessage()}, "Guarantor Number");
            this.add(XPN.class, true, 0, 48, new Object[]{this.getMessage()}, "Guarantor Name");
            this.add(XPN.class, false, 0, 48, new Object[]{this.getMessage()}, "Guarantor Spouse Name");
            this.add(XAD.class, false, 0, 106, new Object[]{this.getMessage()}, "Guarantor Address");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Guarantor Ph Num- Home");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Guarantor Ph Num-Business");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Guarantor Date/Time of Birth");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(1)}, "Guarantor Sex");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(68)}, "Guarantor Type");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(63)}, "Guarantor Relationship");
            this.add(ST.class, false, 1, 11, new Object[]{this.getMessage()}, "Guarantor SSN");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Guarantor Date - Begin");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Guarantor Date - End");
            this.add(NM.class, false, 1, 2, new Object[]{this.getMessage()}, "Guarantor Priority");
            this.add(XPN.class, false, 0, 130, new Object[]{this.getMessage()}, "Guarantor Employer Name");
            this.add(XAD.class, false, 0, 106, new Object[]{this.getMessage()}, "Guarantor Employer Address");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Guarantor Employ Phone Number");
            this.add(CX.class, false, 0, 20, new Object[]{this.getMessage()}, "Guarantor Employee ID Number");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(66)}, "Guarantor Employment Status");
            this.add(XON.class, false, 0, 130, new Object[]{this.getMessage()}, "Guarantor Organization");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Guarantor Billing Hold Flag");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Guarantor Credit Rating Code");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Guarantor Death Date And Time");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Guarantor Death Flag");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Guarantor Charge Adjustment Code");
            this.add(CP.class, false, 1, 10, new Object[]{this.getMessage()}, "Guarantor Household Annual Income");
            this.add(NM.class, false, 1, 3, new Object[]{this.getMessage()}, "Guarantor Household Size");
            this.add(CX.class, false, 0, 20, new Object[]{this.getMessage()}, "Guarantor Employer ID Number");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(0)}, "Guarantor Marital Status Code");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Guarantor Hire Effective Date");
            this.add(DT.class, false, 1, 8, new Object[]{this.getMessage()}, "Employment Stop Date");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(223)}, "Living Dependency");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(9)}, "Ambulatory Status");
            this.add(IS.class, false, 1, 4, new Object[]{this.getMessage(), new Integer(171)}, "Citizenship");
            this.add(CE.class, false, 1, 60, new Object[]{this.getMessage()}, "Primary Language");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(220)}, "Living Arrangement");
            this.add(CE.class, false, 1, 1, new Object[]{this.getMessage()}, "Publicity Indicator");
            this.add(ID.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(136)}, "Protection Indicator");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(231)}, "Student Indicator");
            this.add(IS.class, false, 1, 3, new Object[]{this.getMessage(), new Integer(6)}, "Religion");
            this.add(XPN.class, false, 1, 48, new Object[]{this.getMessage()}, "Mother\u2019s Maiden Name");
            this.add(CE.class, false, 1, 80, new Object[]{this.getMessage()}, "Nationality Code");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(189)}, "Ethnic Group");
            this.add(XPN.class, false, 0, 48, new Object[]{this.getMessage()}, "Contact Person's Name");
            this.add(XTN.class, false, 0, 40, new Object[]{this.getMessage()}, "Contact Person\u2019s Telephone Number");
            this.add(CE.class, false, 1, 2, new Object[]{this.getMessage()}, "Contact Reason");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(63)}, "Contact Relationship Code");
            this.add(ST.class, false, 1, 20, new Object[]{this.getMessage()}, "Job Title");
            this.add(JCC.class, false, 1, 20, new Object[]{this.getMessage()}, "Job Code/Class");
            this.add(XON.class, false, 0, 130, new Object[]{this.getMessage()}, "Guarantor Employer's Organization Name");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(310)}, "Handicap");
            this.add(IS.class, false, 1, 2, new Object[]{this.getMessage(), new Integer(311)}, "Job Status");
            this.add(FC.class, false, 1, 50, new Object[]{this.getMessage()}, "Guarantor Financial Class");
            this.add(IS.class, false, 1, 1, new Object[]{this.getMessage(), new Integer(5)}, "Guarantor Race");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating GT1 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public SI getSetIDGuarantor() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public SI getGt11_SetIDGuarantor() {
        SI retVal = (SI)this.getTypedField(1, 0);
        return retVal;
    }

    public CX[] getGuarantorNumber() {
        CX[] retVal = (CX[])this.getTypedField(2, new CX[0]);
        return retVal;
    }

    public CX[] getGt12_GuarantorNumber() {
        CX[] retVal = (CX[])this.getTypedField(2, new CX[0]);
        return retVal;
    }

    public int getGuarantorNumberReps() {
        return this.getReps(2);
    }

    public CX getGuarantorNumber(int rep) {
        CX retVal = (CX)this.getTypedField(2, rep);
        return retVal;
    }

    public CX getGt12_GuarantorNumber(int rep) {
        CX retVal = (CX)this.getTypedField(2, rep);
        return retVal;
    }

    public int getGt12_GuarantorNumberReps() {
        return this.getReps(2);
    }

    public CX insertGuarantorNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX insertGt12_GuarantorNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(2, rep);
    }

    public CX removeGuarantorNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public CX removeGt12_GuarantorNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(2, rep);
    }

    public XPN[] getGuarantorName() {
        XPN[] retVal = (XPN[])this.getTypedField(3, new XPN[0]);
        return retVal;
    }

    public XPN[] getGt13_GuarantorName() {
        XPN[] retVal = (XPN[])this.getTypedField(3, new XPN[0]);
        return retVal;
    }

    public int getGuarantorNameReps() {
        return this.getReps(3);
    }

    public XPN getGuarantorName(int rep) {
        XPN retVal = (XPN)this.getTypedField(3, rep);
        return retVal;
    }

    public XPN getGt13_GuarantorName(int rep) {
        XPN retVal = (XPN)this.getTypedField(3, rep);
        return retVal;
    }

    public int getGt13_GuarantorNameReps() {
        return this.getReps(3);
    }

    public XPN insertGuarantorName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(3, rep);
    }

    public XPN insertGt13_GuarantorName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(3, rep);
    }

    public XPN removeGuarantorName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(3, rep);
    }

    public XPN removeGt13_GuarantorName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(3, rep);
    }

    public XPN[] getGuarantorSpouseName() {
        XPN[] retVal = (XPN[])this.getTypedField(4, new XPN[0]);
        return retVal;
    }

    public XPN[] getGt14_GuarantorSpouseName() {
        XPN[] retVal = (XPN[])this.getTypedField(4, new XPN[0]);
        return retVal;
    }

    public int getGuarantorSpouseNameReps() {
        return this.getReps(4);
    }

    public XPN getGuarantorSpouseName(int rep) {
        XPN retVal = (XPN)this.getTypedField(4, rep);
        return retVal;
    }

    public XPN getGt14_GuarantorSpouseName(int rep) {
        XPN retVal = (XPN)this.getTypedField(4, rep);
        return retVal;
    }

    public int getGt14_GuarantorSpouseNameReps() {
        return this.getReps(4);
    }

    public XPN insertGuarantorSpouseName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(4, rep);
    }

    public XPN insertGt14_GuarantorSpouseName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(4, rep);
    }

    public XPN removeGuarantorSpouseName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(4, rep);
    }

    public XPN removeGt14_GuarantorSpouseName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(4, rep);
    }

    public XAD[] getGuarantorAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(5, new XAD[0]);
        return retVal;
    }

    public XAD[] getGt15_GuarantorAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(5, new XAD[0]);
        return retVal;
    }

    public int getGuarantorAddressReps() {
        return this.getReps(5);
    }

    public XAD getGuarantorAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(5, rep);
        return retVal;
    }

    public XAD getGt15_GuarantorAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(5, rep);
        return retVal;
    }

    public int getGt15_GuarantorAddressReps() {
        return this.getReps(5);
    }

    public XAD insertGuarantorAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(5, rep);
    }

    public XAD insertGt15_GuarantorAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(5, rep);
    }

    public XAD removeGuarantorAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(5, rep);
    }

    public XAD removeGt15_GuarantorAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(5, rep);
    }

    public XTN[] getGuarantorPhNumHome() {
        XTN[] retVal = (XTN[])this.getTypedField(6, new XTN[0]);
        return retVal;
    }

    public XTN[] getGt16_GuarantorPhNumHome() {
        XTN[] retVal = (XTN[])this.getTypedField(6, new XTN[0]);
        return retVal;
    }

    public int getGuarantorPhNumHomeReps() {
        return this.getReps(6);
    }

    public XTN getGuarantorPhNumHome(int rep) {
        XTN retVal = (XTN)this.getTypedField(6, rep);
        return retVal;
    }

    public XTN getGt16_GuarantorPhNumHome(int rep) {
        XTN retVal = (XTN)this.getTypedField(6, rep);
        return retVal;
    }

    public int getGt16_GuarantorPhNumHomeReps() {
        return this.getReps(6);
    }

    public XTN insertGuarantorPhNumHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN insertGt16_GuarantorPhNumHome(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(6, rep);
    }

    public XTN removeGuarantorPhNumHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public XTN removeGt16_GuarantorPhNumHome(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(6, rep);
    }

    public XTN[] getGuarantorPhNumBusiness() {
        XTN[] retVal = (XTN[])this.getTypedField(7, new XTN[0]);
        return retVal;
    }

    public XTN[] getGt17_GuarantorPhNumBusiness() {
        XTN[] retVal = (XTN[])this.getTypedField(7, new XTN[0]);
        return retVal;
    }

    public int getGuarantorPhNumBusinessReps() {
        return this.getReps(7);
    }

    public XTN getGuarantorPhNumBusiness(int rep) {
        XTN retVal = (XTN)this.getTypedField(7, rep);
        return retVal;
    }

    public XTN getGt17_GuarantorPhNumBusiness(int rep) {
        XTN retVal = (XTN)this.getTypedField(7, rep);
        return retVal;
    }

    public int getGt17_GuarantorPhNumBusinessReps() {
        return this.getReps(7);
    }

    public XTN insertGuarantorPhNumBusiness(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(7, rep);
    }

    public XTN insertGt17_GuarantorPhNumBusiness(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(7, rep);
    }

    public XTN removeGuarantorPhNumBusiness(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(7, rep);
    }

    public XTN removeGt17_GuarantorPhNumBusiness(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(7, rep);
    }

    public TS getGuarantorDateTimeOfBirth() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getGt18_GuarantorDateTimeOfBirth() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public IS getGuarantorSex() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getGt19_GuarantorSex() {
        IS retVal = (IS)this.getTypedField(9, 0);
        return retVal;
    }

    public IS getGuarantorType() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getGt110_GuarantorType() {
        IS retVal = (IS)this.getTypedField(10, 0);
        return retVal;
    }

    public IS getGuarantorRelationship() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public IS getGt111_GuarantorRelationship() {
        IS retVal = (IS)this.getTypedField(11, 0);
        return retVal;
    }

    public ST getGuarantorSSN() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public ST getGt112_GuarantorSSN() {
        ST retVal = (ST)this.getTypedField(12, 0);
        return retVal;
    }

    public DT getGuarantorDateBegin() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getGt113_GuarantorDateBegin() {
        DT retVal = (DT)this.getTypedField(13, 0);
        return retVal;
    }

    public DT getGuarantorDateEnd() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public DT getGt114_GuarantorDateEnd() {
        DT retVal = (DT)this.getTypedField(14, 0);
        return retVal;
    }

    public NM getGuarantorPriority() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public NM getGt115_GuarantorPriority() {
        NM retVal = (NM)this.getTypedField(15, 0);
        return retVal;
    }

    public XPN[] getGuarantorEmployerName() {
        XPN[] retVal = (XPN[])this.getTypedField(16, new XPN[0]);
        return retVal;
    }

    public XPN[] getGt116_GuarantorEmployerName() {
        XPN[] retVal = (XPN[])this.getTypedField(16, new XPN[0]);
        return retVal;
    }

    public int getGuarantorEmployerNameReps() {
        return this.getReps(16);
    }

    public XPN getGuarantorEmployerName(int rep) {
        XPN retVal = (XPN)this.getTypedField(16, rep);
        return retVal;
    }

    public XPN getGt116_GuarantorEmployerName(int rep) {
        XPN retVal = (XPN)this.getTypedField(16, rep);
        return retVal;
    }

    public int getGt116_GuarantorEmployerNameReps() {
        return this.getReps(16);
    }

    public XPN insertGuarantorEmployerName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(16, rep);
    }

    public XPN insertGt116_GuarantorEmployerName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(16, rep);
    }

    public XPN removeGuarantorEmployerName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(16, rep);
    }

    public XPN removeGt116_GuarantorEmployerName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(16, rep);
    }

    public XAD[] getGuarantorEmployerAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(17, new XAD[0]);
        return retVal;
    }

    public XAD[] getGt117_GuarantorEmployerAddress() {
        XAD[] retVal = (XAD[])this.getTypedField(17, new XAD[0]);
        return retVal;
    }

    public int getGuarantorEmployerAddressReps() {
        return this.getReps(17);
    }

    public XAD getGuarantorEmployerAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(17, rep);
        return retVal;
    }

    public XAD getGt117_GuarantorEmployerAddress(int rep) {
        XAD retVal = (XAD)this.getTypedField(17, rep);
        return retVal;
    }

    public int getGt117_GuarantorEmployerAddressReps() {
        return this.getReps(17);
    }

    public XAD insertGuarantorEmployerAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(17, rep);
    }

    public XAD insertGt117_GuarantorEmployerAddress(int rep) throws HL7Exception {
        return (XAD)super.insertRepetition(17, rep);
    }

    public XAD removeGuarantorEmployerAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(17, rep);
    }

    public XAD removeGt117_GuarantorEmployerAddress(int rep) throws HL7Exception {
        return (XAD)super.removeRepetition(17, rep);
    }

    public XTN[] getGuarantorEmployPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(18, new XTN[0]);
        return retVal;
    }

    public XTN[] getGt118_GuarantorEmployPhoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(18, new XTN[0]);
        return retVal;
    }

    public int getGuarantorEmployPhoneNumberReps() {
        return this.getReps(18);
    }

    public XTN getGuarantorEmployPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(18, rep);
        return retVal;
    }

    public XTN getGt118_GuarantorEmployPhoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(18, rep);
        return retVal;
    }

    public int getGt118_GuarantorEmployPhoneNumberReps() {
        return this.getReps(18);
    }

    public XTN insertGuarantorEmployPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(18, rep);
    }

    public XTN insertGt118_GuarantorEmployPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(18, rep);
    }

    public XTN removeGuarantorEmployPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(18, rep);
    }

    public XTN removeGt118_GuarantorEmployPhoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(18, rep);
    }

    public CX[] getGuarantorEmployeeIDNumber() {
        CX[] retVal = (CX[])this.getTypedField(19, new CX[0]);
        return retVal;
    }

    public CX[] getGt119_GuarantorEmployeeIDNumber() {
        CX[] retVal = (CX[])this.getTypedField(19, new CX[0]);
        return retVal;
    }

    public int getGuarantorEmployeeIDNumberReps() {
        return this.getReps(19);
    }

    public CX getGuarantorEmployeeIDNumber(int rep) {
        CX retVal = (CX)this.getTypedField(19, rep);
        return retVal;
    }

    public CX getGt119_GuarantorEmployeeIDNumber(int rep) {
        CX retVal = (CX)this.getTypedField(19, rep);
        return retVal;
    }

    public int getGt119_GuarantorEmployeeIDNumberReps() {
        return this.getReps(19);
    }

    public CX insertGuarantorEmployeeIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(19, rep);
    }

    public CX insertGt119_GuarantorEmployeeIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(19, rep);
    }

    public CX removeGuarantorEmployeeIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(19, rep);
    }

    public CX removeGt119_GuarantorEmployeeIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(19, rep);
    }

    public IS getGuarantorEmploymentStatus() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public IS getGt120_GuarantorEmploymentStatus() {
        IS retVal = (IS)this.getTypedField(20, 0);
        return retVal;
    }

    public XON[] getGuarantorOrganization() {
        XON[] retVal = (XON[])this.getTypedField(21, new XON[0]);
        return retVal;
    }

    public XON[] getGt121_GuarantorOrganization() {
        XON[] retVal = (XON[])this.getTypedField(21, new XON[0]);
        return retVal;
    }

    public int getGuarantorOrganizationReps() {
        return this.getReps(21);
    }

    public XON getGuarantorOrganization(int rep) {
        XON retVal = (XON)this.getTypedField(21, rep);
        return retVal;
    }

    public XON getGt121_GuarantorOrganization(int rep) {
        XON retVal = (XON)this.getTypedField(21, rep);
        return retVal;
    }

    public int getGt121_GuarantorOrganizationReps() {
        return this.getReps(21);
    }

    public XON insertGuarantorOrganization(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(21, rep);
    }

    public XON insertGt121_GuarantorOrganization(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(21, rep);
    }

    public XON removeGuarantorOrganization(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(21, rep);
    }

    public XON removeGt121_GuarantorOrganization(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(21, rep);
    }

    public ID getGuarantorBillingHoldFlag() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public ID getGt122_GuarantorBillingHoldFlag() {
        ID retVal = (ID)this.getTypedField(22, 0);
        return retVal;
    }

    public CE getGuarantorCreditRatingCode() {
        CE retVal = (CE)this.getTypedField(23, 0);
        return retVal;
    }

    public CE getGt123_GuarantorCreditRatingCode() {
        CE retVal = (CE)this.getTypedField(23, 0);
        return retVal;
    }

    public TS getGuarantorDeathDateAndTime() {
        TS retVal = (TS)this.getTypedField(24, 0);
        return retVal;
    }

    public TS getGt124_GuarantorDeathDateAndTime() {
        TS retVal = (TS)this.getTypedField(24, 0);
        return retVal;
    }

    public ID getGuarantorDeathFlag() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public ID getGt125_GuarantorDeathFlag() {
        ID retVal = (ID)this.getTypedField(25, 0);
        return retVal;
    }

    public CE getGuarantorChargeAdjustmentCode() {
        CE retVal = (CE)this.getTypedField(26, 0);
        return retVal;
    }

    public CE getGt126_GuarantorChargeAdjustmentCode() {
        CE retVal = (CE)this.getTypedField(26, 0);
        return retVal;
    }

    public CP getGuarantorHouseholdAnnualIncome() {
        CP retVal = (CP)this.getTypedField(27, 0);
        return retVal;
    }

    public CP getGt127_GuarantorHouseholdAnnualIncome() {
        CP retVal = (CP)this.getTypedField(27, 0);
        return retVal;
    }

    public NM getGuarantorHouseholdSize() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public NM getGt128_GuarantorHouseholdSize() {
        NM retVal = (NM)this.getTypedField(28, 0);
        return retVal;
    }

    public CX[] getGuarantorEmployerIDNumber() {
        CX[] retVal = (CX[])this.getTypedField(29, new CX[0]);
        return retVal;
    }

    public CX[] getGt129_GuarantorEmployerIDNumber() {
        CX[] retVal = (CX[])this.getTypedField(29, new CX[0]);
        return retVal;
    }

    public int getGuarantorEmployerIDNumberReps() {
        return this.getReps(29);
    }

    public CX getGuarantorEmployerIDNumber(int rep) {
        CX retVal = (CX)this.getTypedField(29, rep);
        return retVal;
    }

    public CX getGt129_GuarantorEmployerIDNumber(int rep) {
        CX retVal = (CX)this.getTypedField(29, rep);
        return retVal;
    }

    public int getGt129_GuarantorEmployerIDNumberReps() {
        return this.getReps(29);
    }

    public CX insertGuarantorEmployerIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(29, rep);
    }

    public CX insertGt129_GuarantorEmployerIDNumber(int rep) throws HL7Exception {
        return (CX)super.insertRepetition(29, rep);
    }

    public CX removeGuarantorEmployerIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(29, rep);
    }

    public CX removeGt129_GuarantorEmployerIDNumber(int rep) throws HL7Exception {
        return (CX)super.removeRepetition(29, rep);
    }

    public IS getGuarantorMaritalStatusCode() {
        IS retVal = (IS)this.getTypedField(30, 0);
        return retVal;
    }

    public IS getGt130_GuarantorMaritalStatusCode() {
        IS retVal = (IS)this.getTypedField(30, 0);
        return retVal;
    }

    public DT getGuarantorHireEffectiveDate() {
        DT retVal = (DT)this.getTypedField(31, 0);
        return retVal;
    }

    public DT getGt131_GuarantorHireEffectiveDate() {
        DT retVal = (DT)this.getTypedField(31, 0);
        return retVal;
    }

    public DT getEmploymentStopDate() {
        DT retVal = (DT)this.getTypedField(32, 0);
        return retVal;
    }

    public DT getGt132_EmploymentStopDate() {
        DT retVal = (DT)this.getTypedField(32, 0);
        return retVal;
    }

    public IS getLivingDependency() {
        IS retVal = (IS)this.getTypedField(33, 0);
        return retVal;
    }

    public IS getGt133_LivingDependency() {
        IS retVal = (IS)this.getTypedField(33, 0);
        return retVal;
    }

    public IS getAmbulatoryStatus() {
        IS retVal = (IS)this.getTypedField(34, 0);
        return retVal;
    }

    public IS getGt134_AmbulatoryStatus() {
        IS retVal = (IS)this.getTypedField(34, 0);
        return retVal;
    }

    public IS getCitizenship() {
        IS retVal = (IS)this.getTypedField(35, 0);
        return retVal;
    }

    public IS getGt135_Citizenship() {
        IS retVal = (IS)this.getTypedField(35, 0);
        return retVal;
    }

    public CE getPrimaryLanguage() {
        CE retVal = (CE)this.getTypedField(36, 0);
        return retVal;
    }

    public CE getGt136_PrimaryLanguage() {
        CE retVal = (CE)this.getTypedField(36, 0);
        return retVal;
    }

    public IS getLivingArrangement() {
        IS retVal = (IS)this.getTypedField(37, 0);
        return retVal;
    }

    public IS getGt137_LivingArrangement() {
        IS retVal = (IS)this.getTypedField(37, 0);
        return retVal;
    }

    public CE getPublicityIndicator() {
        CE retVal = (CE)this.getTypedField(38, 0);
        return retVal;
    }

    public CE getGt138_PublicityIndicator() {
        CE retVal = (CE)this.getTypedField(38, 0);
        return retVal;
    }

    public ID getProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(39, 0);
        return retVal;
    }

    public ID getGt139_ProtectionIndicator() {
        ID retVal = (ID)this.getTypedField(39, 0);
        return retVal;
    }

    public IS getStudentIndicator() {
        IS retVal = (IS)this.getTypedField(40, 0);
        return retVal;
    }

    public IS getGt140_StudentIndicator() {
        IS retVal = (IS)this.getTypedField(40, 0);
        return retVal;
    }

    public IS getReligion() {
        IS retVal = (IS)this.getTypedField(41, 0);
        return retVal;
    }

    public IS getGt141_Religion() {
        IS retVal = (IS)this.getTypedField(41, 0);
        return retVal;
    }

    public XPN getMotherSMaidenName() {
        XPN retVal = (XPN)this.getTypedField(42, 0);
        return retVal;
    }

    public XPN getGt142_MotherSMaidenName() {
        XPN retVal = (XPN)this.getTypedField(42, 0);
        return retVal;
    }

    public CE getNationalityCode() {
        CE retVal = (CE)this.getTypedField(43, 0);
        return retVal;
    }

    public CE getGt143_NationalityCode() {
        CE retVal = (CE)this.getTypedField(43, 0);
        return retVal;
    }

    public IS getEthnicGroup() {
        IS retVal = (IS)this.getTypedField(44, 0);
        return retVal;
    }

    public IS getGt144_EthnicGroup() {
        IS retVal = (IS)this.getTypedField(44, 0);
        return retVal;
    }

    public XPN[] getContactPersonSName() {
        XPN[] retVal = (XPN[])this.getTypedField(45, new XPN[0]);
        return retVal;
    }

    public XPN[] getGt145_ContactPersonSName() {
        XPN[] retVal = (XPN[])this.getTypedField(45, new XPN[0]);
        return retVal;
    }

    public int getContactPersonSNameReps() {
        return this.getReps(45);
    }

    public XPN getContactPersonSName(int rep) {
        XPN retVal = (XPN)this.getTypedField(45, rep);
        return retVal;
    }

    public XPN getGt145_ContactPersonSName(int rep) {
        XPN retVal = (XPN)this.getTypedField(45, rep);
        return retVal;
    }

    public int getGt145_ContactPersonSNameReps() {
        return this.getReps(45);
    }

    public XPN insertContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(45, rep);
    }

    public XPN insertGt145_ContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.insertRepetition(45, rep);
    }

    public XPN removeContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(45, rep);
    }

    public XPN removeGt145_ContactPersonSName(int rep) throws HL7Exception {
        return (XPN)super.removeRepetition(45, rep);
    }

    public XTN[] getContactPersonSTelephoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(46, new XTN[0]);
        return retVal;
    }

    public XTN[] getGt146_ContactPersonSTelephoneNumber() {
        XTN[] retVal = (XTN[])this.getTypedField(46, new XTN[0]);
        return retVal;
    }

    public int getContactPersonSTelephoneNumberReps() {
        return this.getReps(46);
    }

    public XTN getContactPersonSTelephoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(46, rep);
        return retVal;
    }

    public XTN getGt146_ContactPersonSTelephoneNumber(int rep) {
        XTN retVal = (XTN)this.getTypedField(46, rep);
        return retVal;
    }

    public int getGt146_ContactPersonSTelephoneNumberReps() {
        return this.getReps(46);
    }

    public XTN insertContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(46, rep);
    }

    public XTN insertGt146_ContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.insertRepetition(46, rep);
    }

    public XTN removeContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(46, rep);
    }

    public XTN removeGt146_ContactPersonSTelephoneNumber(int rep) throws HL7Exception {
        return (XTN)super.removeRepetition(46, rep);
    }

    public CE getContactReason() {
        CE retVal = (CE)this.getTypedField(47, 0);
        return retVal;
    }

    public CE getGt147_ContactReason() {
        CE retVal = (CE)this.getTypedField(47, 0);
        return retVal;
    }

    public IS getContactRelationshipCode() {
        IS retVal = (IS)this.getTypedField(48, 0);
        return retVal;
    }

    public IS getGt148_ContactRelationshipCode() {
        IS retVal = (IS)this.getTypedField(48, 0);
        return retVal;
    }

    public ST getJobTitle() {
        ST retVal = (ST)this.getTypedField(49, 0);
        return retVal;
    }

    public ST getGt149_JobTitle() {
        ST retVal = (ST)this.getTypedField(49, 0);
        return retVal;
    }

    public JCC getJobCodeClass() {
        JCC retVal = (JCC)this.getTypedField(50, 0);
        return retVal;
    }

    public JCC getGt150_JobCodeClass() {
        JCC retVal = (JCC)this.getTypedField(50, 0);
        return retVal;
    }

    public XON[] getGuarantorEmployerSOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(51, new XON[0]);
        return retVal;
    }

    public XON[] getGt151_GuarantorEmployerSOrganizationName() {
        XON[] retVal = (XON[])this.getTypedField(51, new XON[0]);
        return retVal;
    }

    public int getGuarantorEmployerSOrganizationNameReps() {
        return this.getReps(51);
    }

    public XON getGuarantorEmployerSOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(51, rep);
        return retVal;
    }

    public XON getGt151_GuarantorEmployerSOrganizationName(int rep) {
        XON retVal = (XON)this.getTypedField(51, rep);
        return retVal;
    }

    public int getGt151_GuarantorEmployerSOrganizationNameReps() {
        return this.getReps(51);
    }

    public XON insertGuarantorEmployerSOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(51, rep);
    }

    public XON insertGt151_GuarantorEmployerSOrganizationName(int rep) throws HL7Exception {
        return (XON)super.insertRepetition(51, rep);
    }

    public XON removeGuarantorEmployerSOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(51, rep);
    }

    public XON removeGt151_GuarantorEmployerSOrganizationName(int rep) throws HL7Exception {
        return (XON)super.removeRepetition(51, rep);
    }

    public IS getHandicap() {
        IS retVal = (IS)this.getTypedField(52, 0);
        return retVal;
    }

    public IS getGt152_Handicap() {
        IS retVal = (IS)this.getTypedField(52, 0);
        return retVal;
    }

    public IS getJobStatus() {
        IS retVal = (IS)this.getTypedField(53, 0);
        return retVal;
    }

    public IS getGt153_JobStatus() {
        IS retVal = (IS)this.getTypedField(53, 0);
        return retVal;
    }

    public FC getGuarantorFinancialClass() {
        FC retVal = (FC)this.getTypedField(54, 0);
        return retVal;
    }

    public FC getGt154_GuarantorFinancialClass() {
        FC retVal = (FC)this.getTypedField(54, 0);
        return retVal;
    }

    public IS getGuarantorRace() {
        IS retVal = (IS)this.getTypedField(55, 0);
        return retVal;
    }

    public IS getGt155_GuarantorRace() {
        IS retVal = (IS)this.getTypedField(55, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new SI(this.getMessage());
            }
            case 1: {
                return new CX(this.getMessage());
            }
            case 2: {
                return new XPN(this.getMessage());
            }
            case 3: {
                return new XPN(this.getMessage());
            }
            case 4: {
                return new XAD(this.getMessage());
            }
            case 5: {
                return new XTN(this.getMessage());
            }
            case 6: {
                return new XTN(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new IS(this.getMessage(), new Integer(1));
            }
            case 9: {
                return new IS(this.getMessage(), new Integer(68));
            }
            case 10: {
                return new IS(this.getMessage(), new Integer(63));
            }
            case 11: {
                return new ST(this.getMessage());
            }
            case 12: {
                return new DT(this.getMessage());
            }
            case 13: {
                return new DT(this.getMessage());
            }
            case 14: {
                return new NM(this.getMessage());
            }
            case 15: {
                return new XPN(this.getMessage());
            }
            case 16: {
                return new XAD(this.getMessage());
            }
            case 17: {
                return new XTN(this.getMessage());
            }
            case 18: {
                return new CX(this.getMessage());
            }
            case 19: {
                return new IS(this.getMessage(), new Integer(66));
            }
            case 20: {
                return new XON(this.getMessage());
            }
            case 21: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 22: {
                return new CE(this.getMessage());
            }
            case 23: {
                return new TS(this.getMessage());
            }
            case 24: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 25: {
                return new CE(this.getMessage());
            }
            case 26: {
                return new CP(this.getMessage());
            }
            case 27: {
                return new NM(this.getMessage());
            }
            case 28: {
                return new CX(this.getMessage());
            }
            case 29: {
                return new IS(this.getMessage(), new Integer(0));
            }
            case 30: {
                return new DT(this.getMessage());
            }
            case 31: {
                return new DT(this.getMessage());
            }
            case 32: {
                return new IS(this.getMessage(), new Integer(223));
            }
            case 33: {
                return new IS(this.getMessage(), new Integer(9));
            }
            case 34: {
                return new IS(this.getMessage(), new Integer(171));
            }
            case 35: {
                return new CE(this.getMessage());
            }
            case 36: {
                return new IS(this.getMessage(), new Integer(220));
            }
            case 37: {
                return new CE(this.getMessage());
            }
            case 38: {
                return new ID(this.getMessage(), new Integer(136));
            }
            case 39: {
                return new IS(this.getMessage(), new Integer(231));
            }
            case 40: {
                return new IS(this.getMessage(), new Integer(6));
            }
            case 41: {
                return new XPN(this.getMessage());
            }
            case 42: {
                return new CE(this.getMessage());
            }
            case 43: {
                return new IS(this.getMessage(), new Integer(189));
            }
            case 44: {
                return new XPN(this.getMessage());
            }
            case 45: {
                return new XTN(this.getMessage());
            }
            case 46: {
                return new CE(this.getMessage());
            }
            case 47: {
                return new IS(this.getMessage(), new Integer(63));
            }
            case 48: {
                return new ST(this.getMessage());
            }
            case 49: {
                return new JCC(this.getMessage());
            }
            case 50: {
                return new XON(this.getMessage());
            }
            case 51: {
                return new IS(this.getMessage(), new Integer(310));
            }
            case 52: {
                return new IS(this.getMessage(), new Integer(311));
            }
            case 53: {
                return new FC(this.getMessage());
            }
            case 54: {
                return new IS(this.getMessage(), new Integer(5));
            }
        }
        return null;
    }
}

