/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.message;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractMessage;
import ca.uhn.hl7v2.model.v25.group.PMU_B07_CERTIFICATE;
import ca.uhn.hl7v2.model.v25.segment.EVN;
import ca.uhn.hl7v2.model.v25.segment.MSH;
import ca.uhn.hl7v2.model.v25.segment.PRA;
import ca.uhn.hl7v2.model.v25.segment.SFT;
import ca.uhn.hl7v2.model.v25.segment.STF;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PMU_B07
extends AbstractMessage {
    public PMU_B07() {
        this(new DefaultModelClassFactory());
    }

    public PMU_B07(ModelClassFactory factory) {
        super(factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(MSH.class, true, false);
            this.add(SFT.class, false, true);
            this.add(EVN.class, true, false);
            this.add(STF.class, true, false);
            this.add(PRA.class, false, false);
            this.add(PMU_B07_CERTIFICATE.class, false, true);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PMU_B07 - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    @Override
    public String getVersion() {
        return "2.5";
    }

    public MSH getMSH() {
        return this.getTyped("MSH", MSH.class);
    }

    public SFT getSFT() {
        return this.getTyped("SFT", SFT.class);
    }

    public SFT getSFT(int rep) {
        return this.getTyped("SFT", rep, SFT.class);
    }

    public int getSFTReps() {
        return this.getReps("SFT");
    }

    public List<SFT> getSFTAll() throws HL7Exception {
        return this.getAllAsList("SFT", SFT.class);
    }

    public void insertSFT(SFT structure, int rep) throws HL7Exception {
        super.insertRepetition("SFT", structure, rep);
    }

    public SFT insertSFT(int rep) throws HL7Exception {
        return (SFT)super.insertRepetition("SFT", rep);
    }

    public SFT removeSFT(int rep) throws HL7Exception {
        return (SFT)super.removeRepetition("SFT", rep);
    }

    public EVN getEVN() {
        return this.getTyped("EVN", EVN.class);
    }

    public STF getSTF() {
        return this.getTyped("STF", STF.class);
    }

    public PRA getPRA() {
        return this.getTyped("PRA", PRA.class);
    }

    public PMU_B07_CERTIFICATE getCERTIFICATE() {
        return this.getTyped("CERTIFICATE", PMU_B07_CERTIFICATE.class);
    }

    public PMU_B07_CERTIFICATE getCERTIFICATE(int rep) {
        return this.getTyped("CERTIFICATE", rep, PMU_B07_CERTIFICATE.class);
    }

    public int getCERTIFICATEReps() {
        return this.getReps("CERTIFICATE");
    }

    public List<PMU_B07_CERTIFICATE> getCERTIFICATEAll() throws HL7Exception {
        return this.getAllAsList("CERTIFICATE", PMU_B07_CERTIFICATE.class);
    }

    public void insertCERTIFICATE(PMU_B07_CERTIFICATE structure, int rep) throws HL7Exception {
        super.insertRepetition("CERTIFICATE", structure, rep);
    }

    public PMU_B07_CERTIFICATE insertCERTIFICATE(int rep) throws HL7Exception {
        return (PMU_B07_CERTIFICATE)super.insertRepetition("CERTIFICATE", rep);
    }

    public PMU_B07_CERTIFICATE removeCERTIFICATE(int rep) throws HL7Exception {
        return (PMU_B07_CERTIFICATE)super.removeRepetition("CERTIFICATE", rep);
    }
}

