/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v251.segment;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractSegment;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.v251.datatype.CE;
import ca.uhn.hl7v2.model.v251.datatype.EI;
import ca.uhn.hl7v2.model.v251.datatype.ID;
import ca.uhn.hl7v2.model.v251.datatype.NM;
import ca.uhn.hl7v2.model.v251.datatype.ST;
import ca.uhn.hl7v2.model.v251.datatype.TS;
import ca.uhn.hl7v2.parser.ModelClassFactory;

public class PRB
extends AbstractSegment {
    public PRB(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ID.class, true, 1, 2, new Object[]{this.getMessage(), new Integer(287)}, "Action Code");
            this.add(TS.class, true, 1, 26, new Object[]{this.getMessage()}, "Action Date/Time");
            this.add(CE.class, true, 1, 250, new Object[]{this.getMessage()}, "Problem ID");
            this.add(EI.class, true, 1, 60, new Object[]{this.getMessage()}, "Problem Instance ID");
            this.add(EI.class, false, 1, 60, new Object[]{this.getMessage()}, "Episode of Care ID");
            this.add(NM.class, false, 1, 60, new Object[]{this.getMessage()}, "Problem List Priority");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Problem Established Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Anticipated Problem Resolution Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Actual Problem Resolution Date/Time");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Problem Classification");
            this.add(CE.class, false, 0, 250, new Object[]{this.getMessage()}, "Problem Management Discipline");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Problem Persistence");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Problem Confirmation Status");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Problem Life Cycle Status");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Problem Life Cycle Status Date/Time");
            this.add(TS.class, false, 1, 26, new Object[]{this.getMessage()}, "Problem Date of Onset");
            this.add(ST.class, false, 1, 80, new Object[]{this.getMessage()}, "Problem Onset Text");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Problem Ranking");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Certainty of Problem");
            this.add(NM.class, false, 1, 5, new Object[]{this.getMessage()}, "Probability of Problem (0-1)");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Individual Awareness of Problem");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Problem Prognosis");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Individual Awareness of Prognosis");
            this.add(ST.class, false, 1, 200, new Object[]{this.getMessage()}, "Family/Significant Other Awareness of Problem/Prognosis");
            this.add(CE.class, false, 1, 250, new Object[]{this.getMessage()}, "Security/Sensitivity");
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating PRB - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public ID getActionCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public ID getPrb1_ActionCode() {
        ID retVal = (ID)this.getTypedField(1, 0);
        return retVal;
    }

    public TS getActionDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public TS getPrb2_ActionDateTime() {
        TS retVal = (TS)this.getTypedField(2, 0);
        return retVal;
    }

    public CE getProblemID() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public CE getPrb3_ProblemID() {
        CE retVal = (CE)this.getTypedField(3, 0);
        return retVal;
    }

    public EI getProblemInstanceID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getPrb4_ProblemInstanceID() {
        EI retVal = (EI)this.getTypedField(4, 0);
        return retVal;
    }

    public EI getEpisodeOfCareID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public EI getPrb5_EpisodeOfCareID() {
        EI retVal = (EI)this.getTypedField(5, 0);
        return retVal;
    }

    public NM getProblemListPriority() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public NM getPrb6_ProblemListPriority() {
        NM retVal = (NM)this.getTypedField(6, 0);
        return retVal;
    }

    public TS getProblemEstablishedDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getPrb7_ProblemEstablishedDateTime() {
        TS retVal = (TS)this.getTypedField(7, 0);
        return retVal;
    }

    public TS getAnticipatedProblemResolutionDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getPrb8_AnticipatedProblemResolutionDateTime() {
        TS retVal = (TS)this.getTypedField(8, 0);
        return retVal;
    }

    public TS getActualProblemResolutionDateTime() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public TS getPrb9_ActualProblemResolutionDateTime() {
        TS retVal = (TS)this.getTypedField(9, 0);
        return retVal;
    }

    public CE getProblemClassification() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE getPrb10_ProblemClassification() {
        CE retVal = (CE)this.getTypedField(10, 0);
        return retVal;
    }

    public CE[] getProblemManagementDiscipline() {
        CE[] retVal = (CE[])this.getTypedField(11, new CE[0]);
        return retVal;
    }

    public CE[] getPrb11_ProblemManagementDiscipline() {
        CE[] retVal = (CE[])this.getTypedField(11, new CE[0]);
        return retVal;
    }

    public int getProblemManagementDisciplineReps() {
        return this.getReps(11);
    }

    public CE getProblemManagementDiscipline(int rep) {
        CE retVal = (CE)this.getTypedField(11, rep);
        return retVal;
    }

    public CE getPrb11_ProblemManagementDiscipline(int rep) {
        CE retVal = (CE)this.getTypedField(11, rep);
        return retVal;
    }

    public int getPrb11_ProblemManagementDisciplineReps() {
        return this.getReps(11);
    }

    public CE insertProblemManagementDiscipline(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(11, rep);
    }

    public CE insertPrb11_ProblemManagementDiscipline(int rep) throws HL7Exception {
        return (CE)super.insertRepetition(11, rep);
    }

    public CE removeProblemManagementDiscipline(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(11, rep);
    }

    public CE removePrb11_ProblemManagementDiscipline(int rep) throws HL7Exception {
        return (CE)super.removeRepetition(11, rep);
    }

    public CE getProblemPersistence() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getPrb12_ProblemPersistence() {
        CE retVal = (CE)this.getTypedField(12, 0);
        return retVal;
    }

    public CE getProblemConfirmationStatus() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getPrb13_ProblemConfirmationStatus() {
        CE retVal = (CE)this.getTypedField(13, 0);
        return retVal;
    }

    public CE getProblemLifeCycleStatus() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public CE getPrb14_ProblemLifeCycleStatus() {
        CE retVal = (CE)this.getTypedField(14, 0);
        return retVal;
    }

    public TS getProblemLifeCycleStatusDateTime() {
        TS retVal = (TS)this.getTypedField(15, 0);
        return retVal;
    }

    public TS getPrb15_ProblemLifeCycleStatusDateTime() {
        TS retVal = (TS)this.getTypedField(15, 0);
        return retVal;
    }

    public TS getProblemDateOfOnset() {
        TS retVal = (TS)this.getTypedField(16, 0);
        return retVal;
    }

    public TS getPrb16_ProblemDateOfOnset() {
        TS retVal = (TS)this.getTypedField(16, 0);
        return retVal;
    }

    public ST getProblemOnsetText() {
        ST retVal = (ST)this.getTypedField(17, 0);
        return retVal;
    }

    public ST getPrb17_ProblemOnsetText() {
        ST retVal = (ST)this.getTypedField(17, 0);
        return retVal;
    }

    public CE getProblemRanking() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getPrb18_ProblemRanking() {
        CE retVal = (CE)this.getTypedField(18, 0);
        return retVal;
    }

    public CE getCertaintyOfProblem() {
        CE retVal = (CE)this.getTypedField(19, 0);
        return retVal;
    }

    public CE getPrb19_CertaintyOfProblem() {
        CE retVal = (CE)this.getTypedField(19, 0);
        return retVal;
    }

    public NM getProbabilityOfProblem() {
        NM retVal = (NM)this.getTypedField(20, 0);
        return retVal;
    }

    public NM getPrb20_ProbabilityOfProblem() {
        NM retVal = (NM)this.getTypedField(20, 0);
        return retVal;
    }

    public CE getIndividualAwarenessOfProblem() {
        CE retVal = (CE)this.getTypedField(21, 0);
        return retVal;
    }

    public CE getPrb21_IndividualAwarenessOfProblem() {
        CE retVal = (CE)this.getTypedField(21, 0);
        return retVal;
    }

    public CE getProblemPrognosis() {
        CE retVal = (CE)this.getTypedField(22, 0);
        return retVal;
    }

    public CE getPrb22_ProblemPrognosis() {
        CE retVal = (CE)this.getTypedField(22, 0);
        return retVal;
    }

    public CE getIndividualAwarenessOfPrognosis() {
        CE retVal = (CE)this.getTypedField(23, 0);
        return retVal;
    }

    public CE getPrb23_IndividualAwarenessOfPrognosis() {
        CE retVal = (CE)this.getTypedField(23, 0);
        return retVal;
    }

    public ST getFamilySignificantOtherAwarenessOfProblemPrognosis() {
        ST retVal = (ST)this.getTypedField(24, 0);
        return retVal;
    }

    public ST getPrb24_FamilySignificantOtherAwarenessOfProblemPrognosis() {
        ST retVal = (ST)this.getTypedField(24, 0);
        return retVal;
    }

    public CE getSecuritySensitivity() {
        CE retVal = (CE)this.getTypedField(25, 0);
        return retVal;
    }

    public CE getPrb25_SecuritySensitivity() {
        CE retVal = (CE)this.getTypedField(25, 0);
        return retVal;
    }

    protected Type createNewTypeWithoutReflection(int field) {
        switch (field) {
            case 0: {
                return new ID(this.getMessage(), new Integer(287));
            }
            case 1: {
                return new TS(this.getMessage());
            }
            case 2: {
                return new CE(this.getMessage());
            }
            case 3: {
                return new EI(this.getMessage());
            }
            case 4: {
                return new EI(this.getMessage());
            }
            case 5: {
                return new NM(this.getMessage());
            }
            case 6: {
                return new TS(this.getMessage());
            }
            case 7: {
                return new TS(this.getMessage());
            }
            case 8: {
                return new TS(this.getMessage());
            }
            case 9: {
                return new CE(this.getMessage());
            }
            case 10: {
                return new CE(this.getMessage());
            }
            case 11: {
                return new CE(this.getMessage());
            }
            case 12: {
                return new CE(this.getMessage());
            }
            case 13: {
                return new CE(this.getMessage());
            }
            case 14: {
                return new TS(this.getMessage());
            }
            case 15: {
                return new TS(this.getMessage());
            }
            case 16: {
                return new ST(this.getMessage());
            }
            case 17: {
                return new CE(this.getMessage());
            }
            case 18: {
                return new CE(this.getMessage());
            }
            case 19: {
                return new NM(this.getMessage());
            }
            case 20: {
                return new CE(this.getMessage());
            }
            case 21: {
                return new CE(this.getMessage());
            }
            case 22: {
                return new CE(this.getMessage());
            }
            case 23: {
                return new ST(this.getMessage());
            }
            case 24: {
                return new CE(this.getMessage());
            }
        }
        return null;
    }
}

