/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v26.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.v26.group.RGR_RGR_ORDER;
import ca.uhn.hl7v2.model.v26.group.RGR_RGR_PATIENT;
import ca.uhn.hl7v2.model.v26.segment.QRD;
import ca.uhn.hl7v2.model.v26.segment.QRF;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RGR_RGR_DEFINITION
extends AbstractGroup {
    public RGR_RGR_DEFINITION(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(QRD.class, true, false, false);
            this.add(QRF.class, false, false, false);
            this.add(RGR_RGR_PATIENT.class, false, false, false);
            this.add(RGR_RGR_ORDER.class, true, true, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating RGR_RGR_DEFINITION - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.6";
    }

    public QRD getQRD() {
        QRD retVal = this.getTyped("QRD", QRD.class);
        return retVal;
    }

    public QRF getQRF() {
        QRF retVal = this.getTyped("QRF", QRF.class);
        return retVal;
    }

    public RGR_RGR_PATIENT getPATIENT() {
        RGR_RGR_PATIENT retVal = this.getTyped("PATIENT", RGR_RGR_PATIENT.class);
        return retVal;
    }

    public RGR_RGR_ORDER getORDER() {
        RGR_RGR_ORDER retVal = this.getTyped("ORDER", RGR_RGR_ORDER.class);
        return retVal;
    }

    public RGR_RGR_ORDER getORDER(int rep) {
        RGR_RGR_ORDER retVal = this.getTyped("ORDER", rep, RGR_RGR_ORDER.class);
        return retVal;
    }

    public int getORDERReps() {
        return this.getReps("ORDER");
    }

    public List<RGR_RGR_ORDER> getORDERAll() throws HL7Exception {
        return this.getAllAsList("ORDER", RGR_RGR_ORDER.class);
    }

    public void insertORDER(RGR_RGR_ORDER structure, int rep) throws HL7Exception {
        super.insertRepetition("ORDER", structure, rep);
    }

    public RGR_RGR_ORDER insertORDER(int rep) throws HL7Exception {
        return (RGR_RGR_ORDER)super.insertRepetition("ORDER", rep);
    }

    public RGR_RGR_ORDER removeORDER(int rep) throws HL7Exception {
        return (RGR_RGR_ORDER)super.removeRepetition("ORDER", rep);
    }
}

