/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.util.FilterIterator;
import ca.uhn.hl7v2.util.MessageIterator;
import ca.uhn.hl7v2.util.StructurePredicate;
import java.util.Iterator;
import java.util.Stack;

public class MessageNavigator {
    private Group root;
    private Stack<GroupContext> ancestors;
    private int currentChild;
    private Group currentGroup;
    private String[] childNames;

    public MessageNavigator(Group root) {
        this.root = root;
        this.reset();
    }

    public Group getRoot() {
        return this.root;
    }

    public void drillDown(int childNumber, int rep) throws HL7Exception {
        if (childNumber != -1) {
            Structure s = this.currentGroup.get(this.childNames[childNumber], rep);
            if (!(s instanceof Group)) {
                throw new HL7Exception("Can't drill into segment");
            }
            Group group = (Group)s;
            GroupContext gc = new GroupContext(this.currentGroup, this.currentChild);
            this.ancestors.push(gc);
            this.currentGroup = group;
        }
        this.currentChild = 0;
        this.childNames = this.currentGroup.getNames();
    }

    public void drillDown(int rep) throws HL7Exception {
        this.drillDown(this.currentChild, rep);
    }

    public boolean drillUp() {
        if (!this.ancestors.empty()) {
            GroupContext gc = this.ancestors.pop();
            this.currentGroup = gc.group;
            this.currentChild = gc.child;
            this.childNames = this.currentGroup.getNames();
            return true;
        }
        if (this.currentChild == -1) {
            return false;
        }
        this.currentChild = -1;
        return true;
    }

    public boolean hasNextChild() {
        return this.childNames.length > this.currentChild + 1;
    }

    public void nextChild() throws HL7Exception {
        this.toChild(this.currentChild + 1);
    }

    public String toChild(int child) throws HL7Exception {
        if (child >= 0 && child < this.childNames.length) {
            this.currentChild = child;
            return this.childNames[child];
        }
        throw new HL7Exception("Can't advance to child " + child + " -- only " + this.childNames.length + " children");
    }

    public void reset() {
        this.ancestors = new Stack();
        this.currentGroup = this.root;
        this.currentChild = -1;
        this.childNames = this.currentGroup.getNames();
    }

    public Structure getCurrentStructure(int rep) throws HL7Exception {
        if (this.currentChild != -1) {
            String childName = this.childNames[this.currentChild];
            return this.currentGroup.get(childName, rep);
        }
        return this.currentGroup;
    }

    public Group getCurrentGroup() {
        return this.currentGroup;
    }

    public Structure[] getCurrentChildReps() throws HL7Exception {
        if (this.currentGroup == this.root && this.currentChild == -1) {
            throw new HL7Exception("Pointer is at root of navigator: there is no current child");
        }
        String childName = this.childNames[this.currentChild];
        return this.currentGroup.getAll(childName);
    }

    public String iterate(boolean segmentsOnly, boolean loop) throws HL7Exception {
        Structure start = null;
        start = this.currentChild == -1 ? this.currentGroup : this.currentGroup.get(this.childNames[this.currentChild]);
        Iterator<Structure> it = new MessageIterator(start, "doesn't exist", false);
        if (segmentsOnly) {
            it = new FilterIterator<Structure>(it, new StructurePredicate(Segment.class));
        }
        if (it.hasNext()) {
            Structure next = (Structure)it.next();
            return this.drillHere(next);
        }
        if (loop) {
            this.reset();
            return "";
        }
        throw new HL7Exception("End of message reached while iterating without loop");
    }

    private String drillHere(Structure destination) throws HL7Exception {
        Structure pathElem = destination;
        Stack<Structure> pathStack = new Stack<Structure>();
        Stack<MessageIterator.Index> indexStack = new Stack<MessageIterator.Index>();
        do {
            MessageIterator.Index index = MessageIterator.getIndex(pathElem.getParent(), pathElem);
            indexStack.push(index);
            pathElem = pathElem.getParent();
            pathStack.push(pathElem);
        } while (!this.root.equals(pathElem) && !Message.class.isAssignableFrom(pathElem.getClass()));
        if (!this.root.equals(pathElem)) {
            throw new HL7Exception("The destination provided is not under the root of this navigator");
        }
        this.reset();
        String retVal = null;
        while (!pathStack.isEmpty()) {
            Group parent = (Group)pathStack.pop();
            MessageIterator.Index index = (MessageIterator.Index)indexStack.pop();
            int child = this.search(parent.getNames(), index.name);
            if (!pathStack.isEmpty()) {
                this.drillDown(child, 0);
                continue;
            }
            retVal = this.toChild(child);
        }
        return retVal;
    }

    private int search(Object[] list, Object item) {
        int found = -1;
        for (int i = 0; i < list.length && found == -1; ++i) {
            if (!list[i].equals(item)) continue;
            found = i;
        }
        return found;
    }

    private class GroupContext {
        public Group group;
        public int child;

        public GroupContext(Group g, int c) {
            this.group = g;
            this.child = c;
        }
    }
}

