/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.file.remote;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.camel.component.file.remote.FtpConsumer;
import org.apache.camel.component.file.remote.FtpEndpoint;
import org.apache.camel.component.file.remote.FtpsConfiguration;
import org.apache.camel.component.file.remote.FtpsOperations;
import org.apache.camel.component.file.remote.RemoteFileComponent;
import org.apache.camel.component.file.remote.RemoteFileOperations;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.jsse.SSLContextParameters;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPSClient;
import org.slf4j.Logger;

@UriEndpoint(scheme="ftps", title="FTPS", syntax="ftps:host:port/directoryName", consumerClass=FtpConsumer.class, label="file")
public class FtpsEndpoint
extends FtpEndpoint<FTPFile> {
    @UriParam
    protected FtpsConfiguration configuration;
    protected Map<String, Object> ftpClientKeyStoreParameters;
    protected Map<String, Object> ftpClientTrustStoreParameters;
    protected SSLContextParameters sslContextParameters;

    public FtpsEndpoint() {
    }

    public FtpsEndpoint(String uri, RemoteFileComponent<FTPFile> remoteFileComponent, FtpsConfiguration configuration) {
        super(uri, remoteFileComponent, configuration);
        this.configuration = configuration;
    }

    @Override
    public String getScheme() {
        return this.getFtpsConfiguration().getProtocol();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected FTPClient createFtpClient() throws Exception {
        FTPSClient client = null;
        if (this.sslContextParameters != null) {
            SSLContext context = this.sslContextParameters.createSSLContext();
            client = new FTPSClient(this.getFtpsConfiguration().isImplicit(), context);
            SSLSocket socket = (SSLSocket)context.getSocketFactory().createSocket();
            client.setEnabledCipherSuites(socket.getEnabledCipherSuites());
            client.setEnabledProtocols(socket.getEnabledProtocols());
            client.setNeedClientAuth(socket.getNeedClientAuth());
            client.setWantClientAuth(socket.getWantClientAuth());
            client.setEnabledSessionCreation(socket.getEnableSessionCreation());
        } else {
            String algorithm;
            String password;
            String file;
            String type;
            client = new FTPSClient(this.getFtpsConfiguration().getSecurityProtocol(), this.getFtpsConfiguration().isImplicit());
            if (this.ftpClientKeyStoreParameters != null) {
                type = this.ftpClientKeyStoreParameters.containsKey("type") ? (String)this.ftpClientKeyStoreParameters.get("type") : KeyStore.getDefaultType();
                file = (String)this.ftpClientKeyStoreParameters.get("file");
                password = (String)this.ftpClientKeyStoreParameters.get("password");
                algorithm = this.ftpClientKeyStoreParameters.containsKey("algorithm") ? (String)this.ftpClientKeyStoreParameters.get("algorithm") : KeyManagerFactory.getDefaultAlgorithm();
                String keyPassword = (String)this.ftpClientKeyStoreParameters.get("keyPassword");
                KeyStore keyStore = KeyStore.getInstance(type);
                FileInputStream keyStoreFileInputStream = new FileInputStream(new File(file));
                try {
                    keyStore.load(keyStoreFileInputStream, password.toCharArray());
                }
                finally {
                    IOHelper.close((Closeable)keyStoreFileInputStream, (String)"keyStore", (Logger)this.log);
                }
                KeyManagerFactory keyMgrFactory = KeyManagerFactory.getInstance(algorithm);
                keyMgrFactory.init(keyStore, keyPassword.toCharArray());
                client.setNeedClientAuth(true);
                client.setKeyManager(keyMgrFactory.getKeyManagers()[0]);
            }
            if (this.ftpClientTrustStoreParameters != null) {
                type = this.ftpClientTrustStoreParameters.containsKey("type") ? (String)this.ftpClientTrustStoreParameters.get("type") : KeyStore.getDefaultType();
                file = (String)this.ftpClientTrustStoreParameters.get("file");
                password = (String)this.ftpClientTrustStoreParameters.get("password");
                algorithm = this.ftpClientTrustStoreParameters.containsKey("algorithm") ? (String)this.ftpClientTrustStoreParameters.get("algorithm") : TrustManagerFactory.getDefaultAlgorithm();
                KeyStore trustStore = KeyStore.getInstance(type);
                FileInputStream trustStoreFileInputStream = new FileInputStream(new File(file));
                try {
                    trustStore.load(trustStoreFileInputStream, password.toCharArray());
                }
                finally {
                    IOHelper.close((Closeable)trustStoreFileInputStream, (String)"trustStore", (Logger)this.log);
                }
                TrustManagerFactory trustMgrFactory = TrustManagerFactory.getInstance(algorithm);
                trustMgrFactory.init(trustStore);
                client.setTrustManager(trustMgrFactory.getTrustManagers()[0]);
            }
        }
        return client;
    }

    @Override
    public RemoteFileOperations<FTPFile> createRemoteFileOperations() throws Exception {
        FTPSClient client = this.getFtpsClient();
        if (client == null) {
            client = (FTPSClient)this.createFtpClient();
        }
        if (this.getConfiguration().getReceiveBufferSize() > 0) {
            client.setBufferSize(this.getConfiguration().getReceiveBufferSize());
        }
        if (this.getConfiguration().getConnectTimeout() > -1) {
            client.setConnectTimeout(this.getConfiguration().getConnectTimeout());
        }
        if (this.getConfiguration().getSoTimeout() > -1) {
            this.soTimeout = this.getConfiguration().getSoTimeout();
        }
        this.dataTimeout = this.getConfiguration().getTimeout();
        if (this.ftpClientParameters != null) {
            HashMap localParameters = new HashMap(this.ftpClientParameters);
            Object timeout = localParameters.remove("soTimeout");
            if (timeout != null) {
                this.soTimeout = (Integer)this.getCamelContext().getTypeConverter().convertTo(Integer.TYPE, timeout);
            }
            if ((timeout = localParameters.remove("dataTimeout")) != null) {
                this.dataTimeout = (Integer)this.getCamelContext().getTypeConverter().convertTo(Integer.TYPE, (Object)this.dataTimeout);
            }
            this.setProperties(client, localParameters);
        }
        if (this.ftpClientConfigParameters != null) {
            if (this.ftpClientConfig == null) {
                this.ftpClientConfig = new FTPClientConfig();
            }
            HashMap localConfigParameters = new HashMap(this.ftpClientConfigParameters);
            this.setProperties(this.ftpClientConfig, localConfigParameters);
        }
        if (this.dataTimeout > 0) {
            client.setDataTimeout(this.dataTimeout);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Created FTPClient [connectTimeout: {}, soTimeout: {}, dataTimeout: {}, bufferSize: {}, receiveDataSocketBufferSize: {}, sendDataSocketBufferSize: {}]: {}", new Object[]{client.getConnectTimeout(), this.getSoTimeout(), this.dataTimeout, client.getBufferSize(), client.getReceiveDataSocketBufferSize(), client.getSendDataSocketBufferSize(), client});
        }
        FtpsOperations operations = new FtpsOperations(client, this.getFtpClientConfig());
        operations.setEndpoint(this);
        return operations;
    }

    public FTPSClient getFtpsClient() {
        return (FTPSClient)this.getFtpClient();
    }

    public FtpsConfiguration getFtpsConfiguration() {
        return (FtpsConfiguration)this.getConfiguration();
    }

    public void setFtpClientKeyStoreParameters(Map<String, Object> param) {
        this.ftpClientKeyStoreParameters = param;
    }

    public void setFtpClientTrustStoreParameters(Map<String, Object> param) {
        this.ftpClientTrustStoreParameters = param;
    }

    public SSLContextParameters getSslContextParameters() {
        return this.sslContextParameters;
    }

    public void setSslContextParameters(SSLContextParameters sslContextParameters) {
        this.sslContextParameters = sslContextParameters;
    }
}

