/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Fault;
import javax.wsdl.Operation;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.UnknownExtensibilityElement;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.common.CorrelationKey;
import org.apache.ode.bpel.common.CorrelationKeySet;
import org.apache.ode.bpel.common.FaultException;
import org.apache.ode.bpel.common.ProcessState;
import org.apache.ode.bpel.engine.BpelProcess;
import org.apache.ode.bpel.engine.BrokeredMyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.IMAManager;
import org.apache.ode.bpel.engine.MessageImpl;
import org.apache.ode.bpel.engine.MyRoleMessageExchangeImpl;
import org.apache.ode.bpel.engine.OutstandingRequestManager;
import org.apache.ode.bpel.engine.PartnerRoleMessageExchangeImpl;
import org.apache.ode.bpel.evar.ExternalVariableModule;
import org.apache.ode.bpel.evar.ExternalVariableModuleException;
import org.apache.ode.bpel.evt.CorrelationSetWriteEvent;
import org.apache.ode.bpel.evt.ProcessCompletionEvent;
import org.apache.ode.bpel.evt.ProcessInstanceEvent;
import org.apache.ode.bpel.evt.ProcessInstanceStateChangeEvent;
import org.apache.ode.bpel.evt.ProcessMessageExchangeEvent;
import org.apache.ode.bpel.evt.ProcessTerminationEvent;
import org.apache.ode.bpel.evt.ScopeCompletionEvent;
import org.apache.ode.bpel.evt.ScopeEvent;
import org.apache.ode.bpel.evt.ScopeFaultEvent;
import org.apache.ode.bpel.evt.ScopeStartEvent;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.Message;
import org.apache.ode.bpel.iapi.MessageExchange;
import org.apache.ode.bpel.iapi.MyRoleMessageExchange;
import org.apache.ode.bpel.iapi.PartnerRoleMessageExchange;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.bpel.memdao.ProcessInstanceDaoImpl;
import org.apache.ode.bpel.o.OMessageVarType;
import org.apache.ode.bpel.o.OPartnerLink;
import org.apache.ode.bpel.o.OProcess;
import org.apache.ode.bpel.o.OScope;
import org.apache.ode.bpel.runtime.BpelJacobRunnable;
import org.apache.ode.bpel.runtime.BpelRuntimeContext;
import org.apache.ode.bpel.runtime.CorrelationSetInstance;
import org.apache.ode.bpel.runtime.ExpressionLanguageRuntimeRegistry;
import org.apache.ode.bpel.runtime.PROCESS;
import org.apache.ode.bpel.runtime.PartnerLinkInstance;
import org.apache.ode.bpel.runtime.Selector;
import org.apache.ode.bpel.runtime.VariableInstance;
import org.apache.ode.bpel.runtime.channels.ActivityRecoveryChannel;
import org.apache.ode.bpel.runtime.channels.FaultData;
import org.apache.ode.bpel.runtime.channels.InvokeResponseChannel;
import org.apache.ode.bpel.runtime.channels.PickResponseChannel;
import org.apache.ode.bpel.runtime.channels.TimerResponseChannel;
import org.apache.ode.bpel.wstx.WebServiceTransaction;
import org.apache.ode.bpel.wstx.WebServiceTransactionFactory;
import org.apache.ode.bpel.wstx.WebServiceTransactionType;
import org.apache.ode.dao.bpel.CorrelationSetDAO;
import org.apache.ode.dao.bpel.CorrelatorDAO;
import org.apache.ode.dao.bpel.MessageDAO;
import org.apache.ode.dao.bpel.MessageExchangeDAO;
import org.apache.ode.dao.bpel.MessageRouteDAO;
import org.apache.ode.dao.bpel.PartnerLinkDAO;
import org.apache.ode.dao.bpel.ProcessDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.dao.bpel.ScopeDAO;
import org.apache.ode.dao.bpel.ScopeStateEnum;
import org.apache.ode.dao.bpel.XmlDataDAO;
import org.apache.ode.jacob.JacobRunnable;
import org.apache.ode.jacob.vpu.ExecutionQueueImpl;
import org.apache.ode.jacob.vpu.JacobVPU;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.Namespaces;
import org.apache.ode.utils.ObjectPrinter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BpelRuntimeContextImpl
implements BpelRuntimeContext {
    private static final Log __log = LogFactory.getLog(BpelRuntimeContextImpl.class);
    protected ProcessInstanceDAO _dao;
    private final Long _iid;
    protected JacobVPU _vpu;
    protected ExecutionQueueImpl _soup;
    private MyRoleMessageExchangeImpl _instantiatingMessageExchange;
    protected OutstandingRequestManager _outstandingRequests;
    protected IMAManager _imaManager;
    protected BpelProcess _bpelProcess;
    private Date _currentEventDateTime;
    private long _maxReductionTimeMs = 2000000L;
    private WebServiceTransaction _wst;

    public BpelRuntimeContextImpl(BpelProcess bpelProcess, ProcessInstanceDAO dao, PROCESS PROCESS2, MyRoleMessageExchangeImpl instantiatingMessageExchange) {
        this._bpelProcess = bpelProcess;
        this._wst = bpelProcess.getWebServiceTransaction(dao.getInstanceId());
        this._dao = dao;
        this._iid = dao.getInstanceId();
        this._instantiatingMessageExchange = instantiatingMessageExchange;
        this._vpu = new JacobVPU();
        this._vpu.registerExtension(BpelRuntimeContext.class, this);
        this._soup = new ExecutionQueueImpl(null);
        this._soup.setReplacementMap(this._bpelProcess.getReplacementMap(dao.getProcess().getProcessId()));
        this._outstandingRequests = null;
        this._imaManager = new IMAManager();
        this._vpu.setContext(this._soup);
        if (bpelProcess.isInMemory()) {
            ProcessInstanceDaoImpl inmem = (ProcessInstanceDaoImpl)this._dao;
            if (inmem.getSoup() != null) {
                this._soup = (ExecutionQueueImpl)inmem.getSoup();
                this._imaManager = (IMAManager)this._soup.getGlobalData();
                this._vpu.setContext(this._soup);
            }
        } else {
            byte[] daoState = dao.getExecutionState();
            if (daoState != null) {
                ByteArrayInputStream iis = new ByteArrayInputStream(daoState);
                try {
                    this._soup.read(iis);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                this._imaManager = (IMAManager)this._soup.getGlobalData();
            }
        }
        if (PROCESS2 != null) {
            this._vpu.inject(PROCESS2);
        }
        if (BpelProcess.__log.isDebugEnabled()) {
            __log.debug((Object)("BpelRuntimeContextImpl created for instance " + this._iid + ". INDEXED STATE=" + this._soup.getIndex()));
        }
    }

    @Override
    public Long getPid() {
        return this._iid;
    }

    @Override
    public long genId() {
        return this._dao.genMonotonic();
    }

    @Override
    public boolean isCorrelationInitialized(CorrelationSetInstance correlationSet) {
        ScopeDAO scopeDAO = this._dao.getScope(correlationSet.scopeInstance);
        CorrelationSetDAO cs = scopeDAO.getCorrelationSet(correlationSet.declaration.name);
        return cs.getValue() != null;
    }

    @Override
    public boolean isVariableInitialized(VariableInstance var) {
        if (var == null) {
            return false;
        }
        ScopeDAO scopeDAO = this._dao.getScope(var.scopeInstance);
        XmlDataDAO dataDAO = scopeDAO.getVariable(var.declaration.name);
        return !dataDAO.isNull();
    }

    @Override
    public boolean isPartnerRoleEndpointInitialized(PartnerLinkInstance pLink) {
        PartnerLinkDAO spl = this.fetchPartnerLinkDAO(pLink);
        return spl.getPartnerEPR() != null || this._bpelProcess.getInitialPartnerRoleEPR(pLink.partnerLink) != null;
    }

    @Override
    public void completedFault(FaultData faultData) {
        if (BpelProcess.__log.isDebugEnabled()) {
            BpelProcess.__log.debug((Object)("ProcessImpl completed with fault '" + faultData.getFaultName() + "'"));
        }
        this._dao.setFault(faultData.getFaultName(), faultData.getExplanation(), faultData.getFaultLineNo(), faultData.getActivityId(), faultData.getFaultMessage());
        ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
        evt.setOldState(this._dao.getState());
        this._dao.setState((short)40);
        evt.setNewState((short)40);
        this.sendEvent(evt);
        this.sendEvent(new ProcessCompletionEvent(faultData.getFaultName()));
        this._dao.finishCompletion();
        this.faultOutstandingMessageExchanges(faultData);
        this._bpelProcess._engine._contexts.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

            @Override
            public void afterCompletion(boolean success) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void beforeCompletion() {
                if (BpelRuntimeContextImpl.this._wst != null && BpelRuntimeContextImpl.this._wst.isActive() && !BpelRuntimeContextImpl.this._wst.isSubordinate()) {
                    try {
                        BpelRuntimeContextImpl.this._wst.rollback();
                    }
                    catch (Exception e) {
                        __log.warn((Object)"Web service transaction wasn't properly aborted or it is already rolled back.");
                    }
                    finally {
                        BpelRuntimeContextImpl.this._bpelProcess.removeWebServiceTransaction(BpelRuntimeContextImpl.this._dao.getInstanceId());
                    }
                }
                BpelRuntimeContextImpl.this._dao.delete(BpelRuntimeContextImpl.this._bpelProcess.getCleanupCategories(false), false);
            }
        });
    }

    @Override
    public void completedOk() {
        if (BpelProcess.__log.isDebugEnabled()) {
            BpelProcess.__log.debug((Object)("ProcessImpl " + this._bpelProcess.getPID() + " completed OK."));
        }
        ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
        evt.setOldState(this._dao.getState());
        this._dao.setState((short)30);
        evt.setNewState((short)30);
        this.sendEvent(evt);
        this.sendEvent(new ProcessCompletionEvent(null));
        this._dao.finishCompletion();
        this.completeOutstandingMessageExchanges();
        this._bpelProcess._engine._contexts.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

            @Override
            public void afterCompletion(boolean success) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void beforeCompletion() {
                if (BpelRuntimeContextImpl.this._wst != null && BpelRuntimeContextImpl.this._wst.isActive() && !BpelRuntimeContextImpl.this._wst.isSubordinate()) {
                    try {
                        BpelRuntimeContextImpl.this._wst.commit();
                    }
                    catch (Exception e) {
                        __log.warn((Object)"Web service transaction wasn't commited or it is already commited.");
                    }
                    finally {
                        BpelRuntimeContextImpl.this._bpelProcess.removeWebServiceTransaction(BpelRuntimeContextImpl.this._dao.getInstanceId());
                    }
                }
                BpelRuntimeContextImpl.this._dao.delete(BpelRuntimeContextImpl.this._bpelProcess.getCleanupCategories(true), false);
            }
        });
    }

    @Override
    public Long createScopeInstance(Long parentScopeId, OScope scope) {
        if (BpelProcess.__log.isTraceEnabled()) {
            BpelProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter("createScopeInstance", new Object[]{"parentScopeId", parentScopeId, "scope", scope}));
        }
        ScopeDAO parent = null;
        if (parentScopeId != null) {
            parent = this._dao.getScope(parentScopeId);
        }
        ScopeDAO scopeDao = this._dao.createScope(parent, scope.name, scope.getId());
        return scopeDao.getScopeInstanceId();
    }

    @Override
    public void initializePartnerLinks(Long parentScopeId, Collection<OPartnerLink> partnerLinks) {
        if (BpelProcess.__log.isTraceEnabled()) {
            BpelProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter("initializeEndpointReferences", new Object[]{"parentScopeId", parentScopeId, "partnerLinks", partnerLinks}));
        }
        ScopeDAO parent = this._dao.getScope(parentScopeId);
        for (OPartnerLink partnerLink : partnerLinks) {
            PartnerLinkDAO pdao = parent.createPartnerLink(partnerLink.getId(), partnerLink.name, partnerLink.myRoleName, partnerLink.partnerRoleName);
            if (!partnerLink.hasMyRole()) continue;
            pdao.setMySessionId(new GUID().toString());
        }
    }

    @Override
    public void select(PickResponseChannel pickResponseChannel, Date timeout, boolean createInstance, Selector[] selectors) throws FaultException {
        int i;
        Selector selector2;
        if (BpelProcess.__log.isTraceEnabled()) {
            BpelProcess.__log.trace((Object)ObjectPrinter.stringifyMethodEnter("select", new Object[]{"pickResponseChannel", pickResponseChannel, "timeout", timeout, "createInstance", createInstance, "selectors", selectors}));
        }
        ProcessDAO processDao = this._dao.getProcess();
        if (this._dao.getState() == 0) {
            assert (createInstance);
            ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
            evt.setOldState((short)0);
            this._dao.setState((short)10);
            evt.setNewState((short)10);
            this.sendEvent(evt);
        }
        String pickResponseChannelStr = pickResponseChannel.export();
        ArrayList<CorrelatorDAO> correlators = new ArrayList<CorrelatorDAO>(selectors.length);
        for (Selector selector2 : selectors) {
            String correlatorId = BpelProcess.genCorrelatorId(selector2.plinkInstance.partnerLink, selector2.opName);
            if (BpelProcess.__log.isDebugEnabled()) {
                BpelProcess.__log.debug((Object)("SELECT: " + pickResponseChannel + ": USING CORRELATOR " + correlatorId));
            }
            correlators.add(processDao.getCorrelator(correlatorId));
        }
        int conflict = this._imaManager.findConflict(selectors);
        if (conflict != -1) {
            throw new FaultException(this._bpelProcess.getOProcess().constants.qnConflictingReceive, selectors[conflict].toString());
        }
        for (i = 0; i < selectors.length; ++i) {
            CorrelatorDAO correlator = (CorrelatorDAO)correlators.get(i);
            selector2 = selectors[i];
            if (correlator.checkRoute(selector2.correlationKeySet)) continue;
            throw new FaultException(this._bpelProcess.getOProcess().constants.qnAmbiguousReceive(), selector2.toString());
        }
        this._imaManager.register(pickResponseChannelStr, selectors);
        if (this._instantiatingMessageExchange != null && this._dao.getState() == 10) {
            if (BpelProcess.__log.isDebugEnabled()) {
                BpelProcess.__log.debug((Object)("SELECT: " + pickResponseChannel + ": CHECKING for NEW INSTANCE match"));
            }
            for (i = 0; i < correlators.size(); ++i) {
                CorrelatorDAO ci = (CorrelatorDAO)correlators.get(i);
                if (!ci.equals(this._dao.getInstantiatingCorrelator())) continue;
                this.inputMsgMatch(pickResponseChannelStr, i, this._instantiatingMessageExchange);
                if (BpelProcess.__log.isDebugEnabled()) {
                    BpelProcess.__log.debug((Object)("SELECT: " + pickResponseChannel + ": FOUND match for NEW instance mexRef=" + this._instantiatingMessageExchange));
                }
                return;
            }
        }
        if (timeout != null) {
            this.registerTimer(pickResponseChannel, timeout);
            if (BpelProcess.__log.isDebugEnabled()) {
                BpelProcess.__log.debug((Object)("SELECT: " + pickResponseChannel + "REGISTERED TIMEOUT for " + timeout));
            }
        }
        for (i = 0; i < selectors.length; ++i) {
            CorrelatorDAO correlator = (CorrelatorDAO)correlators.get(i);
            selector2 = selectors[i];
            correlator.addRoute(pickResponseChannel.export(), this._dao, i, selector2.correlationKeySet, selector2.route);
            this.scheduleCorrelatorMatcher(correlator.getCorrelatorId(), selector2.correlationKeySet);
            if (!BpelProcess.__log.isDebugEnabled()) continue;
            BpelProcess.__log.debug((Object)("SELECT: " + pickResponseChannel + ": ADDED ROUTE " + correlator.getCorrelatorId() + ": " + selector2.correlationKeySet + " --> " + this._dao.getInstanceId()));
        }
    }

    @Override
    public CorrelationKey readCorrelation(CorrelationSetInstance cset) {
        ScopeDAO scopeDAO = this._dao.getScope(cset.scopeInstance);
        CorrelationSetDAO cs = scopeDAO.getCorrelationSet(cset.declaration.name);
        return cs.getValue();
    }

    @Override
    public Element fetchPartnerRoleEndpointReferenceData(PartnerLinkInstance pLink) throws FaultException {
        EndpointReference e;
        PartnerLinkDAO pl = this.fetchPartnerLinkDAO(pLink);
        Element epr = pl.getPartnerEPR();
        if (epr == null && (e = this._bpelProcess.getInitialPartnerRoleEPR(pLink.partnerLink)) != null) {
            epr = e.toXML().getDocumentElement();
        }
        if (epr == null) {
            throw new FaultException(this._bpelProcess.getOProcess().constants.qnUninitializedPartnerRole);
        }
        return epr;
    }

    @Override
    public Element fetchMyRoleEndpointReferenceData(PartnerLinkInstance pLink) {
        return this._bpelProcess.getInitialMyRoleEPR(pLink.partnerLink).toXML().getDocumentElement();
    }

    protected PartnerLinkDAO fetchPartnerLinkDAO(PartnerLinkInstance pLink) {
        ScopeDAO scopeDAO = this._dao.getScope(pLink.scopeInstanceId);
        return scopeDAO.getPartnerLink(pLink.partnerLink.getId());
    }

    @Override
    public String readProperty(VariableInstance variable, OProcess.OProperty property) throws FaultException {
        Node varData = this.readVariable(variable.scopeInstance, variable.declaration.name, false);
        OProcess.OPropertyAlias alias = property.getAlias(variable.declaration.type);
        String val = this._bpelProcess.extractProperty((Element)varData, alias, variable.declaration.getDescription());
        if (BpelProcess.__log.isTraceEnabled()) {
            BpelProcess.__log.trace((Object)("readPropertyAlias(variable=" + variable + ", alias=" + alias + ") = " + val.toString()));
        }
        return val;
    }

    @Override
    public void writeEndpointReference(PartnerLinkInstance variable, Element data) throws FaultException {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Writing endpoint reference " + variable.partnerLink.getName() + " with value " + DOMUtils.domToString(data)));
        }
        PartnerLinkDAO eprDAO = this.fetchPartnerLinkDAO(variable);
        eprDAO.setPartnerEPR(data);
    }

    public String fetchEndpointSessionId(PartnerLinkInstance pLink, boolean isMyEPR) throws FaultException {
        PartnerLinkDAO dao = this.fetchPartnerLinkDAO(pLink);
        return isMyEPR ? dao.getMySessionId() : dao.getPartnerSessionId();
    }

    @Override
    public Node convertEndpointReference(Element sourceNode, Node targetNode) {
        QName nodeQName = targetNode.getNodeType() == 3 ? new QName(Namespaces.XML_SCHEMA, "string") : new QName(targetNode.getNamespaceURI(), targetNode.getLocalName());
        return this._bpelProcess._engine._contexts.eprContext.convertEndpoint(nodeQName, sourceNode).toXML();
    }

    @Override
    public Node readVariable(Long scopeInstanceId, String varname, boolean forWriting) throws FaultException {
        ScopeDAO scopedao = this._dao.getScope(scopeInstanceId);
        XmlDataDAO var = scopedao.getVariable(varname);
        return var == null || var.isNull() ? null : var.get();
    }

    @Override
    public Node writeVariable(VariableInstance variable, Node changes) {
        ScopeDAO scopeDAO = this._dao.getScope(variable.scopeInstance);
        XmlDataDAO dataDAO = scopeDAO.getVariable(variable.declaration.name);
        dataDAO.set(changes);
        this.writeProperties(variable, changes, dataDAO);
        return dataDAO.get();
    }

    @Override
    public void cancelOutstandingRequests(String channelId) {
        this._imaManager.cancel(channelId, false);
    }

    @Override
    public void processOutstandingRequest(PartnerLinkInstance partnerLink, String opName, String bpelMexId, String odeMexId) throws FaultException {
        String mexRef = this._imaManager.processOutstandingRequest(partnerLink, opName, bpelMexId, odeMexId);
        if (mexRef != null) {
            this.reply2(partnerLink, opName, bpelMexId, null, this._bpelProcess.getOProcess().constants.qnConflictingRequest, false, mexRef);
            throw new FaultException(this._bpelProcess.getOProcess().constants.qnConflictingRequest);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doAsyncReply(MyRoleMessageExchangeImpl m) {
        MessageExchangeDAO mex = m.getDAO();
        MessageExchange pmex = null;
        if (mex.getPipedMessageExchangeId() != null) {
            pmex = (PartnerRoleMessageExchange)this._bpelProcess.getEngine().getMessageExchange(mex.getPipedMessageExchangeId());
        }
        if (pmex != null) {
            if (BpelProcess.__log.isDebugEnabled()) {
                __log.debug((Object)("Replying to a p2p mex, myrole " + m + " - partnerole " + pmex));
            }
            if (pmex.getStatus() == MessageExchange.Status.ASYNC || pmex.getStatus() == MessageExchange.Status.REQUEST) {
                try {
                    switch (m.getStatus()) {
                        case FAILURE: {
                            pmex.replyWithFailure(MessageExchange.FailureType.OTHER, "operation failed", null);
                            break;
                        }
                        case FAULT: {
                            Fault fault = pmex.getOperation().getFault(m.getFault().getLocalPart());
                            if (fault == null) {
                                __log.error((Object)("process " + this._bpelProcess + " instance " + this._iid + " thrown unmapped fault in p2p communication " + m.getFault() + " " + m.getFaultExplanation() + " - converted to failure"));
                                pmex.replyWithFailure(MessageExchange.FailureType.OTHER, "process thrown unmapped fault in p2p communication " + m.getFault() + " " + m.getFaultExplanation() + " - converted to failure", m.getFaultResponse().getMessage());
                                break;
                            }
                            Message faultRes = pmex.createMessage(pmex.getOperation().getFault(m.getFault().getLocalPart()).getMessage().getQName());
                            faultRes.setMessage(m.getResponse().getMessage());
                            pmex.replyWithFault(m.getFault(), faultRes);
                            break;
                        }
                        case RESPONSE: {
                            Message response = pmex.createMessage(pmex.getOperation().getOutput().getMessage().getQName());
                            response.setMessage(m.getResponse().getMessage());
                            pmex.reply(response);
                            break;
                        }
                        default: {
                            __log.warn((Object)("Unexpected state: " + (Object)((Object)m.getStatus())));
                        }
                    }
                    mex.release(this._bpelProcess.isCleanupCategoryEnabled(m.getStatus() == MessageExchange.Status.RESPONSE, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
                }
                catch (Throwable throwable) {
                    mex.release(this._bpelProcess.isCleanupCategoryEnabled(m.getStatus() == MessageExchange.Status.RESPONSE, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
                    throw throwable;
                }
            } else {
                __log.warn((Object)("Can't send response to a p2p mex: " + mex + " partner mex: " + pmex));
            }
        } else {
            this.checkInvokeExternalPermission();
            this._bpelProcess._engine._contexts.mexContext.onAsyncReply(m);
        }
    }

    @Override
    public void reply(PartnerLinkInstance plinkInstnace, String opName, String mexId, Element msg, QName fault) throws FaultException {
        String mexRef = this._imaManager.release(plinkInstnace, opName, mexId);
        if (mexRef == null) {
            throw new FaultException(this._bpelProcess.getOProcess().constants.qnMissingRequest);
        }
        this.reply2(plinkInstnace, opName, mexId, msg, fault, false, mexRef);
    }

    public void reply2(PartnerLinkInstance plinkInstnace, String opName, String mexId, Element msg, QName fault, boolean failure, String mexRef) throws FaultException {
        ProcessMessageExchangeEvent evt = new ProcessMessageExchangeEvent();
        evt.setMexId(mexId);
        evt.setOperation(opName);
        evt.setPortType(plinkInstnace.partnerLink.myRolePortType.getQName());
        MessageExchangeDAO mex = this._dao.getConnection().getMessageExchange(mexRef);
        MessageDAO message = mex.createMessage(plinkInstnace.partnerLink.getMyRoleOperation(opName).getOutput().getMessage().getQName());
        this.buildOutgoingMessage(message, msg);
        MyRoleMessageExchangeImpl m = new MyRoleMessageExchangeImpl(this._bpelProcess, this._bpelProcess._engine, mex);
        this._bpelProcess.initMyRoleMex(m);
        m.setResponse(new MessageImpl(message));
        if (failure) {
            mex.setStatus(MessageExchange.Status.FAILURE.toString());
        } else if (fault != null) {
            mex.setStatus(MessageExchange.Status.FAULT.toString());
            mex.setFault(fault);
            evt.setAspect((short)2);
        } else {
            mex.setStatus(MessageExchange.Status.RESPONSE.toString());
            evt.setAspect((short)1);
        }
        this.doAsyncReply(m);
        this.sendEvent(evt);
    }

    @Override
    public void writeCorrelation(CorrelationSetInstance cset, CorrelationKey correlation) {
        ScopeDAO scopeDAO = this._dao.getScope(cset.scopeInstance);
        CorrelationSetDAO cs = scopeDAO.getCorrelationSet(cset.declaration.name);
        QName[] propNames = new QName[cset.declaration.properties.size()];
        for (int m = 0; m < cset.declaration.properties.size(); ++m) {
            OProcess.OProperty oProperty = cset.declaration.properties.get(m);
            propNames[m] = oProperty.name;
        }
        cs.setValue(propNames, correlation);
        CorrelationSetWriteEvent cswe = new CorrelationSetWriteEvent(cset.declaration.name, correlation);
        cswe.setScopeId(cset.scopeInstance);
        this.sendEvent(cswe);
    }

    public void initializeCorrelation(CorrelationSetInstance cset, VariableInstance variable) throws FaultException {
        if (BpelProcess.__log.isDebugEnabled()) {
            BpelProcess.__log.debug((Object)("Initializing correlation set " + cset.declaration.name));
        }
        if (this.isCorrelationInitialized(cset)) {
            if (BpelProcess.__log.isDebugEnabled()) {
                BpelProcess.__log.debug((Object)("OCorrelation set " + cset + " is already set: ignoring"));
            }
            return;
        }
        String[] propNames = new String[cset.declaration.properties.size()];
        String[] propValues = new String[cset.declaration.properties.size()];
        for (int i = 0; i < cset.declaration.properties.size(); ++i) {
            OProcess.OProperty property = cset.declaration.properties.get(i);
            propValues[i] = this.readProperty(variable, property);
            propNames[i] = property.name.toString();
        }
        CorrelationKey ckeyVal = new CorrelationKey(cset.declaration.name, propValues);
        this.writeCorrelation(cset, ckeyVal);
    }

    @Override
    public ExpressionLanguageRuntimeRegistry getExpLangRuntime() {
        return this._bpelProcess._expLangRuntimeRegistry;
    }

    @Override
    public void terminate() {
        ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
        evt.setOldState(this._dao.getState());
        this._dao.setState((short)60);
        evt.setNewState((short)60);
        this.sendEvent(evt);
        this.sendEvent(new ProcessTerminationEvent());
        this._dao.finishCompletion();
        this.failOutstandingMessageExchanges();
        this._bpelProcess._engine._contexts.scheduler.registerSynchronizer(new Scheduler.Synchronizer(){

            @Override
            public void afterCompletion(boolean success) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void beforeCompletion() {
                if (BpelRuntimeContextImpl.this._wst != null && BpelRuntimeContextImpl.this._wst.isActive() && !BpelRuntimeContextImpl.this._wst.isSubordinate()) {
                    try {
                        BpelRuntimeContextImpl.this._wst.rollback();
                    }
                    catch (Exception e) {
                        __log.warn((Object)"Web service transaction wasn't properly aborted or it is already rolled back.");
                    }
                    finally {
                        BpelRuntimeContextImpl.this._bpelProcess.removeWebServiceTransaction(BpelRuntimeContextImpl.this._dao.getInstanceId());
                    }
                }
                BpelRuntimeContextImpl.this._dao.delete(BpelRuntimeContextImpl.this._bpelProcess.getCleanupCategories(false), false);
            }
        });
    }

    @Override
    public void registerTimer(TimerResponseChannel timerChannel, Date timeToFire) {
        Scheduler.JobDetails we = new Scheduler.JobDetails();
        we.setInstanceId(this._dao.getInstanceId());
        we.setChannel(timerChannel.export());
        we.setType(Scheduler.JobType.TIMER);
        we.setInMem(this._bpelProcess.isInMemory());
        if (this._bpelProcess.isInMemory()) {
            this._bpelProcess._engine._contexts.scheduler.scheduleVolatileJob(true, we, timeToFire);
        } else {
            this._bpelProcess._engine._contexts.scheduler.schedulePersistedJob(we, timeToFire);
        }
    }

    private void scheduleCorrelatorMatcher(String correlatorId, CorrelationKeySet keySet) {
        Scheduler.JobDetails we = new Scheduler.JobDetails();
        we.setInstanceId(this._dao.getInstanceId());
        we.setType(Scheduler.JobType.MATCHER);
        we.setCorrelatorId(correlatorId);
        we.setCorrelationKeySet(keySet);
        we.setInMem(this._bpelProcess.isInMemory());
        if (this._bpelProcess.isInMemory()) {
            this._bpelProcess._engine._contexts.scheduler.scheduleVolatileJob(true, we);
        } else {
            this._bpelProcess._engine._contexts.scheduler.schedulePersistedJob(we, null);
        }
    }

    public void checkInvokeExternalPermission() {
    }

    @Override
    public String invoke(int aid, PartnerLinkInstance partnerLink, Operation operation, Element outgoingMessage, InvokeResponseChannel channel) throws FaultException {
        EndpointReference partnerEpr;
        PartnerLinkDAO plinkDAO = this.fetchPartnerLinkDAO(partnerLink);
        Element partnerEPR = plinkDAO.getPartnerEPR();
        if (partnerEPR == null) {
            partnerEpr = this._bpelProcess.getInitialPartnerRoleEPR(partnerLink.partnerLink);
            if (partnerEpr == null) {
                throw new FaultException(partnerLink.partnerLink.getOwner().constants.qnUninitializedPartnerRole);
            }
        } else {
            partnerEpr = this._bpelProcess._engine._contexts.eprContext.resolveEndpointReference(partnerEPR);
        }
        if (BpelProcess.__log.isDebugEnabled()) {
            BpelProcess.__log.debug((Object)("INVOKING PARTNER: partnerLink=" + partnerLink + ", op=" + operation.getName() + " channel=" + channel + ")"));
        }
        ProcessMessageExchangeEvent evt = new ProcessMessageExchangeEvent();
        evt.setOperation(operation.getName());
        evt.setPortType(partnerLink.partnerLink.partnerRolePortType.getQName());
        evt.setAspect((short)3);
        MessageExchangeDAO mexDao = this._dao.getConnection().createMessageExchange('P');
        mexDao.setCreateTime(this.getCurrentEventDateTime());
        mexDao.setStatus(MessageExchange.Status.NEW.toString());
        mexDao.setOperation(operation.getName());
        mexDao.setPortType(partnerLink.partnerLink.partnerRolePortType.getQName());
        mexDao.setPartnerLinkModelId(partnerLink.partnerLink.getId());
        mexDao.setPartnerLink(plinkDAO);
        mexDao.setProcess(this._dao.getProcess());
        mexDao.setInstance(this._dao);
        mexDao.setPattern((operation.getOutput() != null ? MessageExchange.MessageExchangePattern.REQUEST_RESPONSE : MessageExchange.MessageExchangePattern.REQUEST_ONLY).toString());
        mexDao.setChannel(channel == null ? null : channel.export());
        String mySessionId = plinkDAO.getMySessionId();
        String partnerSessionId = plinkDAO.getPartnerSessionId();
        if (mySessionId != null) {
            mexDao.setProperty("org.apache.ode.bpel.myRoleSessionId", mySessionId);
        }
        if (partnerSessionId != null) {
            mexDao.setProperty("org.apache.ode.bpel.partnerRoleSessionId", partnerSessionId);
        }
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("INVOKE PARTNER (SEP): sessionId=" + mySessionId + " partnerSessionId=" + partnerSessionId));
        }
        MessageDAO message = mexDao.createMessage(operation.getInput().getMessage().getQName());
        mexDao.setRequest(message);
        message.setType(operation.getInput().getMessage().getQName());
        this.buildOutgoingMessage(message, outgoingMessage);
        EndpointReference myRoleEndpoint = partnerLink.partnerLink.hasMyRole() ? this._bpelProcess.getInitialMyRoleEPR(partnerLink.partnerLink) : null;
        PartnerRoleMessageExchangeImpl mex = this.createPartnerRoleMessageExchangeImpl(mexDao, partnerLink, operation, partnerEpr, myRoleEndpoint);
        mex.setProperty("activityId", "" + aid);
        List<BpelProcess> p2pProcesses = null;
        Endpoint partnerEndpoint = this._bpelProcess.getInitialPartnerRoleEndpoint(partnerLink.partnerLink);
        if (this.getConfigForPartnerLink((OPartnerLink)partnerLink.partnerLink).usePeer2Peer && partnerEndpoint != null) {
            p2pProcesses = this._bpelProcess.getEngine().route(partnerEndpoint.serviceName, mex.getRequest());
        }
        if (this._bpelProcess._engine.isXTSEnable()) {
            WebServiceTransactionType wstType = this.getTypeOfWSTAssertion(operation, this._bpelProcess.getConf().getDefinitionForService(partnerEndpoint.serviceName).getBindings().values());
            if (!(this._wst != null && this._wst.isActive() || wstType == WebServiceTransactionType.NOT_DETERMINED)) {
                if (BpelProcess.__log.isDebugEnabled()) {
                    __log.debug((Object)"Creating distributed transaction ...");
                }
                this._wst = WebServiceTransactionFactory.instance(wstType);
                if (this._wst != null) {
                    try {
                        this._wst.begin(this._instantiatingMessageExchange.getRequest());
                        this._bpelProcess.setWebServiceTransaction(this._dao.getInstanceId(), this._wst);
                        if (BpelProcess.__log.isDebugEnabled()) {
                            __log.debug((Object)("Distributed transaction has been created with id = " + this._wst.getTransactionIdentifier()));
                        }
                    }
                    catch (Exception e) {
                        throw new FaultException(this._bpelProcess.getOProcess().constants.qnUnknownFault, "Web Service Transaction error while creating the transaction. " + e.getMessage(), e);
                    }
                }
            }
            if (this._wst != null && this._wst.isActive() && wstType != WebServiceTransactionType.NOT_DETERMINED) {
                if (wstType != this._wst.getType()) {
                    __log.warn((Object)"The invocation requires another type of web service transaction. The coordination context won't be sent.");
                } else {
                    try {
                        Element headerElement = message.getHeader();
                        headerElement = this._wst.putCoordinationContext(headerElement);
                        message.setHeader(headerElement);
                    }
                    catch (Exception e) {
                        throw new FaultException(this._bpelProcess.getOProcess().constants.qnUnknownFault, "Cannot put transaction context into message header. " + e.getMessage(), e);
                    }
                }
            }
        }
        if (p2pProcesses != null && !p2pProcesses.isEmpty()) {
            MyRoleMessageExchange myRoleMex = this._bpelProcess.getEngine().createMessageExchange(mex.getMessageExchangeId(), partnerEndpoint.serviceName, operation.getName(), mex.getMessageExchangeId());
            if (myRoleMex instanceof BrokeredMyRoleMessageExchangeImpl) {
                mex.setSubscriberCount(((BrokeredMyRoleMessageExchangeImpl)myRoleMex).getSubscriberCount());
            }
            if (BpelProcess.__log.isDebugEnabled()) {
                __log.debug((Object)("Invoking in a p2p interaction, partnerrole " + mex + " - myrole " + myRoleMex));
            }
            Message odeRequest = myRoleMex.createMessage(operation.getInput().getMessage().getQName());
            odeRequest.setMessage(outgoingMessage);
            ((MessageImpl)odeRequest)._dao.setHeader(message.getHeader());
            if (BpelProcess.__log.isDebugEnabled()) {
                __log.debug((Object)("Setting myRoleMex session ids for p2p interaction, mySession " + partnerSessionId + " - partnerSess " + mySessionId));
            }
            if (partnerSessionId != null) {
                myRoleMex.setProperty("org.apache.ode.bpel.myRoleSessionId", partnerSessionId);
            }
            if (mySessionId != null) {
                myRoleMex.setProperty("org.apache.ode.bpel.partnerRoleSessionId", mySessionId);
            }
            mex.setStatus(MessageExchange.Status.REQUEST);
            myRoleMex.invoke(odeRequest);
            this.scheduleInvokeCheck(mex, partnerLink.partnerLink, true);
            mex.replyAsync();
        } else if (partnerEpr != null) {
            this.checkInvokeExternalPermission();
            mexDao.setEPR(partnerEpr.toXML().getDocumentElement());
            mex.setStatus(MessageExchange.Status.REQUEST);
            this.scheduleInvokeCheck(mex, partnerLink.partnerLink, false);
            this._bpelProcess._engine._contexts.mexContext.invokePartner(mex);
        } else {
            __log.error((Object)("Couldn't find endpoint for partner EPR " + DOMUtils.domToString(partnerEPR)));
            mex.setFailure(MessageExchange.FailureType.UNKNOWN_ENDPOINT, "UnknownEndpoint", partnerEPR);
        }
        evt.setMexId(mexDao.getMessageExchangeId());
        this.sendEvent(evt);
        if (mexDao.getPattern().equals(MessageExchange.MessageExchangePattern.REQUEST_ONLY.toString())) {
            mexDao.setStatus(MessageExchange.Status.ASYNC.toString());
            boolean succeeded = mex.getStatus() != MessageExchange.Status.FAILURE && mex.getStatus() != MessageExchange.Status.FAULT;
            mexDao.release(this._bpelProcess.isCleanupCategoryEnabled(succeeded, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
        }
        switch (mex.getStatus()) {
            case NEW: {
                throw new AssertionError((Object)"Impossible!");
            }
            case ASYNC: {
                break;
            }
            case FAILURE: 
            case FAULT: 
            case RESPONSE: {
                this.invocationResponse(mex);
                break;
            }
            default: {
                __log.error((Object)("Partner did not acknowledge message exchange: " + mex));
                mex.setFailure(MessageExchange.FailureType.NO_RESPONSE, "Partner did not acknowledge.", null);
                this.invocationResponse(mex);
            }
        }
        return mexDao.getMessageExchangeId();
    }

    private WebServiceTransactionType getTypeOfWSTAssertion(Operation operation, Collection<Binding> bindings) {
        for (Binding b : bindings) {
            List bolist = b.getBindingOperations();
            for (BindingOperation bo : bolist) {
                if (bo.getOperation().getName().compareTo(operation.getName()) != 0) continue;
                List eelist = bo.getExtensibilityElements();
                for (ExtensibilityElement ee : eelist) {
                    UnknownExtensibilityElement uee;
                    if (!(ee instanceof UnknownExtensibilityElement) || !(uee = (UnknownExtensibilityElement)ee).getElementType().getLocalPart().equals("PolicyReference")) continue;
                    String uri = uee.getElement().getAttribute("URI").substring(1);
                    NodeList policyNodeList = uee.getElement().getOwnerDocument().getElementsByTagNameNS("*", "Policy");
                    for (int j = 0; j < policyNodeList.getLength(); ++j) {
                        Element element = (Element)policyNodeList.item(j);
                        String refUri = element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
                        if (refUri == null || !refUri.equals(uri)) continue;
                        NodeList nlist = element.getElementsByTagNameNS("http://docs.oasis-open.org/ws-tx/wsat/2006/06", "ATAssertion");
                        if (nlist != null && nlist.getLength() == 1) {
                            return WebServiceTransactionType.ATOMIC_TRANSACTION;
                        }
                        nlist = element.getElementsByTagNameNS("http://docs.oasis-open.org/ws-tx/wsba/2006/06", "BAAtomicOutcomeAssertion");
                        if (nlist != null && nlist.getLength() == 1) {
                            return WebServiceTransactionType.BUSINESS_ACTIVITY_ATOMIC_OUTCOME;
                        }
                        nlist = element.getElementsByTagNameNS("http://docs.oasis-open.org/ws-tx/wsba/2006/06", "BAMixedOutcomeAssertion");
                        if (nlist != null && nlist.getLength() == 1) {
                            return WebServiceTransactionType.BUSINESS_ACTIVITY_MIXED_OUTCOME;
                        }
                        return WebServiceTransactionType.NOT_DETERMINED;
                    }
                }
            }
        }
        return WebServiceTransactionType.NOT_DETERMINED;
    }

    protected PartnerRoleMessageExchangeImpl createPartnerRoleMessageExchangeImpl(MessageExchangeDAO mexDao, PartnerLinkInstance partnerLink, Operation operation, EndpointReference partnerEpr, EndpointReference myRoleEndpoint) {
        return new PartnerRoleMessageExchangeImpl(this.getBpelProcess().getEngine(), mexDao, partnerLink.partnerLink.partnerRolePortType, operation, partnerEpr, myRoleEndpoint, this.getBpelProcess().getPartnerRoleChannel(partnerLink.partnerLink));
    }

    protected BpelProcess getBpelProcess() {
        return this._bpelProcess;
    }

    private void scheduleInvokeCheck(PartnerRoleMessageExchangeImpl mex, OPartnerLink partnerLink, boolean p2p) {
        boolean isTwoWay;
        boolean bl = isTwoWay = mex.getMessageExchangePattern() == MessageExchange.MessageExchangePattern.REQUEST_RESPONSE;
        if (!this._bpelProcess.isInMemory() && isTwoWay) {
            Scheduler.JobDetails event = new Scheduler.JobDetails();
            event.setMexId(mex.getMessageExchangeId());
            event.setProcessId(this._bpelProcess.getPID());
            event.setInMem(false);
            event.setType(Scheduler.JobType.INVOKE_CHECK);
            long timeout = this.getBpelProcess().getTimeout(partnerLink, p2p);
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Creating invocation check event in " + timeout + "ms for mexid " + mex.getMessageExchangeId()));
            }
            Date future = new Date(System.currentTimeMillis() + timeout);
            String jobId = this._bpelProcess._engine._contexts.scheduler.schedulePersistedJob(event, future);
            mex.setProperty("invokeCheckJobId", jobId);
        }
    }

    protected void buildOutgoingMessage(MessageDAO message, Element outgoingElmt) {
        if (outgoingElmt == null) {
            return;
        }
        Document doc = DOMUtils.newDocument();
        Element header = doc.createElement("header");
        NodeList parts = outgoingElmt.getChildNodes();
        for (int m = 0; m < parts.getLength(); ++m) {
            Element part;
            if (parts.item(m).getNodeType() != 1 || (part = (Element)parts.item(m)).getAttribute("headerPart") == null || part.getAttribute("headerPart").length() <= 0) continue;
            header.appendChild(doc.importNode(part, true));
            outgoingElmt.removeChild(part);
            --m;
        }
        message.setData(outgoingElmt);
        message.setHeader(header);
    }

    public void execute() {
        long maxTime = System.currentTimeMillis() + this._maxReductionTimeMs;
        boolean canReduce = true;
        assert (this._outstandingRequests == null && this._imaManager != null);
        while (ProcessState.canExecute(this._dao.getState()) && System.currentTimeMillis() < maxTime && canReduce) {
            canReduce = this._vpu.execute();
        }
        this._dao.setLastActiveTime(new Date());
        if (!ProcessState.isFinished(this._dao.getState())) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Setting execution state on instance " + this._iid));
            }
            this._soup.setGlobalData(this._imaManager);
            if (this._bpelProcess.isInMemory()) {
                ((ProcessInstanceDaoImpl)this._dao).setSoup(this._soup);
            } else {
                ByteArrayOutputStream bos = new ByteArrayOutputStream(10000);
                try {
                    this._soup.write(bos);
                    bos.close();
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                this._dao.setExecutionState(bos.toByteArray());
            }
            if (ProcessState.canExecute(this._dao.getState()) && canReduce) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("MaxTime exceeded for instance # " + this._iid));
                }
                try {
                    Scheduler.JobDetails we = new Scheduler.JobDetails();
                    we.setInstanceId(this._iid);
                    we.setType(Scheduler.JobType.RESUME);
                    we.setInMem(this._bpelProcess.isInMemory());
                    if (this._bpelProcess.isInMemory()) {
                        this._bpelProcess._engine._contexts.scheduler.scheduleVolatileJob(true, we);
                    } else {
                        this._bpelProcess._engine._contexts.scheduler.schedulePersistedJob(we, new Date());
                    }
                }
                catch (ContextException e) {
                    __log.error((Object)"Failed to schedule resume task.", (Throwable)e);
                    throw new BpelEngineException(e);
                }
            }
            if (this._wst != null && this._wst.isActive()) {
                try {
                    this._wst.complete();
                }
                catch (Exception e) {
                    __log.warn((Object)"BusinessActivity partial completion failed.", (Throwable)e);
                }
            }
        }
    }

    public void inputMsgMatch(final String responsechannel, final int idx, MyRoleMessageExchangeImpl mex) {
        if (this._dao.getState() == 10) {
            if (BpelProcess.__log.isDebugEnabled()) {
                BpelProcess.__log.debug((Object)"INPUTMSGMATCH: Changing process instance state from ready to active");
            }
            this._dao.setState((short)20);
            ProcessInstanceStateChangeEvent evt = new ProcessInstanceStateChangeEvent();
            evt.setOldState((short)10);
            evt.setNewState((short)20);
            this.sendEvent(evt);
        }
        final String mexId = mex.getMessageExchangeId();
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 3168964409165899533L;

            @Override
            public void run() {
                PickResponseChannel responseChannel = 4.importChannel(responsechannel, PickResponseChannel.class);
                responseChannel.onRequestRcvd(idx, mexId);
            }
        });
    }

    protected void timerEvent(final String timerResponseChannel) {
        this._dao.getProcess().removeRoutes(timerResponseChannel, this._dao);
        this._imaManager.cancel(timerResponseChannel, true);
        if (ProcessState.isFinished(this._dao.getState())) {
            return;
        }
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = -7767141033611036745L;

            @Override
            public void run() {
                TimerResponseChannel responseChannel = 5.importChannel(timerResponseChannel, TimerResponseChannel.class);
                responseChannel.onTimeout();
            }
        });
        this.execute();
    }

    @Override
    public void cancel(TimerResponseChannel timerResponseChannel) {
        final String id = timerResponseChannel.export();
        this._dao.getProcess().removeRoutes(id, this._dao);
        this._imaManager.cancel(id, true);
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 6157913683737696396L;

            @Override
            public void run() {
                TimerResponseChannel responseChannel = 6.importChannel(id, TimerResponseChannel.class);
                responseChannel.onCancel();
            }
        });
    }

    void invocationResponse(PartnerRoleMessageExchangeImpl mex) {
        this.invocationResponse(mex.getDAO().getMessageExchangeId(), mex.getDAO().getChannel());
    }

    public void invocationResponse(final String mexid, final String responseChannelId) {
        if (responseChannelId == null) {
            throw new NullPointerException("Null responseChannelId");
        }
        if (mexid == null) {
            throw new NullPointerException("Null mexId");
        }
        if (BpelProcess.__log.isDebugEnabled()) {
            __log.debug((Object)("Invoking message response for mexid " + mexid + " and channel " + responseChannelId));
        }
        this._vpu.inject(new BpelJacobRunnable(){
            private static final long serialVersionUID = -1095444335740879981L;

            @Override
            public void run() {
                ((BpelRuntimeContextImpl)this.getBpelRuntimeContext()).invocationResponse2(mexid, 7.importChannel(responseChannelId, InvokeResponseChannel.class));
            }
        });
    }

    private void invocationResponse2(String mexid, InvokeResponseChannel responseChannel) {
        __log.debug((Object)"Triggering response");
        MessageExchangeDAO mex = this._dao.getConnection().getMessageExchange(mexid);
        ProcessMessageExchangeEvent evt = new ProcessMessageExchangeEvent();
        evt.setPortType(mex.getPortType());
        evt.setMexId(mexid);
        evt.setOperation(mex.getOperation());
        MessageExchange.Status status = MessageExchange.Status.valueOf(mex.getStatus());
        switch (status) {
            case FAULT: {
                evt.setAspect((short)5);
                responseChannel.onFault();
                break;
            }
            case RESPONSE: {
                evt.setAspect((short)4);
                responseChannel.onResponse();
                break;
            }
            case FAILURE: {
                evt.setAspect((short)6);
                responseChannel.onFailure();
                break;
            }
            default: {
                __log.error((Object)("Invalid response state for mex " + mexid + ": " + (Object)((Object)status)));
            }
        }
        this.sendEvent(evt);
    }

    private void saveScopeState(Long scopeId, ScopeStateEnum scopeState) {
        ScopeDAO scope = this._dao.getScope(scopeId);
        scope.setState(scopeState);
    }

    @Override
    public void sendEvent(ProcessInstanceEvent event) {
        event.setProcessId(this._dao.getProcess().getProcessId());
        event.setProcessName(this._dao.getProcess().getType());
        event.setProcessInstanceId(this._dao.getInstanceId());
        this._bpelProcess._debugger.onEvent(event);
        List<String> scopeNames = null;
        if (event instanceof ScopeEvent) {
            ScopeEvent sevent = (ScopeEvent)event;
            scopeNames = sevent.getParentScopesNames();
            if (sevent instanceof ScopeStartEvent) {
                this.saveScopeState(sevent.getScopeId(), ScopeStateEnum.ACTIVE);
            } else if (sevent instanceof ScopeCompletionEvent) {
                this.saveScopeState(sevent.getScopeId(), ScopeStateEnum.COMPLETED);
            } else if (sevent instanceof ScopeFaultEvent) {
                this.saveScopeState(sevent.getScopeId(), ScopeStateEnum.FAULT);
            }
        }
        this._bpelProcess.saveEvent(event, this._dao, scopeNames);
    }

    private void writeProperties(VariableInstance variable, Node value, XmlDataDAO dao) {
        if (variable.declaration.type instanceof OMessageVarType) {
            for (OProcess.OProperty property : variable.declaration.getOwner().properties) {
                OProcess.OPropertyAlias alias = property.getAlias(variable.declaration.type);
                if (alias == null) continue;
                try {
                    String val = this._bpelProcess.extractProperty((Element)value, alias, variable.declaration.getDescription());
                    if (val == null) continue;
                    dao.setProperty(property.name.toString(), val);
                }
                catch (FaultException e) {
                    if (!__log.isDebugEnabled()) continue;
                    __log.debug((Object)("Couldn't extract property '" + property.toString() + "' in property pre-extraction: " + e.toString()));
                }
            }
        }
    }

    private void completeOutstandingMessageExchanges() {
        String[] mexRefs;
        block4: for (String mexId : mexRefs = this._imaManager.releaseAll()) {
            MessageExchangeDAO mexDao = this._dao.getConnection().getMessageExchange(mexId);
            if (mexDao == null) continue;
            MyRoleMessageExchangeImpl mex = new MyRoleMessageExchangeImpl(this._bpelProcess, this._bpelProcess._engine, mexDao);
            switch (mex.getStatus()) {
                case RESPONSE: 
                case ASYNC: {
                    mex.setStatus(MessageExchange.Status.COMPLETED_OK);
                    continue block4;
                }
                case REQUEST: {
                    if (mex.getPattern().equals((Object)MessageExchange.MessageExchangePattern.REQUEST_ONLY)) {
                        mex.setStatus(MessageExchange.Status.COMPLETED_OK);
                        continue block4;
                    }
                }
                default: {
                    mex.setFailure(MessageExchange.FailureType.OTHER, "No response.", null);
                    this.doAsyncReply(mex);
                }
            }
        }
    }

    private void faultOutstandingMessageExchanges(FaultData faultData) {
        String[] mexRefs;
        for (String mexId : mexRefs = this._imaManager.releaseAll()) {
            MessageExchangeDAO mexDao = this._dao.getConnection().getMessageExchange(mexId);
            if (mexDao == null) continue;
            MyRoleMessageExchangeImpl mex = new MyRoleMessageExchangeImpl(this._bpelProcess, this._bpelProcess._engine, mexDao);
            this._bpelProcess.initMyRoleMex(mex);
            Message message = mex.createMessage(faultData.getFaultName());
            if (faultData.getFaultMessage() != null) {
                message.setMessage(faultData.getFaultMessage());
            }
            mex.setResponse(message);
            mex.setFault(faultData.getFaultName(), message);
            mex.setFaultExplanation(faultData.getExplanation());
            this.doAsyncReply(mex);
        }
    }

    private void failOutstandingMessageExchanges() {
        String[] mexRefs;
        for (String mexId : mexRefs = this._imaManager.releaseAll()) {
            MessageExchangeDAO mexDao = this._dao.getConnection().getMessageExchange(mexId);
            if (mexDao == null) continue;
            MyRoleMessageExchangeImpl mex = new MyRoleMessageExchangeImpl(this._bpelProcess, this._bpelProcess._engine, mexDao);
            this._bpelProcess.initMyRoleMex(mex);
            mex.setFailure(MessageExchange.FailureType.OTHER, "No response.", null);
            this.doAsyncReply(mex);
        }
    }

    @Override
    public Element getPartnerResponse(String mexId) {
        return BpelRuntimeContextImpl.mergeHeaders(this._getPartnerResponse(mexId));
    }

    @Override
    public Element getMyRequest(String mexId) {
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        if (dao == null) {
            String msg = "Engine requested non-existent message exchange: " + mexId;
            __log.fatal((Object)msg);
            throw new BpelEngineException(msg);
        }
        if (dao.getDirection() != 'M') {
            String msg = "Engine requested my-role request for a partner-role mex: " + mexId;
            __log.fatal((Object)msg);
            throw new BpelEngineException(msg);
        }
        MessageExchange.Status status = MessageExchange.Status.valueOf(dao.getStatus());
        switch (status) {
            case ASYNC: 
            case REQUEST: 
            case COMPLETED_OK: {
                MessageDAO request = dao.getRequest();
                if (request == null) {
                    String msg = "Engine requested request for message exchange that did not have one: " + mexId;
                    __log.fatal((Object)msg);
                    throw new BpelEngineException(msg);
                }
                return BpelRuntimeContextImpl.mergeHeaders(request);
            }
        }
        String msg = "Engine requested response while the message exchange " + mexId + " was in the state " + (Object)((Object)status);
        __log.fatal((Object)msg);
        throw new BpelEngineException(msg);
    }

    protected static Element mergeHeaders(MessageDAO msg) {
        if (msg == null) {
            return null;
        }
        Element data = msg.getData();
        if (msg.getHeader() != null) {
            if (data == null) {
                Document doc = DOMUtils.newDocument();
                data = doc.createElement("message");
                doc.appendChild(data);
            }
            NodeList headerParts = msg.getHeader().getChildNodes();
            for (int m = 0; m < headerParts.getLength(); ++m) {
                if (headerParts.item(m).getNodeType() != 1) continue;
                Element headerPart = (Element)headerParts.item(m);
                headerPart.setAttribute("headerPart", "true");
                data.appendChild(data.getOwnerDocument().importNode(headerPart, true));
            }
        }
        return data;
    }

    @Override
    public QName getPartnerFault(String mexId) {
        MessageExchangeDAO mex = this._getPartnerResponse(mexId).getMessageExchange();
        return mex.getFault();
    }

    @Override
    public QName getPartnerResponseType(String mexId) {
        return this._getPartnerResponse(mexId).getType();
    }

    @Override
    public String getPartnerFaultExplanation(String mexId) {
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        return dao != null ? dao.getFaultExplanation() : null;
    }

    private MessageDAO _getPartnerResponse(String mexId) {
        MessageDAO response;
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        if (dao == null) {
            String msg = "Engine requested non-existent message exchange: " + mexId;
            __log.fatal((Object)msg);
            throw new BpelEngineException(msg);
        }
        if (dao.getDirection() != 'P') {
            String msg = "Engine requested partner response for a my-role mex: " + mexId;
            __log.fatal((Object)msg);
            throw new BpelEngineException(msg);
        }
        MessageExchange.Status status = MessageExchange.Status.valueOf(dao.getStatus());
        switch (status) {
            case FAULT: 
            case RESPONSE: {
                response = dao.getResponse();
                if (response != null) break;
                String msg = "Engine requested response for message exchange that did not have one: " + mexId;
                __log.fatal((Object)msg);
                throw new BpelEngineException(msg);
            }
            case FAILURE: {
                response = dao.getResponse();
                break;
            }
            default: {
                String msg = "Engine requested response while the message exchange " + mexId + " was in the state " + (Object)((Object)status);
                __log.fatal((Object)msg);
                throw new BpelEngineException(msg);
            }
        }
        return response;
    }

    @Override
    public void releasePartnerMex(String mexId, boolean instanceSucceeded) {
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        dao.release(this._bpelProcess.isCleanupCategoryEnabled(instanceSucceeded, ProcessConf.CLEANUP_CATEGORY.MESSAGES));
    }

    @Override
    public Element getSourceEPR(String mexId) {
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        String epr = dao.getProperty("org.apache.ode.bpel.partnerRoleEPR");
        if (epr == null) {
            return null;
        }
        try {
            Element eepr = DOMUtils.stringToDOM(epr);
            return eepr;
        }
        catch (Exception ex) {
            __log.error((Object)("Invalid value for SEP property org.apache.ode.bpel.partnerRoleEPR: " + epr));
            return null;
        }
    }

    @Override
    public String getSourceSessionId(String mexId) {
        MessageExchangeDAO dao = this._dao.getConnection().getMessageExchange(mexId);
        return dao.getProperty("org.apache.ode.bpel.partnerRoleSessionId");
    }

    @Override
    public void registerActivityForRecovery(ActivityRecoveryChannel channel, long activityId, String reason, Date dateTime, Element details, String[] actions, int retries) {
        if (reason == null) {
            reason = "Unspecified";
        }
        if (dateTime == null) {
            dateTime = new Date();
        }
        __log.info((Object)("ActivityRecovery: Registering activity " + activityId + ", failure reason: " + reason + " on channel " + channel.export()));
        this._dao.createActivityRecovery(channel.export(), (int)activityId, reason, dateTime, details, actions, retries);
    }

    @Override
    public void unregisterActivityForRecovery(ActivityRecoveryChannel channel) {
        this._dao.deleteActivityRecovery(channel.export());
    }

    @Override
    public void recoverActivity(final String channel, final long activityId, final String action, final FaultData fault) {
        this._vpu.inject(new JacobRunnable(){
            private static final long serialVersionUID = 3168964409165899533L;

            @Override
            public void run() {
                ActivityRecoveryChannel recovery = 8.importChannel(channel, ActivityRecoveryChannel.class);
                __log.info((Object)("ActivityRecovery: Recovering activity " + activityId + " with action " + action + " on channel " + recovery));
                if (recovery != null) {
                    if ("cancel".equals(action)) {
                        recovery.cancel();
                    } else if ("retry".equals(action)) {
                        recovery.retry();
                    } else if ("fault".equals(action)) {
                        recovery.fault(fault);
                    }
                }
            }
        });
        this.execute();
    }

    @Override
    public String fetchMySessionId(PartnerLinkInstance pLink) {
        String sessionId = this.fetchPartnerLinkDAO(pLink).getMySessionId();
        assert (sessionId != null) : "Session ID should always be set!";
        return sessionId;
    }

    @Override
    public String fetchPartnersSessionId(PartnerLinkInstance pLink) {
        return this.fetchPartnerLinkDAO(pLink).getPartnerSessionId();
    }

    @Override
    public void initializePartnersSessionId(PartnerLinkInstance pLink, String session) {
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("initializing partner " + pLink + "  sessionId to " + session));
        }
        this.fetchPartnerLinkDAO(pLink).setPartnerSessionId(session);
    }

    public void matcherEvent(String correlatorId, CorrelationKeySet ckeySet) {
        CorrelatorDAO correlator;
        List<MessageRouteDAO> mroutes;
        if (BpelProcess.__log.isDebugEnabled()) {
            __log.debug((Object)("MatcherEvent handling: correlatorId=" + correlatorId + ", ckeySet=" + ckeySet));
        }
        if ((mroutes = (correlator = this._dao.getProcess().getCorrelator(correlatorId)).findRoute(ckeySet)) == null || mroutes.size() == 0) {
            __log.debug((Object)"MatcherEvent handling: nothing to do, route no longer in DB");
            return;
        }
        MessageExchangeDAO mexdao = correlator.dequeueMessage(ckeySet);
        if (mexdao != null) {
            __log.debug((Object)"MatcherEvent handling: found matching message in DB (i.e. message arrived before <receive>)");
            if (MessageExchange.MessageExchangePattern.REQUEST_RESPONSE.toString().equals(mexdao.getPattern())) {
                __log.warn((Object)"A message arrived before a receive is ready for a request/response pattern. This may be processed to success. However, you should consider revising your process since a TCP port and a container thread will be held for a longer time and the process will not scale under heavy load.");
            }
            if (MyRoleMessageExchange.CorrelationStatus.QUEUED.toString().equals(mexdao.getCorrelationStatus())) {
                mexdao.setCorrelationStatus(MyRoleMessageExchange.CorrelationStatus.MATCHED.toString());
            }
            for (MessageRouteDAO mroute : mroutes) {
                correlator.removeRoutes(mroute.getGroupId(), this._dao);
            }
            MessageRouteDAO mroute = mroutes.get(0);
            if (BpelProcess.__log.isDebugEnabled()) {
                BpelProcess.__log.debug((Object)("SELECT: " + mroute.getGroupId() + ": matched to MESSAGE " + mexdao + " on CKEYSET " + ckeySet));
            }
            MyRoleMessageExchangeImpl mex = new MyRoleMessageExchangeImpl(this._bpelProcess, this._bpelProcess._engine, mexdao);
            this.inputMsgMatch(mroute.getGroupId(), mroute.getIndex(), mex);
            this.execute();
            if (this._dao.getState() != 50) {
                mexdao.releasePremieMessages();
            }
        } else {
            __log.debug((Object)"MatcherEvent handling: nothing to do, no matching message in DB");
        }
    }

    @Override
    public Node readExtVar(OScope.Variable variable, Node reference) throws ExternalVariableModuleException {
        ExternalVariableModule.Value val = this._bpelProcess.getEVM().read(variable, reference, this._iid);
        return val.value;
    }

    @Override
    public BpelRuntimeContext.ValueReferencePair writeExtVar(OScope.Variable variable, Node reference, Node value) throws ExternalVariableModuleException {
        BpelRuntimeContext.ValueReferencePair vrp = new BpelRuntimeContext.ValueReferencePair();
        ExternalVariableModule.Value val = this._bpelProcess.getEVM().write(variable, reference, value, this._iid);
        vrp.reference = val.locator.reference;
        vrp.value = val.value;
        return vrp;
    }

    @Override
    public URI getBaseResourceURI() {
        return this._bpelProcess.getBaseResourceURI();
    }

    @Override
    public Node getProcessProperty(QName propertyName) {
        return this._bpelProcess.getProcessProperty(propertyName);
    }

    @Override
    public QName getProcessQName() {
        return this._bpelProcess.getProcessType();
    }

    @Override
    public Date getCurrentEventDateTime() {
        if (this._currentEventDateTime == null) {
            return Calendar.getInstance().getTime();
        }
        return this._currentEventDateTime;
    }

    public void setCurrentEventDateTime(Date eventDateTime) {
        this._currentEventDateTime = eventDateTime;
    }

    @Override
    public ClassLoader getProcessClassLoader() {
        return this._bpelProcess._classLoader;
    }

    @Override
    public ProcessConf.PartnerRoleConfig getConfigForPartnerLink(OPartnerLink pLink) {
        ProcessConf.PartnerRoleConfig c = this._bpelProcess.getConf().getPartnerRoleConfig().get(pLink.name);
        if (c == null) {
            return new ProcessConf.PartnerRoleConfig(null, true);
        }
        return c;
    }
}

