/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.bpel;

import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import org.apache.ode.dao.bpel.ActivityRecoveryDAO;
import org.apache.ode.dao.jpa.bpel.ProcessInstanceDAOImpl;
import org.apache.ode.utils.DOMUtils;
import org.w3c.dom.Element;

@Entity
@Table(name="BPEL_ACTIVITY_RECOVERY")
@NamedQueries(value={@NamedQuery(name="DELETE_ACTIVITY_RECOVERIES_BY_IDS", query="delete from ActivityRecoveryDAOImpl as a where a._instanceId in(:ids)"), @NamedQuery(name="COUNT_ACTIVITY_RECOVERIES_BY_INSTANCES", query="select r._instanceId, count(r._id) from ActivityRecoveryDAOImpl r where r._instance in(:instances) group by r._instanceId")})
public class ActivityRecoveryDAOImpl
implements ActivityRecoveryDAO {
    public static final String DELETE_ACTIVITY_RECOVERIES_BY_IDS = "DELETE_ACTIVITY_RECOVERIES_BY_IDS";
    public static final String COUNT_ACTIVITY_RECOVERIES_BY_INSTANCES = "COUNT_ACTIVITY_RECOVERIES_BY_INSTANCES";
    @Id
    @Column(name="ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _id;
    @Basic
    @Column(name="ACTIVITY_ID")
    private long _activityId;
    @Basic
    @Column(name="CHANNEL")
    private String _channel;
    @Basic
    @Column(name="REASON")
    private String _reason;
    @Basic
    @Column(name="DATE_TIME")
    private Date _dateTime;
    @Lob
    @Column(name="DETAILS")
    private String _details;
    @Basic
    @Column(name="ACTIONS")
    private String _actions;
    @Basic
    @Column(name="RETRIES")
    private int _retries;
    @Basic
    @Column(name="INSTANCE_ID", insertable=false, updatable=false, nullable=true)
    private Long _instanceId;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="INSTANCE_ID")
    private ProcessInstanceDAOImpl _instance;

    public ActivityRecoveryDAOImpl() {
    }

    public ActivityRecoveryDAOImpl(String channel, long activityId, String reason, Date dateTime, Element data, String[] actions, int retries) {
        this._channel = channel;
        this._activityId = activityId;
        this._reason = reason;
        this._dateTime = dateTime;
        if (data != null) {
            this._details = DOMUtils.domToString(data);
        }
        String alist = actions[0];
        for (int i = 1; i < actions.length; ++i) {
            alist = alist + " " + actions[i];
        }
        this._actions = alist;
        this._retries = retries;
    }

    @Override
    public String getActions() {
        return this._actions;
    }

    @Override
    public String[] getActionsList() {
        return this.getActions().split(" ");
    }

    @Override
    public long getActivityId() {
        return this._activityId;
    }

    @Override
    public String getChannel() {
        return this._channel;
    }

    @Override
    public Date getDateTime() {
        return this._dateTime;
    }

    @Override
    public Element getDetails() {
        Element ret = null;
        if (this._details != null) {
            try {
                ret = DOMUtils.stringToDOM(this._details);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    @Override
    public String getReason() {
        return this._reason;
    }

    @Override
    public int getRetries() {
        return this._retries;
    }

    public ProcessInstanceDAOImpl getInstance() {
        return this._instance;
    }

    public void setInstance(ProcessInstanceDAOImpl instance) {
        this._instance = instance;
    }

    @Deprecated
    public Long get_id() {
        return this._id;
    }

    @Deprecated
    public void set_id(Long id) {
        this._id = id;
    }
}

