/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.dao.jpa.bpel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Query;
import javax.persistence.Table;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.dao.bpel.CorrelationSetDAO;
import org.apache.ode.dao.bpel.PartnerLinkDAO;
import org.apache.ode.dao.bpel.ProcessInstanceDAO;
import org.apache.ode.dao.bpel.ScopeDAO;
import org.apache.ode.dao.bpel.ScopeStateEnum;
import org.apache.ode.dao.bpel.XmlDataDAO;
import org.apache.ode.dao.jpa.bpel.BpelDAO;
import org.apache.ode.dao.jpa.bpel.CorrelationSetDAOImpl;
import org.apache.ode.dao.jpa.bpel.EventDAOImpl;
import org.apache.ode.dao.jpa.bpel.PartnerLinkDAOImpl;
import org.apache.ode.dao.jpa.bpel.ProcessInstanceDAOImpl;
import org.apache.ode.dao.jpa.bpel.XmlDataDAOImpl;
import org.hibernate.annotations.ForeignKey;

@Entity
@Table(name="BPEL_SCOPE")
@NamedQueries(value={@NamedQuery(name="ScopeEvents", query="SELECT se FROM EventDAOImpl as se WHERE se._scopeId = :sid"), @NamedQuery(name="SELECT_SCOPE_IDS_BY_PROCESS", query="select s._scopeInstanceId from ScopeDAOImpl as s where s._processInstance._process = :process"), @NamedQuery(name="SELECT_SCOPE_IDS_BY_INSTANCE", query="select s._scopeInstanceId from ScopeDAOImpl as s where s._processInstance = :instance"), @NamedQuery(name="DELETE_SCOPES_BY_SCOPE_IDS", query="delete from ScopeDAOImpl as s where s._scopeInstanceId in(:ids)")})
public class ScopeDAOImpl
extends BpelDAO
implements ScopeDAO {
    public static final String SELECT_SCOPE_IDS_BY_PROCESS = "SELECT_SCOPE_IDS_BY_PROCESS";
    public static final String SELECT_SCOPE_IDS_BY_INSTANCE = "SELECT_SCOPE_IDS_BY_INSTANCE";
    public static final String DELETE_SCOPES_BY_SCOPE_IDS = "DELETE_SCOPES_BY_SCOPE_IDS";
    @Id
    @Column(name="SCOPE_ID")
    @GeneratedValue(strategy=GenerationType.AUTO)
    private Long _scopeInstanceId;
    @Basic
    @Column(name="MODEL_ID")
    private int _modelId;
    @Basic
    @Column(name="SCOPE_NAME")
    private String _name;
    @Basic
    @Column(name="SCOPE_STATE")
    private String _scopeState;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="PARENT_SCOPE_ID")
    @ForeignKey(name="none")
    private ScopeDAOImpl _parentScope;
    @OneToMany(targetEntity=ScopeDAOImpl.class, mappedBy="_parentScope", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @ForeignKey(name="none")
    private Collection<ScopeDAO> _childScopes = new ArrayList<ScopeDAO>();
    @OneToMany(targetEntity=CorrelationSetDAOImpl.class, mappedBy="_scope", fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    private Collection<CorrelationSetDAO> _correlationSets = new ArrayList<CorrelationSetDAO>();
    @OneToMany(targetEntity=PartnerLinkDAOImpl.class, mappedBy="_scope", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.REFRESH, CascadeType.PERSIST})
    private Collection<PartnerLinkDAO> _partnerLinks = new ArrayList<PartnerLinkDAO>();
    @OneToMany(targetEntity=XmlDataDAOImpl.class, mappedBy="_scope", fetch=FetchType.LAZY, cascade={CascadeType.MERGE, CascadeType.REFRESH, CascadeType.PERSIST})
    private Collection<XmlDataDAO> _variables = new ArrayList<XmlDataDAO>();
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST})
    @JoinColumn(name="PROCESS_INSTANCE_ID")
    private ProcessInstanceDAOImpl _processInstance;

    public ScopeDAOImpl() {
    }

    public ScopeDAOImpl(ScopeDAOImpl parentScope, String name, int scopeModelId, ProcessInstanceDAOImpl pi) {
        this._parentScope = parentScope;
        this._name = name;
        this._modelId = scopeModelId;
        this._processInstance = pi;
    }

    @Override
    public PartnerLinkDAO createPartnerLink(int plinkModelId, String pLinkName, String myRole, String partnerRole) {
        PartnerLinkDAOImpl pl = new PartnerLinkDAOImpl(plinkModelId, pLinkName, myRole, partnerRole);
        pl.setScope(this);
        this._partnerLinks.add(pl);
        return pl;
    }

    @Override
    public Collection<ScopeDAO> getChildScopes() {
        return this._childScopes;
    }

    @Override
    public CorrelationSetDAO getCorrelationSet(String corrSetName) {
        CorrelationSetDAO ret = null;
        for (CorrelationSetDAO csElement : this._correlationSets) {
            if (!csElement.getName().equals(corrSetName)) continue;
            ret = csElement;
        }
        if (ret == null) {
            ret = new CorrelationSetDAOImpl(this, corrSetName);
            this.getEM().persist((Object)ret);
            this._correlationSets.add(ret);
        }
        return ret;
    }

    @Override
    public Collection<CorrelationSetDAO> getCorrelationSets() {
        return this._correlationSets;
    }

    @Override
    public int getModelId() {
        return this._modelId;
    }

    @Override
    public String getName() {
        return this._name;
    }

    @Override
    public ScopeDAO getParentScope() {
        return this._parentScope;
    }

    @Override
    public PartnerLinkDAO getPartnerLink(int plinkModelId) {
        for (PartnerLinkDAO pLink : this.getPartnerLinks()) {
            if (pLink.getPartnerLinkModelId() != plinkModelId) continue;
            return pLink;
        }
        return null;
    }

    @Override
    public Collection<PartnerLinkDAO> getPartnerLinks() {
        return this._partnerLinks;
    }

    @Override
    public ProcessInstanceDAO getProcessInstance() {
        return this._processInstance;
    }

    @Override
    public Long getScopeInstanceId() {
        return this._scopeInstanceId;
    }

    @Override
    public ScopeStateEnum getState() {
        return ScopeStateEnum.valueOf(this._scopeState);
    }

    @Override
    public XmlDataDAO getVariable(String varName) {
        XmlDataDAOImpl ret = null;
        for (XmlDataDAO xmlElement : this._variables) {
            if (!xmlElement.getName().equals(varName)) continue;
            return xmlElement;
        }
        ret = new XmlDataDAOImpl(this, varName);
        this._variables.add(ret);
        return ret;
    }

    @Override
    public Collection<XmlDataDAO> getVariables() {
        return this._variables;
    }

    @Override
    public List<BpelEvent> listEvents() {
        ArrayList<BpelEvent> result = new ArrayList<BpelEvent>();
        Query qry = this.getEM().createNamedQuery("ScopeEvents");
        qry.setParameter("sid", (Object)this._scopeInstanceId);
        for (Object eventDao : qry.getResultList()) {
            result.add(((EventDAOImpl)eventDao).getEvent());
        }
        return result;
    }

    @Override
    public void setState(ScopeStateEnum state) {
        this._scopeState = state.toString();
    }

    @Deprecated
    public Long get_scopeInstanceId() {
        return this._scopeInstanceId;
    }

    @Deprecated
    public void set_scopeInstanceId(Long scopeInstanceId) {
        this._scopeInstanceId = scopeInstanceId;
    }
}

