/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.util.i18n;

import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Locale;
import org.ops4j.util.i18n.Resources;

public final class ResourceManager {
    private static final RuntimePermission CLEAR_CACHE_PERMISSION = new RuntimePermission("i18n.clearCompleteCache");
    private static final HashMap<String, WeakReference<Resources>> RESOURCES = new HashMap();

    private ResourceManager() {
    }

    public static Resources getBaseResources(String baseName) {
        return ResourceManager.getBaseResources(baseName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resources getBaseResources(String baseName, ClassLoader classLoader) {
        Class<ResourceManager> clazz = ResourceManager.class;
        synchronized (ResourceManager.class) {
            Resources resources = ResourceManager.getCachedResource(baseName);
            if (null == resources) {
                resources = new Resources(baseName, classLoader);
                ResourceManager.putCachedResource(baseName, resources);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return resources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Resources getBaseResources(String baseName, Locale locale, ClassLoader classLoader) {
        Class<ResourceManager> clazz = ResourceManager.class;
        synchronized (ResourceManager.class) {
            Resources resources = ResourceManager.getCachedResource(baseName + "_" + locale.hashCode());
            if (null == resources) {
                resources = new Resources(baseName, locale, classLoader);
                ResourceManager.putCachedResource(baseName + "_" + locale.hashCode(), resources);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return resources;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearResourceCache() throws SecurityException {
        Class<ResourceManager> clazz = ResourceManager.class;
        synchronized (ResourceManager.class) {
            AccessController.checkPermission(CLEAR_CACHE_PERMISSION);
            RESOURCES.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void putCachedResource(String baseName, Resources resources) {
        Class<ResourceManager> clazz = ResourceManager.class;
        synchronized (ResourceManager.class) {
            WeakReference<Resources> ref = new WeakReference<Resources>(resources);
            RESOURCES.put(baseName, ref);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Resources getCachedResource(String baseName) {
        Class<ResourceManager> clazz = ResourceManager.class;
        synchronized (ResourceManager.class) {
            WeakReference<Resources> weakReference = RESOURCES.get(baseName);
            if (null == weakReference) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return (Resources)weakReference.get();
        }
    }

    public static Resources getResources(String name) {
        return ResourceManager.getBaseResources(name + ".Resources");
    }

    public static Resources getPackageResources(Class clazz) {
        return ResourceManager.getBaseResources(ResourceManager.getPackageResourcesBaseName(clazz), clazz.getClassLoader());
    }

    public static Resources getPackageResources(Class clazz, Locale locale) {
        return ResourceManager.getBaseResources(ResourceManager.getPackageResourcesBaseName(clazz), locale, clazz.getClassLoader());
    }

    public static Resources getClassResources(Class clazz) {
        return ResourceManager.getBaseResources(ResourceManager.getClassResourcesBaseName(clazz), clazz.getClassLoader());
    }

    public static Resources getClassResources(Class clazz, Locale locale) {
        return ResourceManager.getBaseResources(ResourceManager.getClassResourcesBaseName(clazz), locale, clazz.getClassLoader());
    }

    public static String getPackageResourcesBaseName(Class clazz) {
        String name;
        Package pkg = clazz.getPackage();
        String baseName = null == pkg ? (-1 == (name = clazz.getName()).lastIndexOf(".") ? "Resources" : name.substring(0, name.lastIndexOf(".")) + ".Resources") : pkg.getName() + ".Resources";
        return baseName;
    }

    public static String getClassResourcesBaseName(Class clazz) {
        return clazz.getName() + "Resources";
    }
}

