/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.camel.component;

import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.activemq.advisory.DestinationEvent;
import org.apache.activemq.advisory.DestinationListener;
import org.apache.activemq.advisory.DestinationSource;
import org.apache.activemq.camel.component.ActiveMQComponent;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Endpoint;
import org.apache.camel.component.jms.JmsComponent;
import org.apache.camel.component.jms.JmsEndpoint;
import org.apache.camel.component.jms.JmsQueueEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelEndpointLoader
implements CamelContextAware {
    private static final transient Logger LOG = LoggerFactory.getLogger(CamelEndpointLoader.class);
    private CamelContext camelContext;
    private ActiveMQComponent component;
    DestinationSource source;

    public CamelEndpointLoader() {
    }

    public CamelEndpointLoader(CamelContext camelContext, DestinationSource source) {
        this.camelContext = camelContext;
        this.source = source;
    }

    @PostConstruct
    private void postConstruct() {
        try {
            this.afterPropertiesSet();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.source != null) {
            this.source.setDestinationListener(new DestinationListener(){

                @Override
                public void onDestinationEvent(DestinationEvent event) {
                    try {
                        ActiveMQDestination destination = event.getDestination();
                        if (destination instanceof ActiveMQQueue) {
                            ActiveMQQueue queue = (ActiveMQQueue)destination;
                            if (event.isAddOperation()) {
                                CamelEndpointLoader.this.addQueue(queue);
                            } else {
                                CamelEndpointLoader.this.removeQueue(queue);
                            }
                        } else if (destination instanceof ActiveMQTopic) {
                            ActiveMQTopic topic = (ActiveMQTopic)destination;
                            if (event.isAddOperation()) {
                                CamelEndpointLoader.this.addTopic(topic);
                            } else {
                                CamelEndpointLoader.this.removeTopic(topic);
                            }
                        }
                    }
                    catch (Exception e) {
                        LOG.warn("Caught: " + e, (Throwable)e);
                    }
                }
            });
            Set<ActiveMQQueue> queues = this.source.getQueues();
            for (ActiveMQQueue queue : queues) {
                this.addQueue(queue);
            }
            Set<ActiveMQTopic> topics = this.source.getTopics();
            for (ActiveMQTopic topic : topics) {
                this.addTopic(topic);
            }
        }
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public ActiveMQComponent getComponent() {
        if (this.component == null) {
            this.component = (ActiveMQComponent)this.camelContext.getComponent("activemq", ActiveMQComponent.class);
        }
        return this.component;
    }

    public void setComponent(ActiveMQComponent component) {
        this.component = component;
    }

    protected void addQueue(ActiveMQQueue queue) throws Exception {
        String queueUri = this.getQueueUri(queue);
        ActiveMQComponent jmsComponent = this.getComponent();
        JmsQueueEndpoint endpoint = new JmsQueueEndpoint(queueUri, (JmsComponent)jmsComponent, queue.getPhysicalName(), jmsComponent.getConfiguration());
        this.camelContext.addEndpoint(queueUri, (Endpoint)endpoint);
    }

    protected String getQueueUri(ActiveMQQueue queue) {
        return "activemq:" + queue.getPhysicalName();
    }

    protected void removeQueue(ActiveMQQueue queue) throws Exception {
        String queueUri = this.getQueueUri(queue);
        this.camelContext.removeEndpoints(queueUri);
    }

    protected void addTopic(ActiveMQTopic topic) throws Exception {
        String topicUri = this.getTopicUri(topic);
        ActiveMQComponent jmsComponent = this.getComponent();
        JmsEndpoint endpoint = new JmsEndpoint(topicUri, (JmsComponent)jmsComponent, topic.getPhysicalName(), true, jmsComponent.getConfiguration());
        this.camelContext.addEndpoint(topicUri, (Endpoint)endpoint);
    }

    protected String getTopicUri(ActiveMQTopic topic) {
        return "activemq:topic:" + topic.getPhysicalName();
    }

    protected void removeTopic(ActiveMQTopic topic) throws Exception {
        String topicUri = this.getTopicUri(topic);
        this.camelContext.removeEndpoints(topicUri);
    }
}

