/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.leveldb.replicated;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.activemq.leveldb.LevelDBStore;
import org.apache.activemq.leveldb.replicated.FileTransferFrame;
import org.apache.activemq.leveldb.replicated.MasterLevelDBClient;
import org.apache.activemq.leveldb.replicated.MasterLevelDBStore$;
import org.apache.activemq.leveldb.replicated.PositionSync;
import org.apache.activemq.leveldb.replicated.ReplicatedLevelDBStoreTrait;
import org.apache.activemq.leveldb.replicated.ReplicatedLevelDBStoreTrait$class;
import org.apache.activemq.leveldb.replicated.ReplicationFrame;
import org.apache.activemq.leveldb.replicated.ReplicationSupport$;
import org.apache.activemq.leveldb.replicated.SlaveStatus;
import org.apache.activemq.leveldb.replicated.TransportHandler;
import org.apache.activemq.leveldb.replicated.dto.LogDelete;
import org.apache.activemq.leveldb.replicated.dto.LogWrite;
import org.apache.activemq.leveldb.replicated.dto.Login;
import org.apache.activemq.leveldb.replicated.dto.SyncResponse;
import org.apache.activemq.leveldb.replicated.dto.Transfer;
import org.apache.activemq.leveldb.replicated.dto.WalAck;
import org.apache.activemq.leveldb.util.FileSupport$;
import org.apache.activemq.leveldb.util.JsonCodec$;
import org.apache.activemq.util.ServiceStopper;
import org.fusesource.hawtbuf.AsciiBuffer;
import org.fusesource.hawtdispatch.DispatchQueue;
import org.fusesource.hawtdispatch.package$;
import org.fusesource.hawtdispatch.transport.TcpTransportServer;
import org.fusesource.hawtdispatch.transport.Transport;
import org.fusesource.hawtdispatch.transport.TransportServer;
import org.fusesource.hawtdispatch.transport.TransportServerListener;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.ScalaObject;
import scala.Serializable;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConversions$;
import scala.collection.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassManifest$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ScalaSignature(bytes="\u0006\u0001\u0011Mq!B\u0001\u0003\u0011\u000bi\u0011AE'bgR,'\u000fT3wK2$%i\u0015;pe\u0016T!a\u0001\u0003\u0002\u0015I,\u0007\u000f\\5dCR,GM\u0003\u0002\u0006\r\u00059A.\u001a<fY\u0012\u0014'BA\u0004\t\u0003!\t7\r^5wK6\f(BA\u0005\u000b\u0003\u0019\t\u0007/Y2iK*\t1\"A\u0002pe\u001e\u001c\u0001\u0001\u0005\u0002\u000f\u001f5\t!AB\u0003\u0011\u0005!\u0015\u0011C\u0001\nNCN$XM\u001d'fm\u0016dGIQ*u_J,7\u0003B\b\u00135\u0001\u0002\"a\u0005\r\u000e\u0003QQ!!\u0006\f\u0002\t1\fgn\u001a\u0006\u0002/\u0005!!.\u0019<b\u0013\tIBC\u0001\u0004PE*,7\r\u001e\t\u00037yi\u0011\u0001\b\u0006\u0003;\u0011\tA!\u001e;jY&\u0011q\u0004\b\u0002\u0004\u0019><\u0007CA\u0011%\u001b\u0005\u0011#\"A\u0012\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0015\u0012#aC*dC2\fwJ\u00196fGRDQaJ\b\u0005\u0002!\na\u0001P5oSRtD#A\u0007\t\u000f)z!\u0019!C\u0001W\u0005a1+\u0017(D?R{u\fR%T\u0017V\tA\u0006\u0005\u0002\"[%\u0011aF\t\u0002\u0004\u0013:$\bB\u0002\u0019\u0010A\u0003%A&A\u0007T3:\u001bu\fV(`\t&\u001b6\n\t\u0005\be=\u0011\r\u0011\"\u0001,\u00039\u0019\u0016LT\"`)>{&+R'P)\u0016Ca\u0001N\b!\u0002\u0013a\u0013aD*Z\u001d\u000e{FkT0S\u000b6{E+\u0012\u0011\t\u000fYz!\u0019!C\u0001W\u0005)2+\u0017(D?R{uLU#N\u001fR+u,T#N\u001fJK\u0006B\u0002\u001d\u0010A\u0003%A&\u0001\fT3:\u001bu\fV(`%\u0016ku\nV#`\u001b\u0016kuJU-!\u0011\u001dQtB1A\u0005\u0002-\n1cU-O\u0007~#vj\u0018*F\u001b>#Vi\u0018#J'.Ca\u0001P\b!\u0002\u0013a\u0013\u0001F*Z\u001d\u000e{FkT0S\u000b6{E+R0E\u0013N[\u0005E\u0002\u0003\u0011\u0005\u0001q4\u0003B\u001f@\u0007\u0002\u0002\"\u0001Q!\u000e\u0003\u0011I!A\u0011\u0003\u0003\u00191+g/\u001a7E\u0005N#xN]3\u0011\u00059!\u0015BA#\u0003\u0005m\u0011V\r\u001d7jG\u0006$X\r\u001a'fm\u0016dGIQ*u_J,GK]1ji\")q%\u0010C\u0001\u000fR\t\u0001\n\u0005\u0002\u000f{!9!*\u0010a\u0001\n\u0003Y\u0015\u0001\u00022j]\u0012,\u0012\u0001\u0014\t\u0003'5K!A\u0014\u000b\u0003\rM#(/\u001b8h\u0011\u001d\u0001V\b1A\u0005\u0002E\u000b\u0001BY5oI~#S-\u001d\u000b\u0003%V\u0003\"!I*\n\u0005Q\u0013#\u0001B+oSRDqAV(\u0002\u0002\u0003\u0007A*A\u0002yIEBa\u0001W\u001f!B\u0013a\u0015!\u00022j]\u0012\u0004\u0003FA,[!\tYf,D\u0001]\u0015\ti&%A\u0004sK\u001adWm\u0019;\n\u0005}c&\u0001\u0004\"fC:\u0004&o\u001c9feRL\b\"B1>\t\u0003\u0011\u0017aB4fi\nKg\u000e\u001a\u000b\u0002\u0019\")A-\u0010C\u0001K\u000691/\u001a;CS:$GC\u0001*g\u0011\u001d16-!AA\u00021Cq\u0001[\u001fA\u0002\u0013\u00051&\u0001\u0005sKBd\u0017nY1t\u0011\u001dQW\b1A\u0005\u0002-\fAB]3qY&\u001c\u0017m]0%KF$\"A\u00157\t\u000fYK\u0017\u0011!a\u0001Y!1a.\u0010Q!\n1\n\u0011B]3qY&\u001c\u0017m\u001d\u0011)\u00055T\u0006\"B9>\t\u0003\u0011\u0018aC4fiJ+\u0007\u000f\\5dCN$\u0012\u0001\f\u0005\u0006iv\"\t!^\u0001\fg\u0016$(+\u001a9mS\u000e\f7\u000f\u0006\u0002Sm\"9ak]A\u0001\u0002\u0004a\u0003\"\u0002=>\t\u0003Y\u0013\u0001D7j]Nc\u0017M^3BG.\u001c\bb\u0002>>\u0001\u0004%\taS\u0001\b?NLhn\u0019+p\u0011\u001daX\b1A\u0005\u0002u\f1bX:z]\u000e$vn\u0018\u0013fcR\u0011!K \u0005\b-n\f\t\u00111\u0001M\u0011\u001d\t\t!\u0010Q!\n1\u000b\u0001bX:z]\u000e$v\u000e\t\u0005\t\u0003\u000bi\u0004\u0019!C\u0001W\u0005Q1/\u001f8d)>l\u0015m]6\t\u0013\u0005%Q\b1A\u0005\u0002\u0005-\u0011AD:z]\u000e$v.T1tW~#S-\u001d\u000b\u0004%\u00065\u0001\u0002\u0003,\u0002\b\u0005\u0005\t\u0019\u0001\u0017\t\u000f\u0005EQ\b)Q\u0005Y\u0005Y1/\u001f8d)>l\u0015m]6!\u0011\u0019\t)\"\u0010C\u0001\u0017\u000611/\u001f8d)>D3!a\u0005[\u0011\u001d\tY\"\u0010C\u0001\u0003;\t!b]=oGR{w\fJ3r)\r\u0011\u0016q\u0004\u0005\t\u0003C\tI\u00021\u0001\u0002$\u0005)a/\u00197vKB!\u0011QEA\u0016\u001d\r\t\u0013qE\u0005\u0004\u0003S\u0011\u0013A\u0002)sK\u0012,g-C\u0002O\u0003[Q1!!\u000b#Q\r\tIB\u0017\u0005\n\u0003gi$\u0019!C\u0001\u0003k\taa\u001d7bm\u0016\u001cXCAA\u001c!!\tI$!\u0011\u0002$\u0005\u0015SBAA\u001e\u0015\u0011\ti$a\u0010\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002\u001e-%!\u00111IA\u001e\u0005E\u0019uN\\2veJ,g\u000e\u001e%bg\"l\u0015\r\u001d\t\u0005\u0003\u000f\nI%D\u0001>\r\u0019\tY%\u0010\u0001\u0002N\tQ1\u000b\\1wKN#\u0018\r^3\u0014\t\u0005%#\u0003\t\u0005\f\u0003#\nIE!b\u0001\n\u0003\t\u0019&\u0001\u0005tY\u00064XmX5e+\t\t\u0019\u0003C\u0006\u0002X\u0005%#\u0011!Q\u0001\n\u0005\r\u0012!C:mCZ,w,\u001b3!\u0011\u001d9\u0013\u0011\nC\u0001\u00037\"B!!\u0012\u0002^!A\u0011\u0011KA-\u0001\u0004\t\u0019\u0003\u0003\u0006\u0002b\u0005%\u0003\u0019!C\u0001\u0003G\nQ\u0002[3mI~\u001bh.\u00199tQ>$XCAA3!\u0015\t\u0013qMA6\u0013\r\tIG\t\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0007\u0005\ni'C\u0002\u0002p\t\u0012A\u0001T8oO\"Q\u00111OA%\u0001\u0004%\t!!\u001e\u0002#!,G\u000eZ0t]\u0006\u00048\u000f[8u?\u0012*\u0017\u000fF\u0002S\u0003oB\u0011BVA9\u0003\u0003\u0005\r!!\u001a\t\u0013\u0005m\u0014\u0011\nQ!\n\u0005\u0015\u0014A\u00045fY\u0012|6O\\1qg\"|G\u000f\t\u0005\u000b\u0003\u007f\nI\u00051A\u0005\u0002\u0005\u0005\u0015aB:fgNLwN\\\u000b\u0003\u0003\u0007\u0003B!a\u0012\u0002\u0006\u001a1\u0011qQ\u001f\u0001\u0003\u0013\u0013qaU3tg&|gnE\u0003\u0002\u0006\u0006-\u0005\u0005E\u0002\u000f\u0003\u001bK1!a$\u0003\u0005A!&/\u00198ta>\u0014H\u000fS1oI2,'\u000fC\u0007\u0002\u0014\u0006\u0015%\u0011!Q\u0001\n\u0005U\u0015qU\u0001\niJ\fgn\u001d9peR\u0004B!a&\u0002$6\u0011\u0011\u0011\u0014\u0006\u0005\u0003'\u000bYJ\u0003\u0003\u0002\u001e\u0006}\u0015\u0001\u00045boR$\u0017n\u001d9bi\u000eD'bAAQ\u0015\u0005Qa-^:fg>,(oY3\n\t\u0005\u0015\u0016\u0011\u0014\u0002\n)J\fgn\u001d9peRLA!a%\u0002\u000e\"9q%!\"\u0005\u0002\u0005-F\u0003BAB\u0003[C\u0001\"a%\u0002*\u0002\u0007\u0011Q\u0013\u0005\u000b\u0003c\u000b)\t1A\u0005\u0002\u0005M\u0016!\u00027pO&tWCAA[!\u0011\t9,!0\u000e\u0005\u0005e&bAA^\u0005\u0005\u0019A\r^8\n\t\u0005}\u0016\u0011\u0018\u0002\u0006\u0019><\u0017N\u001c\u0005\u000b\u0003\u0007\f)\t1A\u0005\u0002\u0005\u0015\u0017!\u00037pO&tw\fJ3r)\r\u0011\u0016q\u0019\u0005\n-\u0006\u0005\u0017\u0011!a\u0001\u0003kC\u0011\"a3\u0002\u0006\u0002\u0006K!!.\u0002\r1|w-\u001b8!\u0011)\ty-!\"A\u0002\u0013\u0005\u0011\u0011[\u0001\fg2\fg/Z0ti\u0006$X-\u0006\u0002\u0002F!Q\u0011Q[AC\u0001\u0004%\t!a6\u0002\u001fMd\u0017M^3`gR\fG/Z0%KF$2AUAm\u0011%1\u00161[A\u0001\u0002\u0004\t)\u0005C\u0005\u0002^\u0006\u0015\u0005\u0015)\u0003\u0002F\u0005a1\u000f\\1wK~\u001bH/\u0019;fA!Q\u0011\u0011]AC\u0001\u0004%\t!a9\u0002\u0019\u0011L7oY8o]\u0016\u001cG/\u001a3\u0016\u0005\u0005\u0015\bcA\u0011\u0002h&\u0019\u0011\u0011\u001e\u0012\u0003\u000f\t{w\u000e\\3b]\"Q\u0011Q^AC\u0001\u0004%\t!a<\u0002!\u0011L7oY8o]\u0016\u001cG/\u001a3`I\u0015\fHc\u0001*\u0002r\"Ia+a;\u0002\u0002\u0003\u0007\u0011Q\u001d\u0005\n\u0003k\f)\t)Q\u0005\u0003K\fQ\u0002Z5tG>tg.Z2uK\u0012\u0004\u0003\u0002CA}\u0003\u000b#\t!a?\u0002\u000bE,X-^3\u0016\u0005\u0005u\b\u0003BA\u0000\u0005\u0003i!!a'\n\t\t\r\u00111\u0014\u0002\u000e\t&\u001c\b/\u0019;dQF+X-^3\t\u0011\t\u001d\u0011Q\u0011C!\u0005\u0013\t!c\u001c8Ue\u0006t7\u000f]8si\u001a\u000b\u0017\u000e\\;sKR\u0019!Ka\u0003\t\u0011\t5!Q\u0001a\u0001\u0005\u001f\tQ!\u001a:s_J\u0004BA!\u0005\u0003\u00185\u0011!1\u0003\u0006\u0004\u0005+1\u0012AA5p\u0013\u0011\u0011IBa\u0005\u0003\u0017%{U\t_2faRLwN\u001c\u0005\t\u0005;\t)\t\"\u0001\u0003 \u0005\u0011rN\u001c+sC:\u001c\bo\u001c:u\u0007>lW.\u00198e)\r\u0011&\u0011\u0005\u0005\t\u0005G\u0011Y\u00021\u0001\u0003&\u000591m\\7nC:$\u0007cA\u0011\u0003(%\u0019!\u0011\u0006\u0012\u0003\u0007\u0005s\u0017\u0010\u0003\u0005\u0003.\u0005\u0015E\u0011\u0001B\u0018\u00031A\u0017M\u001c3mK~cwnZ5o)\r\u0011&\u0011\u0007\u0005\t\u0005g\u0011Y\u00031\u0001\u00026\u00069!/Z9vKN$\b\u0002\u0003B\u001c\u0003\u000b#\tE!\u000f\u0002/=tGK]1ogB|'\u000f\u001e#jg\u000e|gN\\3di\u0016$G#\u0001*\t\u0011\tu\u0012Q\u0011C\u0001\u0005s\t\u0011\u0003[1oI2,w\fZ5tG>tg.Z2u\u0011!\u0011\t%!\"\u0005\u0002\te\u0012a\u00035b]\u0012dWmX:z]\u000eD\u0001B!\u0012\u0002\u0006\u0012\u0005!qI\u0001\u000bQ\u0006tG\r\\3`C\u000e\\Gc\u0001*\u0003J!A!1\nB\"\u0001\u0004\u0011i%A\u0002sKF\u0004B!a.\u0003P%!!\u0011KA]\u0005\u00199\u0016\r\\!dW\"A!QKAC\t\u0003\u00119&\u0001\u0006iC:$G.Z0hKR$2A\u0015B-\u0011!\u0011YEa\u0015A\u0002\tm\u0003\u0003BA\\\u0005;JAAa\u0018\u0002:\nAAK]1og\u001a,'\u000f\u0003\u0006\u0003d\u0005%\u0003\u0019!C\u0001\u0005K\n1b]3tg&|gn\u0018\u0013fcR\u0019!Ka\u001a\t\u0013Y\u0013\t'!AA\u0002\u0005\r\u0005\"\u0003B6\u0003\u0013\u0002\u000b\u0015BAB\u0003!\u0019Xm]:j_:\u0004\u0003B\u0003B8\u0003\u0013\u0002\r\u0011\"\u0001\u0003r\u0005A\u0001o\\:ji&|g.\u0006\u0002\u0003tA!!Q\u000fB>\u001b\t\u00119H\u0003\u0003\u0003z\u0005m\u0012AB1u_6L7-\u0003\u0003\u0003~\t]$AC!u_6L7\rT8oO\"Q!\u0011QA%\u0001\u0004%\tAa!\u0002\u0019A|7/\u001b;j_:|F%Z9\u0015\u0007I\u0013)\tC\u0005W\u0005\u007f\n\t\u00111\u0001\u0003t!I!\u0011RA%A\u0003&!1O\u0001\na>\u001c\u0018\u000e^5p]\u0002B!B!$\u0002J\u0001\u0007I\u0011\u0001BH\u0003!\u0019\u0017-^4iiV\u0003XC\u0001BI!\u0011\u0011)Ha%\n\t\tU%q\u000f\u0002\u000e\u0003R|W.[2C_>dW-\u00198\t\u0015\te\u0015\u0011\na\u0001\n\u0003\u0011Y*\u0001\u0007dCV<\u0007\u000e^+q?\u0012*\u0017\u000fF\u0002S\u0005;C\u0011B\u0016BL\u0003\u0003\u0005\rA!%\t\u0013\t\u0005\u0016\u0011\nQ!\n\tE\u0015!C2bk\u001eDG/\u00169!\u0011)\u0011)+!\u0013A\u0002\u0013\u0005!qU\u0001\u000eg>\u001c7.\u001a;BI\u0012\u0014Xm]:\u0016\u0005\t%\u0006\u0003\u0002BV\u0005ck!A!,\u000b\u0007\t=f#A\u0002oKRLAAa-\u0003.\ni1k\\2lKR\fE\r\u001a:fgND!Ba.\u0002J\u0001\u0007I\u0011\u0001B]\u0003E\u0019xnY6fi\u0006#GM]3tg~#S-\u001d\u000b\u0004%\nm\u0006\"\u0003,\u00036\u0006\u0005\t\u0019\u0001BU\u0011%\u0011y,!\u0013!B\u0013\u0011I+\u0001\bt_\u000e\\W\r^!eIJ,7o\u001d\u0011\t\u0011\t\r\u0017\u0011\nC\u0001\u0005\u000b\fQa\u001d;beR$2A\u0015Bd\u0011!\tyH!1A\u0002\u0005\r\u0005\u0002\u0003Bf\u0003\u0013\"\tA!4\u0002\tM$x\u000e\u001d\u000b\u0005\u0003K\u0014y\r\u0003\u0005\u0002\u0000\t%\u0007\u0019AAB\u0011!\u0011\u0019.!\u0013\u0005\u0002\tU\u0017!\u0004:fa2L7-\u0019;f?^\fG\u000eF\u0003S\u0005/\u0014\t\u000f\u0003\u0005\u0003Z\nE\u0007\u0019\u0001Bn\u0003\u00191'/Y7fcA\u0019aB!8\n\u0007\t}'A\u0001\tSKBd\u0017nY1uS>tgI]1nK\"Q!1\u001dBi!\u0003\u0005\rA!:\u0002\r\u0019\u0014\u0018-\\33!\rq!q]\u0005\u0004\u0005S\u0014!!\u0005$jY\u0016$&/\u00198tM\u0016\u0014hI]1nK\"A!Q^A%\t\u0003\u0011y/A\bq_NLG/[8o?V\u0004H-\u0019;f)\r\u0011&\u0011\u001f\u0005\t\u0005_\u0012Y\u000f1\u0001\u0002l!Q!Q_A%\u0001\u0004%\tAa>\u0002%1\f7\u000f^0q_NLG/[8o?NLhnY\u000b\u0003\u0005s\u00042A\u0004B~\u0013\r\u0011iP\u0001\u0002\r!>\u001c\u0018\u000e^5p]NKhn\u0019\u0005\u000b\u0007\u0003\tI\u00051A\u0005\u0002\r\r\u0011A\u00067bgR|\u0006o\\:ji&|gnX:z]\u000e|F%Z9\u0015\u0007I\u001b)\u0001C\u0005W\u0005\u007f\f\t\u00111\u0001\u0003z\"I1\u0011BA%A\u0003&!\u0011`\u0001\u0014Y\u0006\u001cHo\u00189pg&$\u0018n\u001c8`gft7\r\t\u0015\u0005\u0007\u000f\u0019i\u0001E\u0002\"\u0007\u001fI1a!\u0005#\u0005!1x\u000e\\1uS2,\u0007\u0002CB\u000b\u0003\u0013\"\taa\u0006\u0002'\rDWmY6`a>\u001c\u0018\u000e^5p]~\u001b\u0018P\\2\u0016\u0003IC\u0001ba\u0007\u0002J\u0011\u0005\u00111]\u0001\u000bSN\u001c\u0015-^4iiV\u0003\b\u0002CB\u0010\u0003\u0013\"\ta!\t\u0002\rM$\u0018\r^;t+\t\u0019\u0019\u0003E\u0002\u000f\u0007KI1aa\n\u0003\u0005-\u0019F.\u0019<f'R\fG/^:\t\u0015\r-\u0012\u0011JI\u0001\n\u0003\u0019i#A\fsKBd\u0017nY1uK~;\u0018\r\u001c\u0013eK\u001a\fW\u000f\u001c;%eU\u00111q\u0006\u0016\u0005\u0005K\u001c\td\u000b\u0002\u00044A!1QGB \u001b\t\u00199D\u0003\u0003\u0004:\rm\u0012!C;oG\",7m[3e\u0015\r\u0019iDI\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB!\u0007o\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0011!\u0019)%\u0010Q\u0001\n\u0005]\u0012aB:mCZ,7\u000f\t\u0005\b\u0007\u0013jD\u0011AB&\u00035\u0019H.\u0019<fg~\u001bH/\u0019;vgV\u00111Q\n\t\u0007\u0007\u001f\u001a)fa\t\u000e\u0005\rE#bAB*E\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\r]3\u0011\u000b\u0002\t\u0013R,'/\u00192mK\"11qD\u001f\u0005\u0002-Cqa!\u0018>\t\u0003\u0012I$A\u0004e_N#\u0018M\u001d;\t\u000f\r\u0005T\b\"\u0011\u0004d\u00051Am\\*u_B$2AUB3\u0011!\u00199ga\u0018A\u0002\r%\u0014aB:u_B\u0004XM\u001d\t\u0005\u0007W\u001ay'\u0004\u0002\u0004n)\u0011QDB\u0005\u0005\u0007c\u001aiG\u0001\bTKJ4\u0018nY3Ti>\u0004\b/\u001a:\t\u000f\rUT\b\"\u0011\u0004x\u0005a1M]3bi\u0016\u001cE.[3oiV\u00111\u0011\u0010\t\u0004\u001d\rm\u0014bAB?\u0005\t\u0019R*Y:uKJdUM^3m\t\n\u001bE.[3oi\"91\u0011Q\u001f\u0005\u0002\r]\u0014!D7bgR,'oX2mS\u0016tG\u000fC\u0005\u0004\u0006v\u0002\r\u0011\"\u0001\u0004\b\u0006\u0001BO]1ogB|'\u000f^0tKJ4XM]\u000b\u0003\u0007\u0013\u0003B!a&\u0004\f&!1QRAM\u0005=!&/\u00198ta>\u0014HoU3sm\u0016\u0014\b\"CBI{\u0001\u0007I\u0011ABJ\u0003Q!(/\u00198ta>\u0014HoX:feZ,'o\u0018\u0013fcR\u0019!k!&\t\u0013Y\u001by)!AA\u0002\r%\u0005\u0002CBM{\u0001\u0006Ka!#\u0002#Q\u0014\u0018M\\:q_J$xl]3sm\u0016\u0014\b\u0005C\u0005\u0004\u001ev\u0012\r\u0011\"\u0001\u0004 \u0006Y1\u000f^1si~c\u0017\r^2i+\t\u0019\t\u000b\u0005\u0003\u0002:\r\r\u0016\u0002BBS\u0003w\u0011abQ8v]R$un\u001e8MCR\u001c\u0007\u000e\u0003\u0005\u0004*v\u0002\u000b\u0011BBQ\u00031\u0019H/\u0019:u?2\fGo\u00195!\u0011\u001d\u0019i+\u0010C\u0001\u0007/\tQc\u001d;beR|\u0006O]8u_\u000e|GnX:feZ,'\u000f\u0003\u0004\u00042v\"\taK\u0001\bO\u0016$\bk\u001c:u\u0011\u001d\u0019),\u0010C\u0001\u0007/\tAc\u001d;pa~\u0003(o\u001c;pG>dwl]3sm\u0016\u0014\b\"CB]{\u0001\u0007I\u0011\u0001B|\u00035\u0001xn]5uS>twl]=oG\"I1QX\u001fA\u0002\u0013\u00051qX\u0001\u0012a>\u001c\u0018\u000e^5p]~\u001b\u0018P\\2`I\u0015\fHc\u0001*\u0004B\"Iaka/\u0002\u0002\u0003\u0007!\u0011 \u0005\t\u0007\u000bl\u0004\u0015)\u0003\u0003z\u0006q\u0001o\\:ji&|gnX:z]\u000e\u0004\u0003\u0006BBb\u0007\u001bAqaa3>\t\u0003\u0019i-A\u0006xC2|6/\u001f8d?R|Gc\u0001*\u0004P\"A!qNBe\u0001\u0004\tY\u0007C\u0004\u0004Tv\"\t!a9\u0002'%\u001c8\u000b^8qa\u0016$wJ]*u_B\u0004\u0018N\\4\t\u000f\r]W\b\"\u0001\u0004Z\u0006!A-\u0019;f+\t\tY\u0007C\u0004\u0003Tv\"\ta!8\u0015\u0013I\u001byn!;\u0004l\u000e=\b\u0002CBq\u00077\u0004\raa9\u0002\t\u0019LG.\u001a\t\u0005\u0005#\u0019)/\u0003\u0003\u0004h\nM!\u0001\u0002$jY\u0016D\u0001Ba\u001c\u0004\\\u0002\u0007\u00111\u000e\u0005\t\u0007[\u001cY\u000e1\u0001\u0002l\u00051qN\u001a4tKRD\u0001b!=\u0004\\\u0002\u0007\u00111N\u0001\u0007Y\u0016tw\r\u001e5\t\u000f\rUX\b\"\u0001\u0004x\u0006!\"/\u001a9mS\u000e\fG/Z0m_\u001e|F-\u001a7fi\u0016$2AUB}\u0011!\u0019Ypa=A\u0002\u0005-\u0014a\u00017pO\"91q`\u001f\u0005\u0002\re\u0017aE<bY~\u000b\u0007\u000f]3oI~\u0003xn]5uS>t\u0007\"\u0003C\u0002{\u0001\u0007I\u0011ABm\u0003!9\u0018\r\\0eCR,\u0007\"\u0003C\u0004{\u0001\u0007I\u0011\u0001C\u0005\u000319\u0018\r\\0eCR,w\fJ3r)\r\u0011F1\u0002\u0005\n-\u0012\u0015\u0011\u0011!a\u0001\u0003WB\u0001\u0002b\u0004>A\u0003&\u00111N\u0001\no\u0006dw\fZ1uK\u0002BC\u0001\"\u0004\u0004\u000e\u0001")
public class MasterLevelDBStore
extends LevelDBStore
implements ReplicatedLevelDBStoreTrait,
ScalaObject {
    private String bind;
    private int replicas;
    private String _syncTo;
    private int syncToMask;
    private final ConcurrentHashMap<String, SlaveState> slaves;
    private TransportServer transport_server;
    private final CountDownLatch start_latch;
    private volatile PositionSync position_sync;
    private volatile long wal_date;
    private String securityToken;

    public static final void trace(Throwable throwable) {
        MasterLevelDBStore$.MODULE$.trace(throwable);
    }

    public static final void trace(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        MasterLevelDBStore$.MODULE$.trace(throwable, function0, seq);
    }

    public static final void trace(Function0<String> function0, Seq<Object> seq) {
        MasterLevelDBStore$.MODULE$.trace(function0, seq);
    }

    public static final void debug(Throwable throwable) {
        MasterLevelDBStore$.MODULE$.debug(throwable);
    }

    public static final void debug(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        MasterLevelDBStore$.MODULE$.debug(throwable, function0, seq);
    }

    public static final void debug(Function0<String> function0, Seq<Object> seq) {
        MasterLevelDBStore$.MODULE$.debug(function0, seq);
    }

    public static final void info(Throwable throwable) {
        MasterLevelDBStore$.MODULE$.info(throwable);
    }

    public static final void info(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        MasterLevelDBStore$.MODULE$.info(throwable, function0, seq);
    }

    public static final void info(Function0<String> function0, Seq<Object> seq) {
        MasterLevelDBStore$.MODULE$.info(function0, seq);
    }

    public static final void warn(Throwable throwable) {
        MasterLevelDBStore$.MODULE$.warn(throwable);
    }

    public static final void warn(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        MasterLevelDBStore$.MODULE$.warn(throwable, function0, seq);
    }

    public static final void warn(Function0<String> function0, Seq<Object> seq) {
        MasterLevelDBStore$.MODULE$.warn(function0, seq);
    }

    public static final void error(Throwable throwable) {
        MasterLevelDBStore$.MODULE$.error(throwable);
    }

    public static final void error(Throwable throwable, Function0<String> function0, Seq<Object> seq) {
        MasterLevelDBStore$.MODULE$.error(throwable, function0, seq);
    }

    public static final void error(Function0<String> function0, Seq<Object> seq) {
        MasterLevelDBStore$.MODULE$.error(function0, seq);
    }

    public static final void org$apache$activemq$leveldb$util$Log$_setter_$log_$eq(Logger logger) {
        MasterLevelDBStore$.MODULE$.org$apache$activemq$leveldb$util$Log$_setter_$log_$eq(logger);
    }

    public static final Logger log() {
        return MasterLevelDBStore$.MODULE$.log();
    }

    public static final int SYNC_TO_REMOTE_DISK() {
        return MasterLevelDBStore$.MODULE$.SYNC_TO_REMOTE_DISK();
    }

    public static final int SYNC_TO_REMOTE_MEMORY() {
        return MasterLevelDBStore$.MODULE$.SYNC_TO_REMOTE_MEMORY();
    }

    public static final int SYNC_TO_REMOTE() {
        return MasterLevelDBStore$.MODULE$.SYNC_TO_REMOTE();
    }

    public static final int SYNC_TO_DISK() {
        return MasterLevelDBStore$.MODULE$.SYNC_TO_DISK();
    }

    public String bind() {
        return this.bind;
    }

    public void bind_$eq(String string) {
        this.bind = string;
    }

    public void setBind(String string) {
        this.bind = string;
    }

    public int replicas() {
        return this.replicas;
    }

    public void replicas_$eq(int n) {
        this.replicas = n;
    }

    public void setReplicas(int n) {
        this.replicas = n;
    }

    public int minSlaveAcks() {
        return this.replicas() / 2;
    }

    public String _syncTo() {
        return this._syncTo;
    }

    public void _syncTo_$eq(String string) {
        this._syncTo = string;
    }

    public int syncToMask() {
        return this.syncToMask;
    }

    public void syncToMask_$eq(int n) {
        this.syncToMask = n;
    }

    public String syncTo() {
        return this._syncTo();
    }

    public void syncTo_$eq(String value) {
        this._syncTo_$eq(value);
        this.syncToMask_$eq(0);
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])value.split(",")).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final String apply(String string) {
                return string.trim().toLowerCase();
            }
        }, Array$.MODULE$.canBuildFrom(ClassManifest$.MODULE$.classType(String.class)))).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;
            private final MasterLevelDBStore $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(String v) {
                String string;
                String string2 = string = v;
                String string3 = "";
                if (string2 == null ? string3 != null : !string2.equals(string3)) {
                    String string4 = string;
                    String string5 = "local_mem";
                    if (string4 == null ? string5 != null : !string4.equals(string5)) {
                        String string6 = string;
                        String string7 = "local_disk";
                        if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                            this.$outer.syncToMask_$eq(this.$outer.syncToMask() | MasterLevelDBStore$.MODULE$.SYNC_TO_DISK());
                        } else {
                            String string8 = string;
                            String string9 = "remote_mem";
                            if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                                this.$outer.syncToMask_$eq(this.$outer.syncToMask() | MasterLevelDBStore$.MODULE$.SYNC_TO_REMOTE_MEMORY());
                            } else {
                                String string10 = string;
                                String string11 = "remote_disk";
                                if (!(string10 != null ? !string10.equals(string11) : string11 != null)) {
                                    this.$outer.syncToMask_$eq(this.$outer.syncToMask() | MasterLevelDBStore$.MODULE$.SYNC_TO_REMOTE_DISK());
                                } else {
                                    String string12 = string;
                                    String string13 = "quorum_mem";
                                    if (!(string12 != null ? !string12.equals(string13) : string13 != null)) {
                                        this.$outer.syncToMask_$eq(this.$outer.syncToMask() | MasterLevelDBStore$.MODULE$.SYNC_TO_REMOTE_MEMORY());
                                    } else {
                                        String string14 = string;
                                        String string15 = "quorum_disk";
                                        if (!(string14 != null ? !string14.equals(string15) : string15 != null)) {
                                            this.$outer.syncToMask_$eq(this.$outer.syncToMask() | (MasterLevelDBStore$.MODULE$.SYNC_TO_REMOTE_DISK() | MasterLevelDBStore$.MODULE$.SYNC_TO_DISK()));
                                        } else {
                                            MasterLevelDBStore$.MODULE$.warn((Function0<String>)new Serializable(this){
                                                public static final long serialVersionUID;

                                                static {
                                                    long l = serialVersionUID = 0L;
                                                }

                                                public final String apply() {
                                                    return "Unknown syncTo value: [%s]";
                                                }
                                            }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{string}));
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    public ConcurrentHashMap<String, SlaveState> slaves() {
        return this.slaves;
    }

    public Iterable<SlaveStatus> slaves_status() {
        return (Iterable)JavaConversions$.MODULE$.collectionAsScalaIterable(this.slaves().values()).map((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final SlaveStatus apply(SlaveState slaveState) {
                return slaveState.status();
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public String status() {
        void var3_3;
        IntRef caughtUpCounter$1 = new IntRef(0);
        IntRef notCaughtUpCounter$1 = new IntRef(0);
        JavaConversions$.MODULE$.collectionAsScalaIterable(this.slaves().values()).foreach((Function1)new Serializable(this, caughtUpCounter$1, notCaughtUpCounter$1){
            public static final long serialVersionUID;
            private final IntRef caughtUpCounter$1;
            private final IntRef notCaughtUpCounter$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(SlaveState slave) {
                if (slave.isCaughtUp()) {
                    ++this.caughtUpCounter$1.elem;
                } else {
                    ++this.notCaughtUpCounter$1.elem;
                }
            }
            {
                this.caughtUpCounter$1 = intRef;
                this.notCaughtUpCounter$1 = intRef2;
            }
        });
        String rc = "";
        if (notCaughtUpCounter$1.elem > 0) {
            rc = new StringBuilder().append((Object)rc).append((Object)Predef$.MODULE$.augmentString("%d slave nodes attaching. ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)notCaughtUpCounter$1.elem)}))).toString();
        }
        if (caughtUpCounter$1.elem > 0) {
            rc = new StringBuilder().append((Object)rc).append((Object)Predef$.MODULE$.augmentString("%d slave nodes attached. ").format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)caughtUpCounter$1.elem)}))).toString();
        }
        return var3_3;
    }

    @Override
    public void doStart() {
        ReplicationSupport$.MODULE$.unstash(this.directory());
        super.doStart();
        this.start_protocol_server();
        this.wal_sync_to(this.wal_append_position());
    }

    @Override
    public void doStop(ServiceStopper stopper) {
        if (this.transport_server() != null) {
            this.stop_protocol_server();
            this.transport_server_$eq(null);
        }
        super.doStop(stopper);
    }

    @Override
    public MasterLevelDBClient createClient() {
        return new MasterLevelDBClient(this);
    }

    public MasterLevelDBClient master_client() {
        return (MasterLevelDBClient)this.client();
    }

    public TransportServer transport_server() {
        return this.transport_server;
    }

    public void transport_server_$eq(TransportServer transportServer) {
        this.transport_server = transportServer;
    }

    public CountDownLatch start_latch() {
        return this.start_latch;
    }

    public void start_protocol_server() {
        this.transport_server_$eq(new TcpTransportServer(new URI(this.bind())));
        this.transport_server().setBlockingExecutor(this.blocking_executor());
        this.transport_server().setDispatchQueue(package$.MODULE$.createQueue("replication server"));
        this.transport_server().setTransportServerListener(new TransportServerListener(this){
            private final MasterLevelDBStore $outer;

            public void onAccept(Transport transport) {
                transport.setDispatchQueue(package$.MODULE$.createQueue(new StringBuilder().append((Object)"connection from ").append((Object)transport.getRemoteAddress()).toString()));
                transport.setBlockingExecutor(this.$outer.blocking_executor());
                new Session(this.$outer, transport);
            }

            public void onAcceptError(Exception error) {
                MasterLevelDBStore$.MODULE$.warn(error);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
        this.transport_server().start(package$.MODULE$.$up((Function0<BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID;
            private final MasterLevelDBStore $outer;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.start_latch().countDown();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
        this.start_latch().await();
    }

    public int getPort() {
        this.start_latch().await();
        return ((InetSocketAddress)this.transport_server().getSocketAddress()).getPort();
    }

    public void stop_protocol_server() {
        this.transport_server().stop(package$.MODULE$.NOOP());
    }

    public PositionSync position_sync() {
        return this.position_sync;
    }

    public void position_sync_$eq(PositionSync positionSync) {
        this.position_sync = positionSync;
    }

    public void wal_sync_to(long position) {
        if (this.minSlaveAcks() < 1 || (this.syncToMask() & MasterLevelDBStore$.MODULE$.SYNC_TO_REMOTE()) == 0) {
            return;
        }
        if (this.isStoppedOrStopping()) {
            throw new IllegalStateException("Store replication stopped");
        }
        PositionSync position_sync = new PositionSync(position, this.minSlaveAcks());
        this.position_sync_$eq(position_sync);
        JavaConversions$.MODULE$.collectionAsScalaIterable(this.slaves().values()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(SlaveState slave) {
                slave.check_position_sync();
            }
        });
        while (!position_sync.await(1L, TimeUnit.SECONDS)) {
            if (this.isStoppedOrStopping()) {
                throw new IllegalStateException("Store replication stopped");
            }
            MasterLevelDBStore$.MODULE$.warn((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "Store update waiting on %d replica(s) to catch up to log position %d. %s";
                }
            }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.minSlaveAcks()), BoxesRunTime.boxToLong((long)position), this.status()}));
        }
        return;
    }

    public boolean isStoppedOrStopping() {
        if (this.isStopped() || this.isStopping()) {
            return true;
        }
        return this.broker_service() != null && this.broker_service().isStopping();
    }

    public long date() {
        return System.currentTimeMillis();
    }

    public void replicate_wal(File file, long position, long offset, long length) {
        if (length > 0L) {
            LogWrite value = new LogWrite();
            value.file = position;
            value.offset = offset;
            value.length = length;
            value.date = this.date();
            this.wal_date_$eq(value.date);
            value.sync = (this.syncToMask() & MasterLevelDBStore$.MODULE$.SYNC_TO_REMOTE_DISK()) != 0;
            ReplicationFrame frame1$2 = new ReplicationFrame(ReplicationSupport$.MODULE$.WAL_ACTION(), JsonCodec$.MODULE$.encode(value));
            FileTransferFrame frame2$2 = new FileTransferFrame(file, offset, length);
            JavaConversions$.MODULE$.collectionAsScalaIterable(this.slaves().values()).foreach((Function1)new Serializable(this, frame1$2, frame2$2){
                public static final long serialVersionUID;
                private final ReplicationFrame frame1$2;
                private final FileTransferFrame frame2$2;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final void apply(SlaveState slave) {
                    slave.replicate_wal(this.frame1$2, this.frame2$2);
                }
                {
                    this.frame1$2 = replicationFrame;
                    this.frame2$2 = fileTransferFrame;
                }
            });
        }
    }

    public void replicate_log_delete(long log2) {
        LogDelete value = new LogDelete();
        value.log = log2;
        ReplicationFrame frame$1 = new ReplicationFrame(ReplicationSupport$.MODULE$.LOG_DELETE_ACTION(), JsonCodec$.MODULE$.encode(value));
        JavaConversions$.MODULE$.collectionAsScalaIterable(this.slaves().values()).foreach((Function1)new Serializable(this, frame$1){
            public static final long serialVersionUID;
            private final ReplicationFrame frame$1;

            static {
                long l = serialVersionUID = 0L;
            }

            public final void apply(SlaveState slave) {
                slave.replicate_wal(this.frame$1, slave.replicate_wal$default$2());
            }
            {
                this.frame$1 = replicationFrame;
            }
        });
    }

    public long wal_append_position() {
        return this.client().wal_append_position();
    }

    public long wal_date() {
        return this.wal_date;
    }

    public void wal_date_$eq(long l) {
        this.wal_date = l;
    }

    public int getReplicas() {
        return this.replicas();
    }

    public String getBind() {
        return this.bind();
    }

    public MasterLevelDBStore() {
        ReplicatedLevelDBStoreTrait$class.$init$(this);
        this.bind = "tcp://0.0.0.0:61619";
        this.replicas = 3;
        this._syncTo = "quorum_mem";
        this.syncToMask = MasterLevelDBStore$.MODULE$.SYNC_TO_REMOTE_MEMORY();
        this.slaves = new ConcurrentHashMap();
        this.start_latch = new CountDownLatch(1);
        this.position_sync = new PositionSync(0L, 0);
        this.wal_date = 0L;
    }

    public class Session
    extends TransportHandler
    implements ScalaObject {
        private Login login;
        private SlaveState slave_state;
        private boolean disconnected;
        public final MasterLevelDBStore $outer;

        public Login login() {
            return this.login;
        }

        public void login_$eq(Login login) {
            this.login = login;
        }

        public SlaveState slave_state() {
            return this.slave_state;
        }

        public void slave_state_$eq(SlaveState slaveState) {
            this.slave_state = slaveState;
        }

        public boolean disconnected() {
            return this.disconnected;
        }

        public void disconnected_$eq(boolean bl) {
            this.disconnected = bl;
        }

        public DispatchQueue queue() {
            return super.transport().getDispatchQueue();
        }

        public void onTransportFailure(IOException error$1) {
            if (!this.disconnected()) {
                MasterLevelDBStore$.MODULE$.warn((Function0<String>)new Serializable(this, error$1){
                    public static final long serialVersionUID;
                    private final IOException error$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Unexpected session error: ").append((Object)this.error$1).toString();
                    }
                    {
                        this.error$1 = iOException;
                    }
                }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            }
            super.onTransportFailure(error$1);
        }

        public void onTransportCommand(Object command) {
            Object object = command;
            if (object instanceof ReplicationFrame) {
                ReplicationFrame replicationFrame;
                ReplicationFrame command2 = replicationFrame = (ReplicationFrame)object;
                AsciiBuffer asciiBuffer = command2.action();
                AsciiBuffer asciiBuffer2 = ReplicationSupport$.MODULE$.LOGIN_ACTION();
                AsciiBuffer asciiBuffer3 = asciiBuffer;
                if (!(asciiBuffer2 != null ? !((Object)asciiBuffer2).equals(asciiBuffer3) : asciiBuffer3 != null)) {
                    this.handle_login(JsonCodec$.MODULE$.decode(command2.body(), Login.class));
                } else {
                    AsciiBuffer asciiBuffer4 = ReplicationSupport$.MODULE$.SYNC_ACTION();
                    AsciiBuffer asciiBuffer5 = asciiBuffer;
                    if (!(asciiBuffer4 != null ? !((Object)asciiBuffer4).equals(asciiBuffer5) : asciiBuffer5 != null)) {
                        this.handle_sync();
                    } else {
                        AsciiBuffer asciiBuffer6 = ReplicationSupport$.MODULE$.GET_ACTION();
                        AsciiBuffer asciiBuffer7 = asciiBuffer;
                        if (!(asciiBuffer6 != null ? !((Object)asciiBuffer6).equals(asciiBuffer7) : asciiBuffer7 != null)) {
                            this.handle_get(JsonCodec$.MODULE$.decode(command2.body(), Transfer.class));
                        } else {
                            AsciiBuffer asciiBuffer8 = ReplicationSupport$.MODULE$.ACK_ACTION();
                            AsciiBuffer asciiBuffer9 = asciiBuffer;
                            if (!(asciiBuffer8 != null ? !((Object)asciiBuffer8).equals(asciiBuffer9) : asciiBuffer9 != null)) {
                                this.handle_ack(JsonCodec$.MODULE$.decode(command2.body(), WalAck.class));
                            } else {
                                AsciiBuffer asciiBuffer10 = ReplicationSupport$.MODULE$.DISCONNECT_ACTION();
                                AsciiBuffer asciiBuffer11 = asciiBuffer;
                                if (!(asciiBuffer10 != null ? !((Object)asciiBuffer10).equals(asciiBuffer11) : asciiBuffer11 != null)) {
                                    this.handle_disconnect();
                                } else {
                                    this.sendError(new StringBuilder().append((Object)"Unknown frame action: ").append((Object)command2.action()).toString());
                                }
                            }
                        }
                    }
                }
                return;
            }
            throw new MatchError(object);
        }

        public void handle_login(Login request) {
            String string = request.security_token;
            String string2 = this.org$apache$activemq$leveldb$replicated$MasterLevelDBStore$Session$$$outer().securityToken();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.login_$eq(request);
                this.sendOk(null);
            } else {
                this.sendError("Invalid security_token");
            }
        }

        public void onTransportDisconnected() {
            SlaveState slave_state = this.slave_state();
            if (slave_state != null) {
                this.slave_state_$eq(null);
                if (slave_state.stop(this) && this.org$apache$activemq$leveldb$replicated$MasterLevelDBStore$Session$$$outer().isStarted()) {
                    this.org$apache$activemq$leveldb$replicated$MasterLevelDBStore$Session$$$outer().slaves().remove(slave_state.slave_id(), slave_state);
                }
            }
        }

        public void handle_disconnect() {
            this.disconnected_$eq(true);
            this.sendOk(null);
        }

        public void handle_sync() {
            Object object;
            if (this.login() == null) {
                this.sendError("Not logged in");
                return;
            }
            MasterLevelDBStore$.MODULE$.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "handle_sync";
                }
            }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.slave_state_$eq(this.org$apache$activemq$leveldb$replicated$MasterLevelDBStore$Session$$$outer().slaves().get(this.login().node_id));
            if (this.slave_state() == null) {
                this.slave_state_$eq(new SlaveState(this.org$apache$activemq$leveldb$replicated$MasterLevelDBStore$Session$$$outer(), this.login().node_id));
                object = this.org$apache$activemq$leveldb$replicated$MasterLevelDBStore$Session$$$outer().slaves().put(this.login().node_id, this.slave_state());
            } else {
                object = BoxedUnit.UNIT;
            }
            this.slave_state().start(this);
        }

        public void handle_ack(WalAck req) {
            if (this.login() == null || this.slave_state() == null) {
                return;
            }
            this.slave_state().position_update(req.position);
        }

        public void handle_get(Transfer req) {
            File file;
            if (this.login() == null) {
                this.sendError("Not logged in");
                return;
            }
            File file2 = file = req.file.startsWith("log/") ? FileSupport$.MODULE$.toRichFile(this.org$apache$activemq$leveldb$replicated$MasterLevelDBStore$Session$$$outer().client().logDirectory()).$div(Predef$.MODULE$.augmentString(req.file).stripPrefix("log/")) : FileSupport$.MODULE$.toRichFile(this.org$apache$activemq$leveldb$replicated$MasterLevelDBStore$Session$$$outer().client().directory()).$div(req.file);
            if (file.exists()) {
                long length = file.length();
                if (req.offset > length) {
                    this.sendError("Invalid offset");
                    return;
                }
                if (req.offset + req.length > length) {
                    this.sendError("Invalid length");
                }
                this.sendOk(null);
                this.send(new FileTransferFrame(file, req.offset, req.length));
                return;
            }
            this.sendError("file does not exist");
        }

        public MasterLevelDBStore org$apache$activemq$leveldb$replicated$MasterLevelDBStore$Session$$$outer() {
            return this.$outer;
        }

        public Session(MasterLevelDBStore $outer, Transport transport) {
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            super(transport);
            this.disconnected = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class SlaveState
    implements ScalaObject {
        private final String slave_id;
        private Option<Object> held_snapshot;
        private Session session;
        private AtomicLong position;
        private AtomicBoolean caughtUp;
        private SocketAddress socketAddress;
        private volatile PositionSync last_position_sync;
        public final MasterLevelDBStore $outer;

        public String slave_id() {
            return this.slave_id;
        }

        public Option<Object> held_snapshot() {
            return this.held_snapshot;
        }

        public void held_snapshot_$eq(Option<Object> option) {
            this.held_snapshot = option;
        }

        public Session session() {
            return this.session;
        }

        public void session_$eq(Session session) {
            this.session = session;
        }

        public AtomicLong position() {
            return this.position;
        }

        public void position_$eq(AtomicLong atomicLong) {
            this.position = atomicLong;
        }

        public AtomicBoolean caughtUp() {
            return this.caughtUp;
        }

        public void caughtUp_$eq(AtomicBoolean atomicBoolean) {
            this.caughtUp = atomicBoolean;
        }

        public SocketAddress socketAddress() {
            return this.socketAddress;
        }

        public void socketAddress_$eq(SocketAddress socketAddress) {
            this.socketAddress = socketAddress;
        }

        public void start(Session session$1) {
            MasterLevelDBStore$.MODULE$.debug((Function0<String>)new Serializable(this){
                public static final long serialVersionUID;

                static {
                    long l = serialVersionUID = 0L;
                }

                public final String apply() {
                    return "SlaveState:start";
                }
            }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
            this.socketAddress_$eq(session$1.transport().getRemoteAddress());
            SlaveState slaveState = this;
            synchronized (slaveState) {
                if (this.session() != null) {
                    this.session().transport().stop(package$.MODULE$.NOOP());
                }
                this.session_$eq(session$1);
                long snapshot_id = this.org$apache$activemq$leveldb$replicated$MasterLevelDBStore$SlaveState$$$outer().client().lastIndexSnapshotPos();
                this.held_snapshot_$eq((Option<Object>)Option$.MODULE$.apply((Object)BoxesRunTime.boxToLong((long)snapshot_id)));
                this.position().set(0L);
                SyncResponse syncResponse = this.org$apache$activemq$leveldb$replicated$MasterLevelDBStore$SlaveState$$$outer().master_client().snapshot_state(snapshot_id);
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl13 : MonitorExitStatement: MONITOREXIT : var3_2
                SyncResponse resp$1 = syncResponse;
                MasterLevelDBStore$.MODULE$.info((Function0<String>)new Serializable(this){
                    public static final long serialVersionUID;
                    private final SlaveState $outer;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final String apply() {
                        return new StringBuilder().append((Object)"Slave has connected: ").append((Object)this.$outer.slave_id()).toString();
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                package$.MODULE$.DispatchQueueWrapper(session$1.queue()).apply((Function0<BoxedUnit>)new Serializable(this, session$1, resp$1){
                    public static final long serialVersionUID;
                    private final Session session$1;
                    private final SyncResponse resp$1;

                    static {
                        long l = serialVersionUID = 0L;
                    }

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.session$1.sendOk(this.resp$1);
                    }
                    {
                        this.session$1 = session;
                        this.resp$1 = syncResponse;
                    }
                });
                return;
            }
        }

        public boolean stop(Session session) {
            SlaveState slaveState = this;
            synchronized (slaveState) {
                Boolean bl;
                Session session2 = this.session();
                Session session3 = session;
                if (!(session2 != null ? !session2.equals(session3) : session3 != null)) {
                    MasterLevelDBStore$.MODULE$.info((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;
                        private final SlaveState $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Slave has disconnected: ").append((Object)this.$outer.slave_id()).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    bl = BoxesRunTime.boxToBoolean((boolean)true);
                } else {
                    bl = BoxesRunTime.boxToBoolean((boolean)false);
                }
                Boolean bl2 = bl;
                return BoxesRunTime.unboxToBoolean((Object)bl2);
            }
        }

        public void replicate_wal(ReplicationFrame frame1$1, FileTransferFrame frame2$1) {
            SlaveState slaveState = this;
            synchronized (slaveState) {
                Session session = this.session();
                // MONITOREXIT @DISABLED, blocks:[0, 1] lbl5 : MonitorExitStatement: MONITOREXIT : var4_3
                Session h$1 = session;
                if (h$1 != null) {
                    package$.MODULE$.DispatchQueueWrapper(h$1.queue()).apply((Function0<BoxedUnit>)new Serializable(this, frame1$1, frame2$1, h$1){
                        public static final long serialVersionUID;
                        private final ReplicationFrame frame1$1;
                        private final FileTransferFrame frame2$1;
                        private final Session h$1;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final void apply() {
                            this.apply$mcV$sp();
                        }

                        public void apply$mcV$sp() {
                            this.h$1.send(this.frame1$1);
                            if (this.frame2$1 != null) {
                                this.h$1.send(this.frame2$1);
                            }
                        }
                        {
                            this.frame1$1 = replicationFrame;
                            this.frame2$1 = fileTransferFrame;
                            this.h$1 = session;
                        }
                    });
                }
                return;
            }
        }

        public FileTransferFrame replicate_wal$default$2() {
            return null;
        }

        public void position_update(long position) {
            this.position().getAndSet(position);
            this.check_position_sync();
        }

        public PositionSync last_position_sync() {
            return this.last_position_sync;
        }

        public void last_position_sync_$eq(PositionSync positionSync) {
            this.last_position_sync = positionSync;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void check_position_sync() {
            PositionSync p = this.org$apache$activemq$leveldb$replicated$MasterLevelDBStore$SlaveState$$$outer().position_sync();
            PositionSync positionSync = this.last_position_sync();
            PositionSync positionSync2 = p;
            if ((positionSync == null ? positionSync2 != null : !positionSync.equals(positionSync2)) && this.position().get() >= p.position()) {
                BoxedUnit boxedUnit;
                if (this.caughtUp().compareAndSet(false, true)) {
                    MasterLevelDBStore$.MODULE$.info((Function0<String>)new Serializable(this){
                        public static final long serialVersionUID;
                        private final SlaveState $outer;

                        static {
                            long l = serialVersionUID = 0L;
                        }

                        public final String apply() {
                            return new StringBuilder().append((Object)"Slave has now caught up: ").append((Object)this.$outer.slave_id()).toString();
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                        }
                    }, (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[0]));
                    SlaveState slaveState = this;
                    synchronized (slaveState) {
                        this.held_snapshot_$eq((Option<Object>)None$.MODULE$);
                        BoxedUnit boxedUnit2 = BoxedUnit.UNIT;
                        // MONITOREXIT @DISABLED, blocks:[0, 1, 4, 5] lbl12 : MonitorExitStatement: MONITOREXIT : slaveState
                        boxedUnit = boxedUnit2;
                    }
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                p.countDown();
                this.last_position_sync_$eq(p);
            }
        }

        public boolean isCaughtUp() {
            return this.caughtUp().get();
        }

        public SlaveStatus status() {
            return new SlaveStatus(this.slave_id(), this.socketAddress().toString(), this.isCaughtUp(), this.position().get());
        }

        public MasterLevelDBStore org$apache$activemq$leveldb$replicated$MasterLevelDBStore$SlaveState$$$outer() {
            return this.$outer;
        }

        public SlaveState(MasterLevelDBStore $outer, String slave_id) {
            this.slave_id = slave_id;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
            this.held_snapshot = None$.MODULE$;
            this.position = new AtomicLong(0L);
            this.caughtUp = new AtomicBoolean(false);
            this.last_position_sync = null;
        }
    }
}

