/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.web.config;

import java.util.Collection;
import javax.jms.ConnectionFactory;
import javax.management.remote.JMXServiceURL;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.activemq.web.config.AbstractConfiguration;

public class JNDIConfiguration
extends AbstractConfiguration {
    private static final String JNDI_JMS_CONNECTION_FACTORY = "java:comp/env/jms/connectionFactory";
    private static final String JNDI_JMS_URL = "java:comp/env/jms/url";
    private static final String JNDI_JMS_USER = "java:comp/env/jms/user";
    private static final String JNDI_JMS_PASSWORD = "java:comp/env/jms/password";
    private static final String JNDI_JMX_URL = "java:comp/env/jmx/url";
    private static final String JNDI_JMX_USER = "java:comp/env/jmx/user";
    private static final String JNDI_JMX_PASSWORD = "java:comp/env/jmx/password";
    private InitialContext context;

    public JNDIConfiguration() throws NamingException {
        this.context = new InitialContext();
    }

    public JNDIConfiguration(InitialContext context) {
        this.context = context;
    }

    @Override
    public ConnectionFactory getConnectionFactory() {
        try {
            ConnectionFactory connectionFactory = (ConnectionFactory)this.context.lookup(JNDI_JMS_CONNECTION_FACTORY);
            return connectionFactory;
        }
        catch (NameNotFoundException e) {
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        try {
            String jmsUrl = (String)this.context.lookup(JNDI_JMS_URL);
            if (jmsUrl == null) {
                throw new IllegalArgumentException("A JMS-url must be specified (system property java:comp/env/jms/url");
            }
            String jmsUser = this.getJndiString(JNDI_JMS_USER);
            String jmsPassword = this.getJndiString(JNDI_JMS_PASSWORD);
            return this.makeConnectionFactory(jmsUrl, jmsUser, jmsPassword);
        }
        catch (NameNotFoundException e) {
            throw new IllegalArgumentException("Neither a ConnectionFactory nor a JMS-url were specified");
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getJndiString(String name) {
        try {
            return (String)this.context.lookup(name);
        }
        catch (NamingException e) {
            return null;
        }
    }

    @Override
    public Collection<JMXServiceURL> getJmxUrls() {
        String jmxUrls = this.getJndiString(JNDI_JMX_URL);
        return this.makeJmxUrls(jmxUrls);
    }

    @Override
    public String getJmxPassword() {
        return this.getJndiString(JNDI_JMX_PASSWORD);
    }

    @Override
    public String getJmxUser() {
        return this.getJndiString(JNDI_JMX_USER);
    }
}

