/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.stax.impl.stax;

import java.util.Map;
import java.util.WeakHashMap;
import javax.xml.namespace.QName;
import org.apache.xml.security.stax.ext.stax.XMLSecNamespace;
import org.apache.xml.security.stax.impl.stax.XMLSecEventBaseImpl;

public class XMLSecNamespaceImpl
extends XMLSecEventBaseImpl
implements XMLSecNamespace {
    private static final Map<String, Map<String, XMLSecNamespace>> xmlSecNamespaceMap = new WeakHashMap<String, Map<String, XMLSecNamespace>>();
    private String prefix;
    private final String uri;
    private QName qName;

    private XMLSecNamespaceImpl(String prefix, String uri) {
        this.prefix = prefix;
        this.uri = uri;
    }

    public static XMLSecNamespace getInstance(String prefix, String uri) {
        Map<String, XMLSecNamespace> nsMap;
        if (prefix == null) {
            prefix = "";
        }
        if (uri == null) {
            uri = "";
        }
        if ((nsMap = xmlSecNamespaceMap.get(prefix)) != null) {
            XMLSecNamespace xmlSecNamespace = nsMap.get(uri);
            if (xmlSecNamespace != null) {
                return xmlSecNamespace;
            }
            xmlSecNamespace = new XMLSecNamespaceImpl(prefix, uri);
            nsMap.put(uri, xmlSecNamespace);
            return xmlSecNamespace;
        }
        nsMap = new WeakHashMap<String, XMLSecNamespace>();
        XMLSecNamespaceImpl xmlSecNamespace = new XMLSecNamespaceImpl(prefix, uri);
        nsMap.put(uri, xmlSecNamespace);
        xmlSecNamespaceMap.put(prefix, nsMap);
        return xmlSecNamespace;
    }

    @Override
    public int compareTo(XMLSecNamespace o) {
        return this.prefix.compareTo(o.getPrefix());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof XMLSecNamespace)) {
            return false;
        }
        XMLSecNamespace comparableNamespace = (XMLSecNamespace)obj;
        if (comparableNamespace.hashCode() != this.hashCode()) {
            return false;
        }
        return comparableNamespace.getPrefix().equals(this.prefix);
    }

    public int hashCode() {
        return this.prefix.hashCode();
    }

    @Override
    public QName getName() {
        if (this.qName == null) {
            this.qName = new QName("http://www.w3.org/2000/xmlns/", this.prefix);
        }
        return this.qName;
    }

    @Override
    public String getValue() {
        return this.uri;
    }

    @Override
    public String getDTDType() {
        return "CDATA";
    }

    @Override
    public boolean isSpecified() {
        return true;
    }

    @Override
    public String getNamespaceURI() {
        return this.uri;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public boolean isDefaultNamespaceDeclaration() {
        return this.prefix.length() == 0;
    }

    @Override
    public int getEventType() {
        return 13;
    }

    @Override
    public boolean isNamespace() {
        return true;
    }

    public String toString() {
        if (this.prefix == null || this.prefix.isEmpty()) {
            return "xmlns=\"" + this.uri + "\"";
        }
        return "xmlns:" + this.prefix + "=\"" + this.uri + "\"";
    }
}

