/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.felix.gogo.commands.Argument;
import org.apache.felix.gogo.commands.Command;
import org.apache.felix.gogo.commands.Option;
import org.switchyard.admin.Application;
import org.switchyard.admin.SwitchYard;
import org.switchyard.config.model.switchyard.ArtifactModel;
import org.switchyard.deploy.karaf.AbstractSwitchYardServiceCommand;
import org.switchyard.deploy.karaf.PrintUtil;

@Command(scope="switchyard", name="uses-artifact", description="Returns a list of all SwitchYard applications referencing the specified artifact.")
public class UsesArtifactCommand
extends AbstractSwitchYardServiceCommand {
    @Argument(index=0, name="type", description="Specifies the search type [name | url].", required=true)
    private SearchType _type;
    @Argument(index=1, name="patterns", description="Specifies the search pattern to use.", multiValued=true)
    private List<String> _patterns;
    @Option(name="--regex", description="If specified, treat the pattern(s) as a regular expression.")
    private boolean _regex;

    @Override
    protected Object doExecute(SwitchYard switchYard) throws Exception {
        Pattern pattern = this.compilePattern(this._patterns, this._regex);
        for (Application application : switchYard.getApplications()) {
            if (application.getConfig().getArtifacts() == null) continue;
            boolean printHeader = true;
            for (ArtifactModel artifact : application.getConfig().getArtifacts().getArtifacts()) {
                if (!this._type.matches(pattern, artifact)) continue;
                if (printHeader) {
                    System.out.println(application.getName() + " = [");
                    printHeader = false;
                }
                System.out.println(PrintUtil.printArtifact(artifact, 1));
            }
            if (printHeader) continue;
            System.out.println("]");
        }
        return null;
    }

    public static enum SearchType {
        name{

            @Override
            public boolean matches(Pattern pattern, ArtifactModel artifact) {
                Matcher matcher = pattern.matcher(artifact.getName());
                return matcher.find();
            }
        }
        ,
        url{

            @Override
            public boolean matches(Pattern pattern, ArtifactModel artifact) {
                Matcher matcher = pattern.matcher(artifact.getURL());
                return matcher.find();
            }
        };


        public abstract boolean matches(Pattern var1, ArtifactModel var2);
    }
}

