/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.read;

import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.infinispan.commands.VisitableCommand;
import org.infinispan.commands.Visitor;
import org.infinispan.commands.read.AbstractLocalCommand;
import org.infinispan.container.DataContainer;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.InvocationContext;

public class KeySetCommand
extends AbstractLocalCommand
implements VisitableCommand {
    private final DataContainer container;

    public KeySetCommand(DataContainer container) {
        this.container = container;
    }

    @Override
    public Object acceptVisitor(InvocationContext ctx, Visitor visitor) throws Throwable {
        return visitor.visitKeySetCommand(ctx, this);
    }

    @Override
    public Set<Object> perform(InvocationContext ctx) throws Throwable {
        Set<Object> objects = this.container.keySet();
        if (this.noTxModifications(ctx)) {
            return new ExpiredFilteredKeySet(objects, this.container);
        }
        return new FilteredKeySet(objects, ctx.getLookedUpEntries(), this.container);
    }

    public String toString() {
        return "KeySetCommand{set=" + this.container.size() + " elements" + '}';
    }

    public static class ExpiredFilteredKeySet
    extends AbstractSet<Object> {
        final Set<Object> keySet;
        final DataContainer container;

        public ExpiredFilteredKeySet(Set<Object> keySet, DataContainer container) {
            this.keySet = keySet;
            this.container = container;
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Iterator<Object> iterator() {
            return new Itr();
        }

        @Override
        public int size() {
            int s = this.keySet.size();
            for (Object k : this.keySet) {
                if (this.container.containsKey(k)) continue;
                --s;
            }
            return s;
        }

        private class Itr
        implements Iterator<Object> {
            private final Iterator<Object> it;
            private Object next;

            private Itr() {
                this.it = ExpiredFilteredKeySet.this.keySet.iterator();
                this.fetchNext();
            }

            private void fetchNext() {
                while (this.it.hasNext()) {
                    Object k = this.it.next();
                    if (!ExpiredFilteredKeySet.this.container.containsKey(k)) continue;
                    this.next = k;
                    break;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetchNext();
                }
                return this.next != null;
            }

            @Override
            public Object next() {
                if (this.next == null) {
                    this.fetchNext();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private static class FilteredKeySet
    extends AbstractSet<Object> {
        final Set<Object> keySet;
        final Map<Object, CacheEntry> lookedUpEntries;
        final DataContainer container;

        FilteredKeySet(Set<Object> keySet, Map<Object, CacheEntry> lookedUpEntries, DataContainer container) {
            this.keySet = keySet;
            this.lookedUpEntries = lookedUpEntries;
            this.container = container;
        }

        @Override
        public int size() {
            int size = this.keySet.size();
            for (Object k : this.keySet) {
                if (this.container.containsKey(k)) continue;
                --size;
            }
            for (CacheEntry e : this.lookedUpEntries.values()) {
                if (e.isCreated()) {
                    ++size;
                    continue;
                }
                if (!e.isRemoved()) continue;
                --size;
            }
            return Math.max(size, 0);
        }

        @Override
        public boolean contains(Object o) {
            CacheEntry e = this.lookedUpEntries.get(o);
            if (e == null || e.isRemoved()) {
                return false;
            }
            if (e.isChanged() || e.isCreated()) {
                return true;
            }
            return this.keySet.contains(o);
        }

        @Override
        public Iterator<Object> iterator() {
            return new Itr();
        }

        @Override
        public boolean add(Object e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        private class Itr
        implements Iterator<Object> {
            private final Iterator<CacheEntry> it1;
            private final Iterator<Object> it2;
            private boolean atIt1;
            private Object next;

            Itr() {
                this.it1 = FilteredKeySet.this.lookedUpEntries.values().iterator();
                this.it2 = FilteredKeySet.this.keySet.iterator();
                this.atIt1 = true;
                this.fetchNext();
            }

            private void fetchNext() {
                boolean found;
                if (this.atIt1) {
                    found = false;
                    while (this.it1.hasNext()) {
                        CacheEntry e = this.it1.next();
                        if (!e.isCreated()) continue;
                        this.next = e.getKey();
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.atIt1 = false;
                    }
                }
                if (!this.atIt1) {
                    found = false;
                    while (this.it2.hasNext()) {
                        Object k = this.it2.next();
                        CacheEntry e = FilteredKeySet.this.lookedUpEntries.get(k);
                        if (e != null && e.isRemoved()) continue;
                        this.next = k;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.next = null;
                    }
                }
            }

            @Override
            public boolean hasNext() {
                if (this.next == null) {
                    this.fetchNext();
                }
                return this.next != null;
            }

            @Override
            public Object next() {
                if (this.next == null) {
                    this.fetchNext();
                }
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Object ret = this.next;
                this.next = null;
                return ret;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }
}

