/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jndi;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.NamingException;
import javax.naming.NoInitialContextException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.InitialContextFactoryBuilder;
import javax.naming.spi.ObjectFactory;
import org.apache.aries.jndi.ContextProvider;
import org.apache.aries.jndi.DelegateContext;
import org.apache.aries.jndi.SingleContextProvider;
import org.apache.aries.jndi.URLContextProvider;
import org.apache.aries.jndi.Utils;
import org.apache.aries.jndi.startup.Activator;
import org.apache.aries.jndi.tracker.ServiceTrackerCustomizers;
import org.apache.aries.jndi.urls.URLObjectFactoryFinder;
import org.apache.aries.util.service.registry.ServicePair;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

public final class ContextHelper {
    private static final Logger logger = Logger.getLogger(ContextHelper.class.getName());

    private ContextHelper() {
        throw new RuntimeException();
    }

    public static ContextProvider createURLContext(BundleContext context, String urlScheme, Hashtable<?, ?> env) throws NamingException {
        ObjectFactory factory;
        ServicePair<ObjectFactory> urlObjectFactory = ContextHelper.getURLObjectFactory(context, urlScheme, env);
        if (urlObjectFactory != null && (factory = (ObjectFactory)urlObjectFactory.get()) != null) {
            return new URLContextProvider(context, urlObjectFactory.getReference(), factory, env);
        }
        return null;
    }

    public static final ServicePair<ObjectFactory> getURLObjectFactory(BundleContext ctx, String urlScheme, Hashtable<?, ?> environment) throws NamingException {
        ServicePair result = null;
        ServiceReference ref = ServiceTrackerCustomizers.URL_FACTORY_CACHE.find(urlScheme);
        if (ref == null) {
            ServiceReference[] refs = AccessController.doPrivileged(new PrivilegedAction<ServiceReference[]>(){

                @Override
                public ServiceReference[] run() {
                    return Activator.getURLObectFactoryFinderServices();
                }
            });
            if (refs != null) {
                for (ServiceReference finderRef : refs) {
                    URLObjectFactoryFinder finder = (URLObjectFactoryFinder)Utils.getServicePrivileged(ctx, finderRef);
                    if (finder == null) continue;
                    ObjectFactory f = finder.findFactory(urlScheme, environment);
                    if (f != null) {
                        result = new ServicePair(ctx, finderRef, (Object)f);
                        break;
                    }
                    ctx.ungetService(finderRef);
                }
            }
        } else {
            result = new ServicePair(ctx, ref);
        }
        return result;
    }

    public static Context getInitialContext(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        ContextProvider provider;
        BundleContext jndiBundleContext;
        final Bundle jndiBundle = FrameworkUtil.getBundle(ContextHelper.class);
        if (jndiBundle != null && !(jndiBundleContext = AccessController.doPrivileged(new PrivilegedAction<BundleContext>(){

            @Override
            public BundleContext run() {
                return jndiBundle.getBundleContext();
            }
        })).getClass().equals(context.getClass())) {
            context = jndiBundleContext;
        }
        if ((provider = ContextHelper.getContextProvider(context, environment)) != null) {
            return new DelegateContext(context, provider);
        }
        String contextFactoryClass = (String)environment.get("java.naming.factory.initial");
        if (contextFactoryClass == null) {
            return new DelegateContext(context, environment);
        }
        throw new NoInitialContextException(Utils.MESSAGES.getMessage("no.initial.context.factory", new Object[]{contextFactoryClass}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ContextProvider getContextProvider(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        ContextProvider provider = null;
        String contextFactoryClass = (String)environment.get("java.naming.factory.initial");
        if (contextFactoryClass == null) {
            ServiceReference[] references;
            provider = ContextHelper.getInitialContextUsingBuilder(context, environment);
            if (provider == null && (references = AccessController.doPrivileged(new PrivilegedAction<ServiceReference[]>(){

                @Override
                public ServiceReference[] run() {
                    return Activator.getInitialContextFactoryServices();
                }
            })) != null) {
                Context initialContext = null;
                for (ServiceReference reference : references) {
                    InitialContextFactory factory = (InitialContextFactory)Utils.getServicePrivileged(context, reference);
                    try {
                        initialContext = factory.getInitialContext(environment);
                        if (initialContext == null) continue;
                        provider = new SingleContextProvider(context, reference, initialContext);
                        break;
                    }
                    finally {
                        if (provider == null) {
                            context.ungetService(reference);
                        }
                    }
                }
            }
        } else {
            ServiceReference ref = ServiceTrackerCustomizers.ICF_CACHE.find(contextFactoryClass);
            if (ref != null) {
                Context initialContext = null;
                InitialContextFactory factory = (InitialContextFactory)Utils.getServicePrivileged(context, ref);
                if (factory != null) {
                    try {
                        initialContext = factory.getInitialContext(environment);
                        provider = new SingleContextProvider(context, ref, initialContext);
                    }
                    finally {
                        if (provider == null) {
                            context.ungetService(ref);
                        }
                    }
                }
            }
            if (provider == null) {
                provider = ContextHelper.getInitialContextUsingBuilder(context, environment);
            }
        }
        return provider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ContextProvider getInitialContextUsingBuilder(BundleContext context, Hashtable<?, ?> environment) throws NamingException {
        SingleContextProvider provider = null;
        ServiceReference[] refs = AccessController.doPrivileged(new PrivilegedAction<ServiceReference[]>(){

            @Override
            public ServiceReference[] run() {
                return Activator.getInitialContextFactoryBuilderServices();
            }
        });
        if (refs != null) {
            InitialContextFactory factory = null;
            for (ServiceReference ref : refs) {
                InitialContextFactoryBuilder builder = (InitialContextFactoryBuilder)Utils.getServicePrivileged(context, ref);
                try {
                    factory = builder.createInitialContextFactory(environment);
                }
                catch (NamingException ne) {
                }
                catch (NullPointerException npe) {
                    logger.log(Level.SEVERE, "NPE caught in ContextHelper.getInitialContextUsingBuilder. context=" + context + " ref=" + ref);
                    throw npe;
                }
                if (factory != null) {
                    try {
                        provider = new SingleContextProvider(context, ref, factory.getInitialContext(environment));
                        break;
                    }
                    finally {
                        if (provider == null) {
                            context.ungetService(ref);
                        }
                    }
                }
                context.ungetService(ref);
            }
        }
        return provider;
    }
}

