/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.client;

import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.UnresolvedAddressException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.jms.JMSException;
import javax.jms.XASession;
import org.apache.qpid.AMQException;
import org.apache.qpid.client.AMQConnection;
import org.apache.qpid.client.AMQConnectionDelegate;
import org.apache.qpid.client.AMQSession;
import org.apache.qpid.client.AMQSession_0_8;
import org.apache.qpid.client.ConnectionTuneParameters;
import org.apache.qpid.client.HeartbeatListener;
import org.apache.qpid.client.JMSAMQException;
import org.apache.qpid.client.failover.FailoverException;
import org.apache.qpid.client.failover.FailoverProtectedOperation;
import org.apache.qpid.client.failover.FailoverRetrySupport;
import org.apache.qpid.client.state.AMQState;
import org.apache.qpid.client.state.StateWaiter;
import org.apache.qpid.framing.BasicQosBody;
import org.apache.qpid.framing.BasicQosOkBody;
import org.apache.qpid.framing.ChannelOpenBody;
import org.apache.qpid.framing.ChannelOpenOkBody;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.ProtocolVersion;
import org.apache.qpid.framing.TxSelectBody;
import org.apache.qpid.framing.TxSelectOkBody;
import org.apache.qpid.jms.BrokerDetails;
import org.apache.qpid.jms.ChannelLimitReachedException;
import org.apache.qpid.jms.Session;
import org.apache.qpid.transport.ConnectionSettings;
import org.apache.qpid.transport.network.NetworkConnection;
import org.apache.qpid.transport.network.OutgoingNetworkTransport;
import org.apache.qpid.transport.network.Transport;
import org.apache.qpid.transport.network.security.SecurityLayer;
import org.apache.qpid.transport.network.security.SecurityLayerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AMQConnectionDelegate_8_0
implements AMQConnectionDelegate {
    private static final Logger _logger = LoggerFactory.getLogger(AMQConnectionDelegate_8_0.class);
    private final AMQConnection _conn;

    @Override
    public void closeConnection(long timeout) throws JMSException, AMQException {
        this._conn.getProtocolHandler().closeConnection(timeout);
    }

    public AMQConnectionDelegate_8_0(AMQConnection conn) {
        this._conn = conn;
    }

    protected boolean checkException(Throwable thrown) {
        Throwable cause = thrown.getCause();
        if (cause == null) {
            cause = thrown;
        }
        return cause instanceof ConnectException || cause instanceof UnresolvedAddressException;
    }

    @Override
    public ProtocolVersion makeBrokerConnection(BrokerDetails brokerDetail) throws AMQException, IOException {
        boolean brokerlistUseSsl;
        boolean connUseSsl;
        if (_logger.isDebugEnabled()) {
            _logger.debug("Connecting to broker:" + brokerDetail);
        }
        EnumSet<AMQState> openOrClosedStates = EnumSet.of(AMQState.CONNECTION_OPEN, AMQState.CONNECTION_CLOSED);
        ConnectionSettings settings = brokerDetail.buildConnectionSettings();
        settings.setProtocol(brokerDetail.getTransport());
        String connectionSslOption = this._conn.getConnectionURL().getOption("ssl");
        if (connectionSslOption != null && (connUseSsl = Boolean.parseBoolean(connectionSslOption)) != (brokerlistUseSsl = settings.isUseSSL())) {
            settings.setUseSSL(connUseSsl);
            if (_logger.isDebugEnabled()) {
                _logger.debug("Applied connection ssl option override, setting UseSsl to: " + connUseSsl);
            }
        }
        SecurityLayer securityLayer = SecurityLayerFactory.newInstance(settings);
        OutgoingNetworkTransport transport = Transport.getOutgoingTransportInstance(this.getProtocolVersion());
        NetworkConnection network = transport.connect(settings, securityLayer.receiver(this._conn.getProtocolHandler()), this._conn.getProtocolHandler());
        this._conn.getProtocolHandler().setNetworkConnection(network, securityLayer.sender(network.getSender()));
        StateWaiter waiter = this._conn.getProtocolHandler().createWaiter(openOrClosedStates);
        this._conn.getProtocolHandler().getProtocolSession().init(settings);
        AMQState state = waiter.await();
        if (state == AMQState.CONNECTION_OPEN) {
            this._conn.getFailoverPolicy().attainedConnection();
            this._conn.setConnected(true);
            this._conn.logConnected(network.getLocalAddress(), network.getRemoteAddress());
            return null;
        }
        return this._conn.getProtocolHandler().getSuggestedProtocolVersion();
    }

    public Session createSession(boolean transacted, int acknowledgeMode, int prefetch) throws JMSException {
        return this.createSession(transacted, acknowledgeMode, prefetch, prefetch);
    }

    @Override
    public XASession createXASession(int prefetchHigh, int prefetchLow) throws JMSException {
        throw new UnsupportedOperationException("0_8 version does not provide XA support");
    }

    @Override
    public XASession createXASession(int ackMode) throws JMSException {
        throw new UnsupportedOperationException("0_8 version does not provide XA support");
    }

    @Override
    public Session createSession(final boolean transacted, final int acknowledgeMode, final int prefetchHigh, final int prefetchLow) throws JMSException {
        this._conn.checkNotClosed();
        if (this._conn.channelLimitReached()) {
            throw new ChannelLimitReachedException(this._conn.getMaximumChannelCount());
        }
        return new FailoverRetrySupport<Session, JMSException>(new FailoverProtectedOperation<Session, JMSException>(){

            @Override
            public Session execute() throws JMSException, FailoverException {
                int channelId = AMQConnectionDelegate_8_0.this._conn.getNextChannelID();
                if (_logger.isDebugEnabled()) {
                    _logger.debug("Write channel open frame for channel id " + channelId);
                }
                AMQSession_0_8 session = new AMQSession_0_8(AMQConnectionDelegate_8_0.this._conn, channelId, transacted, acknowledgeMode, prefetchHigh, prefetchLow);
                AMQConnectionDelegate_8_0.this._conn.registerSession(channelId, session);
                boolean success = false;
                try {
                    AMQConnectionDelegate_8_0.this.createChannelOverWire(channelId, prefetchHigh, prefetchLow, transacted);
                    success = true;
                }
                catch (AMQException e) {
                    JMSException jmse = new JMSException("Error creating session: " + e);
                    jmse.setLinkedException((Exception)e);
                    jmse.initCause((Throwable)e);
                    throw jmse;
                }
                finally {
                    if (!success) {
                        AMQConnectionDelegate_8_0.this._conn.deregisterSession(channelId);
                    }
                }
                if (AMQConnectionDelegate_8_0.this._conn.started()) {
                    try {
                        session.start();
                    }
                    catch (AMQException e) {
                        throw new JMSAMQException(e);
                    }
                }
                return session;
            }
        }, this._conn).execute();
    }

    @Override
    public XASession createXASession() throws JMSException {
        return this.createXASession((int)this._conn.getMaxPrefetch(), (int)this._conn.getMaxPrefetch() / 2);
    }

    private void createChannelOverWire(int channelId, int prefetchHigh, int prefetchLow, boolean transacted) throws AMQException, FailoverException {
        ChannelOpenBody channelOpenBody = this._conn.getProtocolHandler().getMethodRegistry().createChannelOpenBody(null);
        this._conn.getProtocolHandler().syncWrite(channelOpenBody.generateFrame(channelId), ChannelOpenOkBody.class);
        BasicQosBody basicQosBody = this._conn.getProtocolHandler().getMethodRegistry().createBasicQosBody(0L, prefetchHigh, false);
        this._conn.getProtocolHandler().syncWrite(basicQosBody.generateFrame(channelId), BasicQosOkBody.class);
        if (transacted) {
            if (_logger.isDebugEnabled()) {
                _logger.debug("Issuing TxSelect for " + channelId);
            }
            TxSelectBody body = this._conn.getProtocolHandler().getMethodRegistry().createTxSelectBody();
            this._conn.getProtocolHandler().syncWrite(body.generateFrame(channelId), TxSelectOkBody.class);
        }
    }

    @Override
    public void failoverPrep() {
    }

    @Override
    public void resubscribeSessions() throws JMSException, AMQException, FailoverException {
        ArrayList<AMQSession> sessions = new ArrayList<AMQSession>(this._conn.getSessions().values());
        _logger.info(MessageFormat.format("Resubscribing sessions = {0} sessions.size={1}", sessions, sessions.size()));
        for (AMQSession s : sessions) {
            s.setFlowControl(true);
            this.reopenChannel(s.getChannelId(), s.getDefaultPrefetchHigh(), s.getDefaultPrefetchLow(), s.isTransacted());
            s.resubscribe();
        }
    }

    private void reopenChannel(int channelId, int prefetchHigh, int prefetchLow, boolean transacted) throws AMQException, FailoverException {
        try {
            this.createChannelOverWire(channelId, prefetchHigh, prefetchLow, transacted);
        }
        catch (AMQException e) {
            this._conn.deregisterSession(channelId);
            throw new AMQException(null, "Error reopening channel " + channelId + " after failover: " + e, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T, E extends Exception> T executeRetrySupport(FailoverProtectedOperation<T, E> operation) throws E {
        while (true) {
            try {
                this._conn.blockUntilNotFailingOver();
            }
            catch (InterruptedException e) {
                _logger.debug("Interrupted: " + e, (Throwable)e);
                return null;
            }
            Object object = this._conn.getFailoverMutex();
            synchronized (object) {
                block9: {
                    try {
                        return operation.execute();
                    }
                    catch (FailoverException e) {
                        _logger.debug("Failover exception caught during operation: " + e, (Throwable)e);
                    }
                    catch (IllegalStateException e) {
                        if (e.getMessage().startsWith("Fail-over interupted no-op failover support")) break block9;
                        throw e;
                    }
                }
            }
        }
    }

    @Override
    public int getMaxChannelID() {
        ConnectionTuneParameters params = this._conn.getProtocolHandler().getProtocolSession().getConnectionTuneParameters();
        return params == null ? 65535 : params.getChannelMax();
    }

    @Override
    public int getMinChannelID() {
        return 1;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return ProtocolVersion.v8_0;
    }

    @Override
    public boolean verifyClientID() throws JMSException {
        return true;
    }

    @Override
    public boolean isSupportedServerFeature(String featureName) {
        return "qpid.jms-selector".equals(featureName);
    }

    @Override
    public void setHeartbeatListener(HeartbeatListener listener) {
        this._conn.getProtocolHandler().setHeartbeatListener(listener);
    }

    @Override
    public boolean supportsIsBound() {
        boolean connectedToQpid = true;
        FieldTable serverProperties = this._conn.getProtocolHandler().getProtocolSession().getConnectionStartServerProperties();
        if (serverProperties != null && serverProperties.containsKey("product")) {
            String product = String.valueOf(serverProperties.getString("product")).toLowerCase();
            boolean bl = connectedToQpid = product.contains("qpid") || product.equals("unknown");
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("supportsIsBound: " + connectedToQpid);
        }
        return connectedToQpid;
    }
}

