/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_0_9;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.Content;
import org.apache.qpid.framing.FieldTable;
import org.apache.qpid.framing.MessageTransferBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_0_9.AMQMethodBody_0_9;
import org.apache.qpid.framing.amqp_0_9.MethodDispatcher_0_9;

public class MessageTransferBodyImpl
extends AMQMethodBody_0_9
implements MessageTransferBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new MessageTransferBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 120;
    public static final int METHOD_ID = 10;
    private final int _ticket;
    private final AMQShortString _destination;
    private final byte _bitfield0;
    private final long _ttl;
    private final short _priority;
    private final long _timestamp;
    private final short _deliveryMode;
    private final long _expiration;
    private final AMQShortString _exchange;
    private final AMQShortString _routingKey;
    private final AMQShortString _messageId;
    private final AMQShortString _correlationId;
    private final AMQShortString _replyTo;
    private final AMQShortString _contentType;
    private final AMQShortString _contentEncoding;
    private final AMQShortString _userId;
    private final AMQShortString _appId;
    private final AMQShortString _transactionId;
    private final byte[] _securityToken;
    private final FieldTable _applicationHeaders;
    private final Content _body;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public MessageTransferBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._ticket = this.readUnsignedShort(buffer);
        this._destination = this.readAMQShortString(buffer);
        this._bitfield0 = this.readBitfield(buffer);
        this._ttl = this.readLong(buffer);
        this._priority = this.readUnsignedByte(buffer);
        this._timestamp = this.readTimestamp(buffer);
        this._deliveryMode = this.readUnsignedByte(buffer);
        this._expiration = this.readTimestamp(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._routingKey = this.readAMQShortString(buffer);
        this._messageId = this.readAMQShortString(buffer);
        this._correlationId = this.readAMQShortString(buffer);
        this._replyTo = this.readAMQShortString(buffer);
        this._contentType = this.readAMQShortString(buffer);
        this._contentEncoding = this.readAMQShortString(buffer);
        this._userId = this.readAMQShortString(buffer);
        this._appId = this.readAMQShortString(buffer);
        this._transactionId = this.readAMQShortString(buffer);
        this._securityToken = this.readBytes(buffer);
        this._applicationHeaders = this.readFieldTable(buffer);
        this._body = this.readContent(buffer);
    }

    public MessageTransferBodyImpl(int ticket, AMQShortString destination, boolean redelivered, boolean immediate, long ttl, short priority, long timestamp, short deliveryMode, long expiration, AMQShortString exchange, AMQShortString routingKey, AMQShortString messageId, AMQShortString correlationId, AMQShortString replyTo, AMQShortString contentType, AMQShortString contentEncoding, AMQShortString userId, AMQShortString appId, AMQShortString transactionId, byte[] securityToken, FieldTable applicationHeaders, Content body) {
        this._ticket = ticket;
        this._destination = destination;
        byte bitfield0 = 0;
        if (redelivered) {
            bitfield0 = (byte)(bitfield0 | 1);
        }
        if (immediate) {
            bitfield0 = (byte)(bitfield0 | 2);
        }
        this._bitfield0 = bitfield0;
        this._ttl = ttl;
        this._priority = priority;
        this._timestamp = timestamp;
        this._deliveryMode = deliveryMode;
        this._expiration = expiration;
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._messageId = messageId;
        this._correlationId = correlationId;
        this._replyTo = replyTo;
        this._contentType = contentType;
        this._contentEncoding = contentEncoding;
        this._userId = userId;
        this._appId = appId;
        this._transactionId = transactionId;
        this._securityToken = securityToken;
        this._applicationHeaders = applicationHeaders;
        this._body = body;
    }

    @Override
    public int getClazz() {
        return 120;
    }

    @Override
    public int getMethod() {
        return 10;
    }

    @Override
    public final int getTicket() {
        return this._ticket;
    }

    @Override
    public final AMQShortString getDestination() {
        return this._destination;
    }

    @Override
    public final boolean getRedelivered() {
        return (this._bitfield0 & 1) != 0;
    }

    @Override
    public final boolean getImmediate() {
        return (this._bitfield0 & 2) != 0;
    }

    @Override
    public final long getTtl() {
        return this._ttl;
    }

    @Override
    public final short getPriority() {
        return this._priority;
    }

    @Override
    public final long getTimestamp() {
        return this._timestamp;
    }

    @Override
    public final short getDeliveryMode() {
        return this._deliveryMode;
    }

    @Override
    public final long getExpiration() {
        return this._expiration;
    }

    @Override
    public final AMQShortString getExchange() {
        return this._exchange;
    }

    @Override
    public final AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    @Override
    public final AMQShortString getMessageId() {
        return this._messageId;
    }

    @Override
    public final AMQShortString getCorrelationId() {
        return this._correlationId;
    }

    @Override
    public final AMQShortString getReplyTo() {
        return this._replyTo;
    }

    @Override
    public final AMQShortString getContentType() {
        return this._contentType;
    }

    @Override
    public final AMQShortString getContentEncoding() {
        return this._contentEncoding;
    }

    @Override
    public final AMQShortString getUserId() {
        return this._userId;
    }

    @Override
    public final AMQShortString getAppId() {
        return this._appId;
    }

    @Override
    public final AMQShortString getTransactionId() {
        return this._transactionId;
    }

    @Override
    public final byte[] getSecurityToken() {
        return this._securityToken;
    }

    @Override
    public final FieldTable getApplicationHeaders() {
        return this._applicationHeaders;
    }

    @Override
    public final Content getBody() {
        return this._body;
    }

    @Override
    protected int getBodySize() {
        int size = 29;
        size += this.getSizeOf(this._destination);
        size += this.getSizeOf(this._exchange);
        size += this.getSizeOf(this._routingKey);
        size += this.getSizeOf(this._messageId);
        size += this.getSizeOf(this._correlationId);
        size += this.getSizeOf(this._replyTo);
        size += this.getSizeOf(this._contentType);
        size += this.getSizeOf(this._contentEncoding);
        size += this.getSizeOf(this._userId);
        size += this.getSizeOf(this._appId);
        size += this.getSizeOf(this._transactionId);
        size += this.getSizeOf(this._securityToken);
        size += this.getSizeOf(this._applicationHeaders);
        return size += this.getSizeOf(this._body);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeUnsignedShort(buffer, this._ticket);
        this.writeAMQShortString(buffer, this._destination);
        this.writeBitfield(buffer, this._bitfield0);
        this.writeLong(buffer, this._ttl);
        this.writeUnsignedByte(buffer, this._priority);
        this.writeTimestamp(buffer, this._timestamp);
        this.writeUnsignedByte(buffer, this._deliveryMode);
        this.writeTimestamp(buffer, this._expiration);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._routingKey);
        this.writeAMQShortString(buffer, this._messageId);
        this.writeAMQShortString(buffer, this._correlationId);
        this.writeAMQShortString(buffer, this._replyTo);
        this.writeAMQShortString(buffer, this._contentType);
        this.writeAMQShortString(buffer, this._contentEncoding);
        this.writeAMQShortString(buffer, this._userId);
        this.writeAMQShortString(buffer, this._appId);
        this.writeAMQShortString(buffer, this._transactionId);
        this.writeBytes(buffer, this._securityToken);
        this.writeFieldTable(buffer, this._applicationHeaders);
        this.writeContent(buffer, this._body);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_0_9)dispatcher).dispatchMessageTransfer(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[MessageTransferBodyImpl: ");
        buf.append("ticket=");
        buf.append(this.getTicket());
        buf.append(", ");
        buf.append("destination=");
        buf.append(this.getDestination());
        buf.append(", ");
        buf.append("redelivered=");
        buf.append(this.getRedelivered());
        buf.append(", ");
        buf.append("immediate=");
        buf.append(this.getImmediate());
        buf.append(", ");
        buf.append("ttl=");
        buf.append(this.getTtl());
        buf.append(", ");
        buf.append("priority=");
        buf.append(this.getPriority());
        buf.append(", ");
        buf.append("timestamp=");
        buf.append(this.getTimestamp());
        buf.append(", ");
        buf.append("deliveryMode=");
        buf.append(this.getDeliveryMode());
        buf.append(", ");
        buf.append("expiration=");
        buf.append(this.getExpiration());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("routingKey=");
        buf.append(this.getRoutingKey());
        buf.append(", ");
        buf.append("messageId=");
        buf.append(this.getMessageId());
        buf.append(", ");
        buf.append("correlationId=");
        buf.append(this.getCorrelationId());
        buf.append(", ");
        buf.append("replyTo=");
        buf.append(this.getReplyTo());
        buf.append(", ");
        buf.append("contentType=");
        buf.append(this.getContentType());
        buf.append(", ");
        buf.append("contentEncoding=");
        buf.append(this.getContentEncoding());
        buf.append(", ");
        buf.append("userId=");
        buf.append(this.getUserId());
        buf.append(", ");
        buf.append("appId=");
        buf.append(this.getAppId());
        buf.append(", ");
        buf.append("transactionId=");
        buf.append(this.getTransactionId());
        buf.append(", ");
        buf.append("securityToken=");
        buf.append(this.getSecurityToken() == null ? "null" : Arrays.toString(this.getSecurityToken()));
        buf.append(", ");
        buf.append("applicationHeaders=");
        buf.append(this.getApplicationHeaders());
        buf.append(", ");
        buf.append("body=");
        buf.append(this.getBody());
        buf.append("]");
        return buf.toString();
    }
}

