/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.ConnectionSecureBody;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class ConnectionSecureBodyImpl
extends AMQMethodBody_8_0
implements ConnectionSecureBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new ConnectionSecureBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 10;
    public static final int METHOD_ID = 20;
    private final byte[] _challenge;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public ConnectionSecureBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._challenge = this.readBytes(buffer);
    }

    public ConnectionSecureBodyImpl(byte[] challenge) {
        this._challenge = challenge;
    }

    @Override
    public int getClazz() {
        return 10;
    }

    @Override
    public int getMethod() {
        return 20;
    }

    @Override
    public final byte[] getChallenge() {
        return this._challenge;
    }

    @Override
    protected int getBodySize() {
        int size = 0;
        return size += this.getSizeOf(this._challenge);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeBytes(buffer, this._challenge);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchConnectionSecure(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[ConnectionSecureBodyImpl: ");
        buf.append("challenge=");
        buf.append(this.getChallenge() == null ? "null" : Arrays.toString(this.getChallenge()));
        buf.append("]");
        return buf.toString();
    }
}

