/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.framing.amqp_8_0;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.qpid.AMQException;
import org.apache.qpid.codec.MarkableDataInput;
import org.apache.qpid.framing.AMQFrameDecodingException;
import org.apache.qpid.framing.AMQMethodBody;
import org.apache.qpid.framing.AMQMethodBodyInstanceFactory;
import org.apache.qpid.framing.AMQShortString;
import org.apache.qpid.framing.MethodDispatcher;
import org.apache.qpid.framing.StreamDeliverBody;
import org.apache.qpid.framing.amqp_8_0.AMQMethodBody_8_0;
import org.apache.qpid.framing.amqp_8_0.MethodDispatcher_8_0;

public class StreamDeliverBodyImpl
extends AMQMethodBody_8_0
implements StreamDeliverBody {
    private static final AMQMethodBodyInstanceFactory FACTORY_INSTANCE = new AMQMethodBodyInstanceFactory(){

        @Override
        public AMQMethodBody newInstance(MarkableDataInput in, long size) throws AMQFrameDecodingException, IOException {
            return new StreamDeliverBodyImpl(in);
        }
    };
    public static final int CLASS_ID = 80;
    public static final int METHOD_ID = 60;
    private final AMQShortString _consumerTag;
    private final long _deliveryTag;
    private final AMQShortString _exchange;
    private final AMQShortString _queue;

    public static AMQMethodBodyInstanceFactory getFactory() {
        return FACTORY_INSTANCE;
    }

    public StreamDeliverBodyImpl(MarkableDataInput buffer) throws AMQFrameDecodingException, IOException {
        this._consumerTag = this.readAMQShortString(buffer);
        this._deliveryTag = this.readLong(buffer);
        this._exchange = this.readAMQShortString(buffer);
        this._queue = this.readAMQShortString(buffer);
    }

    public StreamDeliverBodyImpl(AMQShortString consumerTag, long deliveryTag, AMQShortString exchange, AMQShortString queue) {
        this._consumerTag = consumerTag;
        this._deliveryTag = deliveryTag;
        this._exchange = exchange;
        this._queue = queue;
    }

    @Override
    public int getClazz() {
        return 80;
    }

    @Override
    public int getMethod() {
        return 60;
    }

    @Override
    public final AMQShortString getConsumerTag() {
        return this._consumerTag;
    }

    @Override
    public final long getDeliveryTag() {
        return this._deliveryTag;
    }

    @Override
    public final AMQShortString getExchange() {
        return this._exchange;
    }

    @Override
    public final AMQShortString getQueue() {
        return this._queue;
    }

    @Override
    protected int getBodySize() {
        int size = 8;
        size += this.getSizeOf(this._consumerTag);
        size += this.getSizeOf(this._exchange);
        return size += this.getSizeOf(this._queue);
    }

    @Override
    public void writeMethodPayload(DataOutput buffer) throws IOException {
        this.writeAMQShortString(buffer, this._consumerTag);
        this.writeLong(buffer, this._deliveryTag);
        this.writeAMQShortString(buffer, this._exchange);
        this.writeAMQShortString(buffer, this._queue);
    }

    @Override
    public boolean execute(MethodDispatcher dispatcher, int channelId) throws AMQException {
        return ((MethodDispatcher_8_0)dispatcher).dispatchStreamDeliver(this, channelId);
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder("[StreamDeliverBodyImpl: ");
        buf.append("consumerTag=");
        buf.append(this.getConsumerTag());
        buf.append(", ");
        buf.append("deliveryTag=");
        buf.append(this.getDeliveryTag());
        buf.append(", ");
        buf.append("exchange=");
        buf.append(this.getExchange());
        buf.append(", ");
        buf.append("queue=");
        buf.append(this.getQueue());
        buf.append("]");
        return buf.toString();
    }
}

