/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.osgi;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceUnitInfo;
import org.hibernate.ejb.Ejb3Configuration;
import org.hibernate.ejb.HibernatePersistence;
import org.hibernate.integrator.spi.Integrator;
import org.hibernate.metamodel.spi.TypeContributor;
import org.hibernate.osgi.OsgiClassLoader;
import org.hibernate.osgi.OsgiJtaPlatform;
import org.hibernate.osgi.OsgiScanner;
import org.hibernate.osgi.util.OsgiServiceUtil;
import org.hibernate.service.BootstrapServiceRegistryBuilder;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleReference;

public class OsgiPersistenceProvider
extends HibernatePersistence {
    private OsgiClassLoader osgiClassLoader;
    private OsgiJtaPlatform osgiJtaPlatform;
    private Bundle requestingBundle;
    private BundleContext context;

    public OsgiPersistenceProvider(OsgiClassLoader osgiClassLoader, OsgiJtaPlatform osgiJtaPlatform, Bundle requestingBundle, BundleContext context) {
        this.osgiClassLoader = osgiClassLoader;
        this.osgiJtaPlatform = osgiJtaPlatform;
        this.requestingBundle = requestingBundle;
        this.context = context;
    }

    public EntityManagerFactory createEntityManagerFactory(String persistenceUnitName, Map properties) {
        properties = this.generateProperties(properties);
        properties.put("hibernate.ejb.resource_scanner", new OsgiScanner(this.requestingBundle));
        properties.put("hibernate.classLoader.environment", this.osgiClassLoader);
        this.osgiClassLoader.addBundle(this.requestingBundle);
        Ejb3Configuration cfg = new Ejb3Configuration();
        Ejb3Configuration configured = cfg.configure(persistenceUnitName, properties);
        return configured != null ? configured.buildEntityManagerFactory(this.getBuilder(cfg, properties)) : null;
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map properties) {
        properties = this.generateProperties(properties);
        properties.put("hibernate.ejb.resource_scanner", new OsgiScanner(((BundleReference)info.getClassLoader()).getBundle()));
        this.osgiClassLoader.addClassLoader(info.getClassLoader());
        Ejb3Configuration cfg = new Ejb3Configuration();
        Ejb3Configuration configured = cfg.configure(info, properties);
        return configured != null ? configured.buildEntityManagerFactory(this.getBuilder(cfg, properties)) : null;
    }

    private BootstrapServiceRegistryBuilder getBuilder(Ejb3Configuration cfg, Map properties) {
        BootstrapServiceRegistryBuilder builder = new BootstrapServiceRegistryBuilder();
        Collection classLoaders = (Collection)properties.get("hibernate.classLoaders");
        if (classLoaders != null) {
            for (ClassLoader classLoader : classLoaders) {
                this.osgiClassLoader.addClassLoader(classLoader);
            }
        }
        builder.with((ClassLoader)this.osgiClassLoader);
        List<Integrator> integrators = OsgiServiceUtil.getServiceImpls(Integrator.class, this.context);
        for (Integrator integrator : integrators) {
            builder.with(integrator);
        }
        List<TypeContributor> typeContributors = OsgiServiceUtil.getServiceImpls(TypeContributor.class, this.context);
        for (TypeContributor typeContributor : typeContributors) {
            cfg.addTypeContributor(typeContributor);
        }
        return builder;
    }

    private Map generateProperties(Map properties) {
        if (properties == null) {
            properties = new HashMap<String, OsgiJtaPlatform>();
        }
        properties.put("hibernate.transaction.jta.platform", this.osgiJtaPlatform);
        return properties;
    }
}

