/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi.resource;

import aQute.bnd.osgi.resource.CapReqBuilder;
import aQute.bnd.osgi.resource.ResourceImpl;
import java.util.LinkedList;
import java.util.List;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Resource;

public class ResourceBuilder {
    private final ResourceImpl resource = new ResourceImpl();
    private final List<Capability> capabilities = new LinkedList<Capability>();
    private final List<Requirement> requirements = new LinkedList<Requirement>();
    private boolean built = false;

    public ResourceBuilder addCapability(Capability capability) {
        CapReqBuilder builder = CapReqBuilder.clone(capability);
        return this.addCapability(builder);
    }

    public ResourceBuilder addCapability(CapReqBuilder builder) {
        if (this.built) {
            throw new IllegalStateException("Resource already built");
        }
        Capability cap = builder.setResource(this.resource).buildCapability();
        this.capabilities.add(cap);
        return this;
    }

    public ResourceBuilder addRequirement(Requirement requirement) {
        CapReqBuilder builder = CapReqBuilder.clone(requirement);
        return this.addRequirement(builder);
    }

    public ResourceBuilder addRequirement(CapReqBuilder builder) {
        if (this.built) {
            throw new IllegalStateException("Resource already built");
        }
        Requirement req = builder.setResource(this.resource).buildRequirement();
        this.requirements.add(req);
        return this;
    }

    public Resource build() {
        if (this.built) {
            throw new IllegalStateException("Resource already built");
        }
        this.built = true;
        this.resource.setCapabilities(this.capabilities);
        this.resource.setRequirements(this.requirements);
        return this.resource;
    }
}

