/*
 * Decompiled with CFR 0.152.
 */
package aQute.libg.reporter;

import aQute.libg.reporter.Message;
import aQute.service.reporter.Messages;
import aQute.service.reporter.Reporter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.IllegalFormatException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReporterMessages {
    public static <T> T base(final Reporter reporter, Class<T> messages) {
        return (T)Proxy.newProxyInstance(messages.getClassLoader(), new Class[]{messages}, new InvocationHandler(){

            public Object invoke(Object target, Method method, Object[] args) throws Throwable {
                String format;
                Message d = method.getAnnotation(Message.class);
                if (d == null) {
                    String name = method.getName();
                    StringBuilder sb = new StringBuilder();
                    sb.append(name.charAt(0));
                    block5: for (int i = 1; i < name.length(); ++i) {
                        char c = name.charAt(i);
                        switch (c) {
                            case '_': {
                                sb.append(" %s, ");
                                continue block5;
                            }
                            default: {
                                if (Character.isUpperCase(c)) {
                                    sb.append(" ");
                                    c = Character.toLowerCase(c);
                                }
                                sb.append(c);
                            }
                        }
                    }
                    format = sb.toString();
                } else {
                    format = d.value();
                }
                try {
                    if (method.getReturnType() == Messages.ERROR.class) {
                        return new ERRORImpl(reporter.error(format, args));
                    }
                    if (method.getReturnType() == Messages.WARNING.class) {
                        return new WARNINGImpl(reporter.warning(format, args));
                    }
                    reporter.trace(format, args);
                }
                catch (IllegalFormatException e) {
                    reporter.error("Formatter failed: %s %s %s", method.getName(), format, Arrays.toString(args));
                }
                return null;
            }
        });
    }

    static class ERRORImpl
    extends WARNINGImpl
    implements Messages.ERROR {
        public ERRORImpl(Reporter.SetLocation e) {
            super(e);
        }
    }

    static class WARNINGImpl
    implements Messages.WARNING {
        Reporter.SetLocation loc;

        public Reporter.SetLocation file(String file) {
            return this.loc.file(file);
        }

        public Reporter.SetLocation header(String header) {
            return this.loc.header(header);
        }

        public Reporter.SetLocation context(String context) {
            return this.loc.context(context);
        }

        public Reporter.SetLocation method(String methodName) {
            return this.loc.method(methodName);
        }

        public Reporter.SetLocation line(int n) {
            return this.loc.line(n);
        }

        public Reporter.SetLocation reference(String reference) {
            return this.loc.reference(reference);
        }

        public WARNINGImpl(Reporter.SetLocation loc) {
            this.loc = loc;
        }
    }
}

