/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.management.mbean;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.camel.Exchange;
import org.apache.camel.api.management.ManagedResource;
import org.apache.camel.api.management.PerformanceCounter;
import org.apache.camel.api.management.mbean.ManagedPerformanceCounterMBean;
import org.apache.camel.management.mbean.ManagedCounter;
import org.apache.camel.management.mbean.Statistic;
import org.apache.camel.spi.ManagementStrategy;
import org.apache.camel.util.ExchangeHelper;

@ManagedResource(description="Managed PerformanceCounter")
public abstract class ManagedPerformanceCounter
extends ManagedCounter
implements PerformanceCounter,
ManagedPerformanceCounterMBean {
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
    private Statistic exchangesCompleted;
    private Statistic exchangesFailed;
    private Statistic exchangesInflight;
    private Statistic failuresHandled;
    private Statistic redeliveries;
    private Statistic externalRedeliveries;
    private Statistic minProcessingTime;
    private Statistic maxProcessingTime;
    private Statistic totalProcessingTime;
    private Statistic lastProcessingTime;
    private Statistic deltaProcessingTime;
    private Statistic meanProcessingTime;
    private Statistic firstExchangeCompletedTimestamp;
    private String firstExchangeCompletedExchangeId;
    private Statistic firstExchangeFailureTimestamp;
    private String firstExchangeFailureExchangeId;
    private Statistic lastExchangeCompletedTimestamp;
    private String lastExchangeCompletedExchangeId;
    private Statistic lastExchangeFailureTimestamp;
    private String lastExchangeFailureExchangeId;
    private boolean statisticsEnabled = true;

    @Override
    public void init(ManagementStrategy strategy) {
        super.init(strategy);
        this.exchangesCompleted = new Statistic("org.apache.camel.exchangesCompleted", this, Statistic.UpdateMode.COUNTER);
        this.exchangesFailed = new Statistic("org.apache.camel.exchangesFailed", this, Statistic.UpdateMode.COUNTER);
        this.exchangesInflight = new Statistic("org.apache.camel.exchangesInflight", this, Statistic.UpdateMode.COUNTER);
        this.failuresHandled = new Statistic("org.apache.camel.failuresHandled", this, Statistic.UpdateMode.COUNTER);
        this.redeliveries = new Statistic("org.apache.camel.redeliveries", this, Statistic.UpdateMode.COUNTER);
        this.externalRedeliveries = new Statistic("org.apache.camel.externalRedeliveries", this, Statistic.UpdateMode.COUNTER);
        this.minProcessingTime = new Statistic("org.apache.camel.minimumProcessingTime", this, Statistic.UpdateMode.MINIMUM);
        this.maxProcessingTime = new Statistic("org.apache.camel.maximumProcessingTime", this, Statistic.UpdateMode.MAXIMUM);
        this.totalProcessingTime = new Statistic("org.apache.camel.totalProcessingTime", this, Statistic.UpdateMode.COUNTER);
        this.lastProcessingTime = new Statistic("org.apache.camel.lastProcessingTime", this, Statistic.UpdateMode.VALUE);
        this.deltaProcessingTime = new Statistic("org.apache.camel.deltaProcessingTime", this, Statistic.UpdateMode.DELTA);
        this.meanProcessingTime = new Statistic("org.apache.camel.meanProcessingTime", this, Statistic.UpdateMode.VALUE);
        this.firstExchangeCompletedTimestamp = new Statistic("org.apache.camel.firstExchangeCompletedTimestamp", this, Statistic.UpdateMode.VALUE);
        this.firstExchangeFailureTimestamp = new Statistic("org.apache.camel.firstExchangeFailureTimestamp", this, Statistic.UpdateMode.VALUE);
        this.lastExchangeCompletedTimestamp = new Statistic("org.apache.camel.lastExchangeCompletedTimestamp", this, Statistic.UpdateMode.VALUE);
        this.lastExchangeFailureTimestamp = new Statistic("org.apache.camel.lastExchangeFailureTimestamp", this, Statistic.UpdateMode.VALUE);
    }

    @Override
    public synchronized void reset() {
        super.reset();
        this.exchangesCompleted.reset();
        this.exchangesFailed.reset();
        this.exchangesInflight.reset();
        this.failuresHandled.reset();
        this.redeliveries.reset();
        this.externalRedeliveries.reset();
        this.minProcessingTime.reset();
        this.maxProcessingTime.reset();
        this.totalProcessingTime.reset();
        this.lastProcessingTime.reset();
        this.deltaProcessingTime.reset();
        this.meanProcessingTime.reset();
        this.firstExchangeCompletedTimestamp.reset();
        this.firstExchangeCompletedExchangeId = null;
        this.firstExchangeFailureTimestamp.reset();
        this.firstExchangeFailureExchangeId = null;
        this.lastExchangeCompletedTimestamp.reset();
        this.lastExchangeCompletedExchangeId = null;
        this.lastExchangeFailureTimestamp.reset();
        this.lastExchangeFailureExchangeId = null;
    }

    @Override
    public long getExchangesCompleted() throws Exception {
        return this.exchangesCompleted.getValue();
    }

    @Override
    public long getExchangesFailed() throws Exception {
        return this.exchangesFailed.getValue();
    }

    @Override
    public long getExchangesInflight() {
        return this.exchangesInflight.getValue();
    }

    @Override
    public long getFailuresHandled() throws Exception {
        return this.failuresHandled.getValue();
    }

    @Override
    public long getRedeliveries() throws Exception {
        return this.redeliveries.getValue();
    }

    @Override
    public long getExternalRedeliveries() throws Exception {
        return this.externalRedeliveries.getValue();
    }

    @Override
    public long getMinProcessingTime() throws Exception {
        return this.minProcessingTime.getValue();
    }

    @Override
    public long getMeanProcessingTime() throws Exception {
        return this.meanProcessingTime.getValue();
    }

    @Override
    public long getMaxProcessingTime() throws Exception {
        return this.maxProcessingTime.getValue();
    }

    @Override
    public long getTotalProcessingTime() throws Exception {
        return this.totalProcessingTime.getValue();
    }

    @Override
    public long getLastProcessingTime() throws Exception {
        return this.lastProcessingTime.getValue();
    }

    @Override
    public long getDeltaProcessingTime() throws Exception {
        return this.deltaProcessingTime.getValue();
    }

    @Override
    public Date getLastExchangeCompletedTimestamp() {
        long value = this.lastExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @Override
    public String getLastExchangeCompletedExchangeId() {
        return this.lastExchangeCompletedExchangeId;
    }

    @Override
    public Date getFirstExchangeCompletedTimestamp() {
        long value = this.firstExchangeCompletedTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @Override
    public String getFirstExchangeCompletedExchangeId() {
        return this.firstExchangeCompletedExchangeId;
    }

    @Override
    public Date getLastExchangeFailureTimestamp() {
        long value = this.lastExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @Override
    public String getLastExchangeFailureExchangeId() {
        return this.lastExchangeFailureExchangeId;
    }

    @Override
    public Date getFirstExchangeFailureTimestamp() {
        long value = this.firstExchangeFailureTimestamp.getValue();
        return value > 0L ? new Date(value) : null;
    }

    @Override
    public String getFirstExchangeFailureExchangeId() {
        return this.firstExchangeFailureExchangeId;
    }

    @Override
    public boolean isStatisticsEnabled() {
        return this.statisticsEnabled;
    }

    @Override
    public void setStatisticsEnabled(boolean statisticsEnabled) {
        this.statisticsEnabled = statisticsEnabled;
    }

    @Override
    public synchronized void processExchange(Exchange exchange) {
        this.exchangesInflight.increment();
    }

    @Override
    public synchronized void completedExchange(Exchange exchange, long time) {
        Boolean externalRedelivered;
        this.increment();
        this.exchangesCompleted.increment();
        this.exchangesInflight.decrement();
        if (ExchangeHelper.isFailureHandled(exchange)) {
            this.failuresHandled.increment();
        }
        if ((externalRedelivered = exchange.isExternalRedelivered()) != null && externalRedelivered.booleanValue()) {
            this.externalRedeliveries.increment();
        }
        this.minProcessingTime.updateValue(time);
        this.maxProcessingTime.updateValue(time);
        this.totalProcessingTime.updateValue(time);
        this.lastProcessingTime.updateValue(time);
        this.deltaProcessingTime.updateValue(time);
        long now = new Date().getTime();
        if (this.firstExchangeCompletedTimestamp.getUpdateCount() == 0L) {
            this.firstExchangeCompletedTimestamp.updateValue(now);
        }
        this.lastExchangeCompletedTimestamp.updateValue(now);
        if (this.firstExchangeCompletedExchangeId == null) {
            this.firstExchangeCompletedExchangeId = exchange.getExchangeId();
        }
        this.lastExchangeCompletedExchangeId = exchange.getExchangeId();
        long count = this.exchangesCompleted.getValue();
        long mean = count > 0L ? this.totalProcessingTime.getValue() / count : 0L;
        this.meanProcessingTime.updateValue(mean);
    }

    @Override
    public synchronized void failedExchange(Exchange exchange) {
        Boolean externalRedelivered;
        this.increment();
        this.exchangesFailed.increment();
        this.exchangesInflight.decrement();
        if (ExchangeHelper.isRedelivered(exchange)) {
            this.redeliveries.increment();
        }
        if ((externalRedelivered = exchange.isExternalRedelivered()) != null && externalRedelivered.booleanValue()) {
            this.externalRedeliveries.increment();
        }
        long now = new Date().getTime();
        if (this.firstExchangeFailureTimestamp.getUpdateCount() == 0L) {
            this.firstExchangeFailureTimestamp.updateValue(now);
        }
        this.lastExchangeFailureTimestamp.updateValue(now);
        if (this.firstExchangeFailureExchangeId == null) {
            this.firstExchangeFailureExchangeId = exchange.getExchangeId();
        }
        this.lastExchangeFailureExchangeId = exchange.getExchangeId();
    }

    @Override
    public String dumpStatsAsXml(boolean fullStats) {
        StringBuilder sb = new StringBuilder();
        sb.append("<stats ");
        sb.append(String.format("exchangesCompleted=\"%s\"", this.exchangesCompleted.getValue()));
        sb.append(String.format(" exchangesFailed=\"%s\"", this.exchangesFailed.getValue()));
        sb.append(String.format(" failuresHandled=\"%s\"", this.failuresHandled.getValue()));
        sb.append(String.format(" redeliveries=\"%s\"", this.redeliveries.getValue()));
        sb.append(String.format(" externalRedeliveries=\"%s\"", this.externalRedeliveries.getValue()));
        sb.append(String.format(" minProcessingTime=\"%s\"", this.minProcessingTime.getValue()));
        sb.append(String.format(" maxProcessingTime=\"%s\"", this.maxProcessingTime.getValue()));
        sb.append(String.format(" totalProcessingTime=\"%s\"", this.totalProcessingTime.getValue()));
        sb.append(String.format(" lastProcessingTime=\"%s\"", this.lastProcessingTime.getValue()));
        sb.append(String.format(" deltaProcessingTime=\"%s\"", this.deltaProcessingTime.getValue()));
        sb.append(String.format(" meanProcessingTime=\"%s\"", this.meanProcessingTime.getValue()));
        if (fullStats) {
            sb.append(String.format(" resetTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.resetTimestamp.getValue())));
            sb.append(String.format(" firstExchangeCompletedTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.firstExchangeCompletedTimestamp.getValue())));
            sb.append(String.format(" firstExchangeCompletedExchangeId=\"%s\"", ManagedPerformanceCounter.nullSafe(this.firstExchangeCompletedExchangeId)));
            sb.append(String.format(" firstExchangeFailureTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.firstExchangeFailureTimestamp.getValue())));
            sb.append(String.format(" firstExchangeFailureExchangeId=\"%s\"", ManagedPerformanceCounter.nullSafe(this.firstExchangeFailureExchangeId)));
            sb.append(String.format(" lastExchangeCompletedTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.lastExchangeCompletedTimestamp.getValue())));
            sb.append(String.format(" lastExchangeCompletedExchangeId=\"%s\"", ManagedPerformanceCounter.nullSafe(this.lastExchangeCompletedExchangeId)));
            sb.append(String.format(" lastExchangeFailureTimestamp=\"%s\"", ManagedPerformanceCounter.dateAsString(this.lastExchangeFailureTimestamp.getValue())));
            sb.append(String.format(" lastExchangeFailureExchangeId=\"%s\"", ManagedPerformanceCounter.nullSafe(this.lastExchangeFailureExchangeId)));
        }
        sb.append("/>");
        return sb.toString();
    }

    private static String dateAsString(long value) {
        if (value == 0L) {
            return "";
        }
        return new SimpleDateFormat(TIMESTAMP_FORMAT).format(value);
    }

    private static String nullSafe(String s) {
        return s != null ? s : "";
    }
}

