/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.cdi.internal;

import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.camel.CamelContext;
import org.apache.camel.Endpoint;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.cdi.ContextName;
import org.apache.camel.cdi.Mock;
import org.apache.camel.cdi.Uri;
import org.apache.camel.cdi.internal.CamelContextMap;
import org.apache.camel.cdi.internal.CamelExtension;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.util.CamelContextHelper;
import org.apache.camel.util.ObjectHelper;

public class CamelFactory {
    @Inject
    CamelContextMap camelContextMap;

    @Produces
    @Mock
    public MockEndpoint createMockEndpoint(InjectionPoint point) {
        Mock annotation = (Mock)point.getAnnotated().getAnnotation(Mock.class);
        ObjectHelper.notNull((Object)annotation, (String)"Should be annotated with @Mock");
        String uri = annotation.value();
        if (ObjectHelper.isEmpty((Object)uri)) {
            uri = "mock:" + point.getMember().getName();
        }
        return (MockEndpoint)CamelContextHelper.getMandatoryEndpoint((CamelContext)this.getCamelContext(point, annotation.context()), (String)uri, MockEndpoint.class);
    }

    @Produces
    @Uri(value="")
    public Endpoint createEndpoint(InjectionPoint point) {
        Annotated annotated = point.getAnnotated();
        Uri uri = (Uri)annotated.getAnnotation(Uri.class);
        ObjectHelper.notNull((Object)uri, (String)"Should be annotated with @Uri");
        return CamelContextHelper.getMandatoryEndpoint((CamelContext)this.getCamelContext(point, uri.context()), (String)uri.value());
    }

    @Produces
    @Uri(value="")
    public ProducerTemplate createProducerTemplate(InjectionPoint point) {
        Annotated annotated = point.getAnnotated();
        Uri uri = (Uri)annotated.getAnnotation(Uri.class);
        CamelContext camelContext = this.getCamelContext(point, uri.context());
        ProducerTemplate producerTemplate = camelContext.createProducerTemplate();
        ObjectHelper.notNull((Object)uri, (String)"Should be annotated with @Uri");
        Endpoint endpoint = CamelContextHelper.getMandatoryEndpoint((CamelContext)camelContext, (String)uri.value());
        producerTemplate.setDefaultEndpoint(endpoint);
        return producerTemplate;
    }

    protected CamelContext getCamelContext(InjectionPoint point, String contextName) {
        Bean bean;
        ContextName startup = (ContextName)point.getAnnotated().getAnnotation(ContextName.class);
        if (startup == null && (bean = point.getBean()) != null) {
            startup = bean.getBeanClass().getAnnotation(ContextName.class);
        }
        String name = CamelExtension.getCamelContextName(contextName, startup);
        return this.camelContextMap.getMandatoryCamelContext(name);
    }
}

