/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.camel.component.sap;

import org.apache.camel.Component;
import org.apache.camel.Producer;
import org.apache.camel.spi.UriEndpoint;
import org.fusesource.camel.component.sap.SapIDocDestinationEndpoint;
import org.fusesource.camel.component.sap.SapTransactionalIDocDestinationComponent;
import org.fusesource.camel.component.sap.SapTransactionalIDocProducer;
import org.fusesource.camel.component.sap.model.idoc.Document;
import org.fusesource.camel.component.sap.util.IDocUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(scheme="sap-idoc-destination", syntax="sap-idoc-destination:destination:idocType:idocTypeExtension:systemRelease:applicationRelease", producerOnly=true, title="SAP IDoc Destination")
public class SapTransactionalIDocDestinationEndpoint
extends SapIDocDestinationEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(SapTransactionalIDocDestinationEndpoint.class);

    public SapTransactionalIDocDestinationEndpoint() {
    }

    public SapTransactionalIDocDestinationEndpoint(String endpointUri, SapTransactionalIDocDestinationComponent component) {
        super(endpointUri, (Component)component);
    }

    public Document createDocument() throws Exception {
        try {
            return IDocUtil.createDocument(this.getIDocRepository(), this.getIdocType(), this.getIdocTypeExtension(), this.getSystemRelease(), this.getApplicationRelease());
        }
        catch (Exception e) {
            throw new Exception("Failed to get Document from endpoint", e);
        }
    }

    public Producer createProducer() throws Exception {
        LOG.debug("Created producer for endpoint '" + this.getEndpointUri() + "'");
        return new SapTransactionalIDocProducer(this);
    }
}

