/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.osgi.config;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

class OsgiDefaultsDefinition {
    private static final String OSGI_NS = "http://www.springframework.org/schema/osgi";
    private static final String DEFAULT_TIMEOUT = "default-timeout";
    private static final String DEFAULT_CARDINALITY = "default-cardinality";
    private static final String TIMEOUT_DEFAULT = "300000";
    private static final String CARDINALITY_DEFAULT = "1..X";
    private String timeout = "300000";
    private String cardinality = "1..X";

    OsgiDefaultsDefinition() {
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }

    public String getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(String cardinality) {
        this.cardinality = cardinality;
    }

    public static OsgiDefaultsDefinition initOsgiDefaults(Document document) {
        Assert.notNull((Object)document);
        return OsgiDefaultsDefinition.initOsgiDefaults(document.getDocumentElement());
    }

    public static OsgiDefaultsDefinition initOsgiDefaults(Element root) {
        String cardinality;
        Assert.notNull((Object)root);
        OsgiDefaultsDefinition defaults = new OsgiDefaultsDefinition();
        String timeout = root.getAttributeNS(OSGI_NS, DEFAULT_TIMEOUT);
        if (StringUtils.hasText((String)timeout)) {
            defaults.setTimeout(timeout);
        }
        if (StringUtils.hasText((String)(cardinality = root.getAttributeNS(OSGI_NS, DEFAULT_CARDINALITY)))) {
            defaults.setCardinality(cardinality);
        }
        return defaults;
    }
}

