/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.netty4.codec;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultAddressedEnvelope;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.net.InetSocketAddress;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.List;

@ChannelHandler.Sharable
public class DatagramPacketStringEncoder
extends MessageToMessageEncoder<AddressedEnvelope<Object, InetSocketAddress>> {
    private final Charset charset;

    public DatagramPacketStringEncoder() {
        this(Charset.defaultCharset());
    }

    public DatagramPacketStringEncoder(Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        this.charset = charset;
    }

    protected void encode(ChannelHandlerContext ctx, AddressedEnvelope<Object, InetSocketAddress> msg, List<Object> out) throws Exception {
        if (msg.content() instanceof CharSequence) {
            CharSequence payload = (CharSequence)msg.content();
            if (payload.length() == 0) {
                return;
            }
            DefaultAddressedEnvelope addressedEnvelop = new DefaultAddressedEnvelope((Object)ByteBufUtil.encodeString((ByteBufAllocator)ctx.alloc(), (CharBuffer)CharBuffer.wrap(payload), (Charset)this.charset), msg.recipient(), msg.sender());
            out.add(addressedEnvelop);
        }
    }
}

