/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.dozer.internal;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.xml.namespace.QName;
import org.dozer.DozerBeanMapper;
import org.dozer.config.BeanContainer;
import org.dozer.util.DefaultClassLoader;
import org.dozer.util.DozerClassLoader;
import org.jboss.logging.Logger;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.config.model.Scannable;
import org.switchyard.transform.BaseTransformer;

@Scannable(value=false)
public class DozerTransformer
extends BaseTransformer {
    private Logger _logger = Logger.getLogger(DozerTransformer.class);
    private DozerBeanMapper _dozerBeanMapper;
    DozerClassLoader tccl = new DefaultClassLoader(Thread.currentThread().getContextClassLoader());

    protected DozerTransformer(QName from, QName to, List<String> configs) {
        super(from, to);
        BeanContainer.getInstance().setClassLoader(this.tccl);
        this._dozerBeanMapper = new DozerBeanMapper();
        if (configs != null && !configs.isEmpty()) {
            for (String fileName : configs) {
                URL url = null;
                try {
                    url = this.tccl.loadResource(fileName);
                    this._dozerBeanMapper.addMapping(url.openStream());
                }
                catch (MalformedURLException e) {
                    this._logger.error((Object)e);
                }
                catch (IOException e) {
                    this._logger.error((Object)e);
                }
            }
        }
    }

    public Object transform(Object message) {
        return this._dozerBeanMapper.map(message, QNameUtil.toJavaMessageType((QName)this.getTo()));
    }
}

