/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.jaxb.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.xml.bind.annotation.XmlElementDecl;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.switchyard.ServiceDomain;
import org.switchyard.SwitchYardException;
import org.switchyard.common.type.Classes;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.metadata.JavaTypes;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.JAXBTransformModel;
import org.switchyard.transform.config.model.JavaTransformType;
import org.switchyard.transform.internal.TransformMessages;
import org.switchyard.transform.internal.TransformerFactory;
import org.switchyard.transform.jaxb.internal.JAXBMarshalTransformer;
import org.switchyard.transform.jaxb.internal.JAXBUnmarshalTransformer;

public class JAXBTransformerFactory
implements TransformerFactory<JAXBTransformModel> {
    private static Logger _log = Logger.getLogger(JAXBTransformerFactory.class);

    @Override
    public Transformer<?, ?> newTransformer(ServiceDomain domain, JAXBTransformModel model) {
        QName toType;
        QName fromType = model.getFrom();
        if (JAXBTransformerFactory.toJavaTransformType(fromType, toType = model.getTo()) == JavaTransformType.JAVA2XML) {
            return new JAXBMarshalTransformer(fromType, toType, model.getContextPath());
        }
        return new JAXBUnmarshalTransformer(fromType, toType, model.getContextPath());
    }

    public static List<Transformer<?, ?>> newTransformers(Class<?> serviceClass) throws SwitchYardException {
        ArrayList transformers = new ArrayList();
        HashSet inputTypeSet = new HashSet();
        HashSet outputTypeSet = new HashSet();
        if (serviceClass.isInterface()) {
            Method[] serviceOperations;
            for (Method serviceOperation : serviceOperations = serviceClass.getMethods()) {
                Class<?>[] inTypes = serviceOperation.getParameterTypes();
                Class<?> outType = serviceOperation.getReturnType();
                if (inTypes.length == 1) {
                    inputTypeSet.add(inTypes[0]);
                }
                if (outType == null || Void.TYPE.isAssignableFrom(outType)) continue;
                outputTypeSet.add(outType);
            }
        }
        for (Class clazz : inputTypeSet) {
            JAXBTransformerFactory.addJAXBUnmarshalTransformer(clazz, transformers);
        }
        for (Class clazz : outputTypeSet) {
            JAXBTransformerFactory.addJAXBMarshalTransformer(clazz, transformers);
        }
        return transformers;
    }

    private static void addJAXBUnmarshalTransformer(Class<?> inType, List<Transformer<?, ?>> transformers) throws SwitchYardException {
        Class objectFactory = JAXBTransformerFactory.getObjectFactory(inType);
        if (objectFactory != null) {
            QName fromType = JAXBTransformerFactory.getTypeXMLQName(inType, objectFactory);
            if (fromType != null) {
                QName toType = JavaTypes.toMessageType(inType);
                transformers.add((Transformer<?, ?>)new JAXBUnmarshalTransformer(fromType, toType, inType.getPackage().getName()));
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)JAXBTransformerFactory.createMissingFactoryMethodMessage(inType, objectFactory));
            }
        }
    }

    private static void addJAXBMarshalTransformer(Class<?> outType, List<Transformer<?, ?>> transformers) throws SwitchYardException {
        Class objectFactory = JAXBTransformerFactory.getObjectFactory(outType);
        if (objectFactory != null) {
            QName toType = JAXBTransformerFactory.getTypeXMLQName(outType, objectFactory);
            if (toType != null) {
                QName fromType = JavaTypes.toMessageType(outType);
                transformers.add((Transformer<?, ?>)new JAXBMarshalTransformer(fromType, toType, outType.getPackage().getName()));
            } else if (_log.isDebugEnabled()) {
                _log.debug((Object)JAXBTransformerFactory.createMissingFactoryMethodMessage(outType, objectFactory));
            }
        }
    }

    private static QName getTypeXMLQName(Class<?> type, Class<?> objectFactory) throws SwitchYardException {
        Method[] factoryMethods;
        for (Method factoryMethod : factoryMethods = objectFactory.getDeclaredMethods()) {
            Class<?>[] factoryParams;
            XmlElementDecl xmlElementDecl = factoryMethod.getAnnotation(XmlElementDecl.class);
            if (xmlElementDecl == null || (factoryParams = factoryMethod.getParameterTypes()).length != 1) continue;
            QName qName = new QName(xmlElementDecl.namespace(), xmlElementDecl.name());
            Class<?> factoryParam = factoryParams[0];
            if (factoryParam != type) continue;
            return qName;
        }
        return null;
    }

    private static Class getObjectFactory(Class<?> type) {
        if (type.getAnnotation(XmlType.class) != null) {
            String objectFactoryName = type.getPackage().getName() + "." + "ObjectFactory";
            return Classes.forName((String)objectFactoryName, JAXBTransformerFactory.class);
        }
        return null;
    }

    protected static String createMissingFactoryMethodMessage(Class<?> type, Class<?> objectFactory) {
        StringBuilder messageBuilder = new StringBuilder();
        Method[] factoryMethods = objectFactory.getDeclaredMethods();
        messageBuilder.append(TransformMessages.MESSAGES.noJAXBElementFactoryDefined(type.getName(), objectFactory.getName()));
        for (Method factoryMethod : factoryMethods) {
            Class<?>[] factoryParams;
            XmlElementDecl xmlElementDecl = factoryMethod.getAnnotation(XmlElementDecl.class);
            if (xmlElementDecl == null || (factoryParams = factoryMethod.getParameterTypes()).length != 1) continue;
            QName qName = new QName(xmlElementDecl.namespace(), xmlElementDecl.name());
            Class<?> factoryParam = factoryParams[0];
            messageBuilder.append("\n\t\t- Message QName: '" + qName.toString() + "'. Java Type: " + factoryParam.getName());
        }
        return messageBuilder.toString();
    }

    private static JavaTransformType toJavaTransformType(QName fromType, QName toType) {
        if (QNameUtil.isJavaMessageType((QName)fromType)) {
            if (QNameUtil.isJavaMessageType((QName)toType)) {
                throw TransformMessages.MESSAGES.bothJavaTypes();
            }
            return JavaTransformType.JAVA2XML;
        }
        if (QNameUtil.isJavaMessageType((QName)toType)) {
            if (QNameUtil.isJavaMessageType((QName)fromType)) {
                throw TransformMessages.MESSAGES.bothJavaTypes();
            }
            return JavaTransformType.XML2JAVA;
        }
        throw TransformMessages.MESSAGES.neitherJavaType();
    }

    private static String getJavaPackage(QName type) {
        return QNameUtil.toJavaMessageType((QName)type).getPackage().getName();
    }
}

