/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Info {
    private static final String SNAPSHOT = "SNAPSHOT";
    private static final String PAX_WEB_VERSION;
    private static boolean paxWebSnapshotVersion;
    private static final String PAX_CDI_VERSION;
    private static boolean paxCdiSnapshotVersion;

    private Info() {
    }

    public static String getPaxCdiVersion() {
        return PAX_CDI_VERSION;
    }

    public static boolean isPaxCdiSnapshotVersion() {
        return paxCdiSnapshotVersion;
    }

    public static String getPaxWebVersion() {
        return PAX_WEB_VERSION;
    }

    public static boolean isPaxWebSnapshotVersion() {
        return paxWebSnapshotVersion;
    }

    static {
        String paxCdiVersion = "";
        String paxWebVersion = "";
        try {
            InputStream is = Info.class.getResourceAsStream("/META-INF/pax-cdi-version.properties");
            if (is != null) {
                Properties properties = new Properties();
                properties.load(is);
                paxCdiVersion = properties.getProperty("pax.cdi.version");
                if (paxCdiVersion == null) {
                    throw new IllegalStateException("pax.cdi.version missing in META-INF/pax-cdi-version.properties");
                }
                paxWebVersion = properties.getProperty("pax.web.version");
                if (paxWebVersion == null) {
                    throw new IllegalStateException("pax.web.version missing in META-INF/pax-web-version.properties");
                }
            }
        }
        catch (IOException ignore) {
            throw new IllegalStateException("cannot read META-INF/pax-cdi-version.properties");
        }
        PAX_CDI_VERSION = paxCdiVersion;
        paxCdiSnapshotVersion = paxCdiVersion.endsWith(SNAPSHOT);
        PAX_WEB_VERSION = paxWebVersion;
        paxWebSnapshotVersion = paxWebVersion.endsWith(SNAPSHOT);
    }
}

