/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl;

import java.lang.annotation.Annotation;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.ops4j.pax.cdi.extension.impl.ServiceAddedLiteral;
import org.ops4j.pax.cdi.extension.impl.ServiceRemovedLiteral;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;

public class ServiceEventBridge
implements ServiceListener {
    @Inject
    private BundleContext bundleContext;
    @Inject
    private Event<Object> event;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceChanged(ServiceEvent serviceEvent) {
        Annotation qualifier = this.toQualifier(serviceEvent);
        if (qualifier == null) {
            return;
        }
        ServiceReference serviceReference = serviceEvent.getServiceReference();
        Object service = this.bundleContext.getService(serviceReference);
        try {
            Event specificEvent = this.event.select(service.getClass(), new Annotation[]{qualifier});
            specificEvent.fire(service);
        }
        finally {
            this.bundleContext.ungetService(serviceReference);
        }
    }

    private Annotation toQualifier(ServiceEvent serviceEvent) {
        switch (serviceEvent.getType()) {
            case 1: {
                return new ServiceAddedLiteral();
            }
            case 4: {
                return new ServiceRemovedLiteral();
            }
        }
        return null;
    }

    public void start() {
        this.bundleContext.addServiceListener((ServiceListener)this);
    }

    public void stop() {
        this.bundleContext.removeServiceListener((ServiceListener)this);
    }
}

