/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.PreparedStylesheet;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.SequenceOutputter;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.Sink;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.event.Transmitter;
import net.sf.saxon.expr.ErrorExpression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMajor;
import net.sf.saxon.expr.instruct.Bindery;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.GlobalParameterSet;
import net.sf.saxon.expr.instruct.GlobalVariable;
import net.sf.saxon.expr.instruct.ParameterSet;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.expr.instruct.Template;
import net.sf.saxon.expr.instruct.TerminationException;
import net.sf.saxon.expr.parser.PathMap;
import net.sf.saxon.functions.EscapeURI;
import net.sf.saxon.lib.AugmentedSource;
import net.sf.saxon.lib.CollectionURIResolver;
import net.sf.saxon.lib.OutputURIResolver;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.lib.SaxonOutputKeys;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.SerializerFactory;
import net.sf.saxon.lib.StandardErrorListener;
import net.sf.saxon.lib.StandardURIResolver;
import net.sf.saxon.lib.StandardUnparsedTextResolver;
import net.sf.saxon.lib.TraceListener;
import net.sf.saxon.lib.UnparsedTextURIResolver;
import net.sf.saxon.om.AllElementsSpaceStrippingRule;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.DocumentPool;
import net.sf.saxon.om.DocumentURI;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.om.SpaceStrippingRule;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.om.TreeModel;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.serialize.Emitter;
import net.sf.saxon.serialize.ImplicitResultChecker;
import net.sf.saxon.trace.TraceEventMulticaster;
import net.sf.saxon.trans.KeyManager;
import net.sf.saxon.trans.Mode;
import net.sf.saxon.trans.RuleManager;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.tree.iter.UnfailingIterator;
import net.sf.saxon.tree.wrapper.AbstractVirtualNode;
import net.sf.saxon.tree.wrapper.SpaceStrippedDocument;
import net.sf.saxon.tree.wrapper.TypeStrippedDocument;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.value.DateTimeValue;
import net.sf.saxon.value.SingletonClosure;
import org.xml.sax.SAXParseException;

public class Controller
extends Transformer {
    private Configuration config;
    private Item initialContextItem;
    private Item contextForGlobalVariables;
    private Bindery bindery;
    private NamePool namePool;
    private String messageReceiverClassName;
    private Receiver messageReceiver;
    private RuleManager ruleManager;
    private Properties localOutputProperties;
    private GlobalParameterSet parameters;
    private PreparedStylesheet preparedStylesheet;
    private TraceListener traceListener;
    private boolean tracingPaused;
    private PrintStream traceFunctionDestination;
    private URIResolver standardURIResolver;
    private URIResolver userURIResolver;
    private Result principalResult;
    private String principalResultURI;
    private String cookedPrincipalResultURI;
    private boolean thereHasBeenAnExplicitResultDocument;
    private OutputURIResolver outputURIResolver;
    private UnparsedTextURIResolver unparsedTextResolver;
    private SchemaURIResolver schemaURIResolver;
    private CollectionURIResolver collectionURIResolver;
    private String defaultCollectionURI;
    private ErrorListener errorListener;
    private int recoveryPolicy;
    private Executable executable;
    private TreeModel treeModel = TreeModel.TINY_TREE;
    private Template initialTemplate = null;
    private HashSet<DocumentURI> allOutputDestinations;
    private DocumentPool sourceDocumentPool;
    private SequenceOutputter reusableSequenceOutputter = null;
    private HashMap<String, Object> userDataTable;
    private DateTimeValue currentDateTime;
    private boolean dateTimePreset = false;
    private StructuredQName initialMode = null;
    private NodeInfo lastRememberedNode = null;
    private int lastRememberedNumber = -1;
    private ClassLoader classLoader;
    private PathMap pathMap = null;
    private int validationMode;
    private boolean inUse = false;
    private boolean stripSourceTrees = true;
    public static final String ANONYMOUS_PRINCIPAL_OUTPUT_URI = "dummy:/anonymous/principal/result";

    public Controller(Configuration config) {
        this.config = config;
        this.executable = new Executable(config);
        this.executable.setHostLanguage(config.getHostLanguage(), false);
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public Controller(Configuration config, Executable executable) {
        this.config = config;
        this.executable = executable;
        this.sourceDocumentPool = new DocumentPool();
        this.reset();
    }

    public void reset() {
        TraceListener tracer;
        this.bindery = new Bindery();
        this.namePool = this.config.getNamePool();
        this.standardURIResolver = this.config.getSystemURIResolver();
        this.userURIResolver = this.config.getURIResolver();
        this.outputURIResolver = this.config.getOutputURIResolver();
        this.schemaURIResolver = this.config.getSchemaURIResolver();
        this.unparsedTextResolver = new StandardUnparsedTextResolver();
        this.errorListener = this.config.getErrorListener();
        this.recoveryPolicy = this.config.getRecoveryPolicy();
        this.validationMode = this.config.getSchemaValidationMode();
        if (this.errorListener instanceof StandardErrorListener) {
            PrintStream ps = ((StandardErrorListener)this.errorListener).getErrorOutput();
            this.errorListener = ((StandardErrorListener)this.errorListener).makeAnother(this.executable.getHostLanguage());
            ((StandardErrorListener)this.errorListener).setErrorOutput(ps);
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(this.recoveryPolicy);
        }
        this.traceListener = null;
        this.traceFunctionDestination = this.config.getStandardErrorOutput();
        try {
            tracer = this.config.makeTraceListener();
        }
        catch (XPathException err) {
            throw new IllegalStateException(err.getMessage());
        }
        if (tracer != null) {
            this.addTraceListener(tracer);
        }
        this.setModel(this.config.getParseOptions().getModel());
        this.contextForGlobalVariables = null;
        this.messageReceiver = null;
        this.localOutputProperties = null;
        this.parameters = null;
        this.currentDateTime = null;
        this.dateTimePreset = false;
        this.initialContextItem = null;
        this.initialMode = null;
        this.initialTemplate = null;
        this.classLoader = null;
        this.clearPerTransformationData();
    }

    private void clearPerTransformationData() {
        this.userDataTable = new HashMap(20);
        this.principalResult = null;
        this.allOutputDestinations = null;
        this.thereHasBeenAnExplicitResultDocument = false;
        this.lastRememberedNode = null;
        this.lastRememberedNumber = -1;
        this.tracingPaused = false;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setInitialMode(String expandedModeName) {
        this.initialMode = expandedModeName == null || expandedModeName.length() == 0 ? null : StructuredQName.fromClarkName(expandedModeName);
    }

    public String getInitialModeName() {
        return this.initialMode.getClarkName();
    }

    public Mode getInitialMode() {
        return this.preparedStylesheet.getRuleManager().getMode(this.initialMode, false);
    }

    public void setOutputProperties(Properties properties) {
        if (properties == null) {
            this.localOutputProperties = null;
        } else {
            Enumeration<?> keys = properties.propertyNames();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                this.setOutputProperty(key, properties.getProperty(key));
            }
        }
    }

    public Properties getOutputProperties() {
        if (this.localOutputProperties == null) {
            if (this.executable == null) {
                return new Properties();
            }
            this.localOutputProperties = new Properties(this.executable.getDefaultOutputProperties());
        }
        Properties newProps = new Properties();
        Enumeration<?> keys = this.localOutputProperties.propertyNames();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            newProps.setProperty(key, this.localOutputProperties.getProperty(key));
        }
        return newProps;
    }

    public void setOutputProperty(String name, String value) {
        if (this.localOutputProperties == null) {
            this.localOutputProperties = this.getOutputProperties();
        }
        try {
            SaxonOutputKeys.checkOutputProperty(name, value, this.getConfiguration());
        }
        catch (XPathException err) {
            throw new IllegalArgumentException(err.getMessage());
        }
        this.localOutputProperties.setProperty(name, value);
    }

    public String getOutputProperty(String name) {
        try {
            SaxonOutputKeys.checkOutputProperty(name, null, this.getConfiguration());
        }
        catch (XPathException err) {
            throw new IllegalArgumentException(err.getMessage());
        }
        if (this.localOutputProperties == null) {
            if (this.executable == null) {
                return null;
            }
            this.localOutputProperties = this.executable.getDefaultOutputProperties();
        }
        return this.localOutputProperties.getProperty(name);
    }

    public void setBaseOutputURI(String uri) {
        this.principalResultURI = uri;
    }

    public String getBaseOutputURI() {
        return this.principalResultURI;
    }

    public String getCookedBaseOutputURI() {
        if (this.cookedPrincipalResultURI == null) {
            String base = this.getBaseOutputURI();
            if (base == null && this.config.getBooleanProperty("http://saxon.sf.net/feature/allow-external-functions")) {
                base = new File(System.getProperty("user.dir")).toURI().toString();
            }
            if (base != null) {
                base = EscapeURI.iriToUri(base).toString();
            }
            this.cookedPrincipalResultURI = base;
        }
        return this.cookedPrincipalResultURI;
    }

    public Result getPrincipalResult() {
        return this.principalResult;
    }

    public synchronized boolean checkUniqueOutputDestination(DocumentURI uri) {
        if (uri == null) {
            return true;
        }
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        return !this.allOutputDestinations.contains(uri);
    }

    public void addUnavailableOutputDestination(DocumentURI uri) {
        if (this.allOutputDestinations == null) {
            this.allOutputDestinations = new HashSet(20);
        }
        this.allOutputDestinations.add(uri);
    }

    public void removeUnavailableOutputDestination(DocumentURI uri) {
        if (this.allOutputDestinations != null) {
            this.allOutputDestinations.remove(uri);
        }
    }

    public boolean isUnusedOutputDestination(DocumentURI uri) {
        return this.allOutputDestinations == null || !this.allOutputDestinations.contains(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkImplicitResultTree() throws XPathException {
        String implicitURI = this.principalResultURI;
        if (implicitURI == null) {
            implicitURI = ANONYMOUS_PRINCIPAL_OUTPUT_URI;
        }
        DocumentURI documentURI = new DocumentURI(implicitURI);
        Controller controller = this;
        synchronized (controller) {
            if (!this.checkUniqueOutputDestination(documentURI)) {
                XPathException err = new XPathException("Cannot write an implicit result document if an explicit result document has been written to the same URI: " + (implicitURI.equals(ANONYMOUS_PRINCIPAL_OUTPUT_URI) ? "(no URI supplied)" : implicitURI));
                err.setErrorCode("XTDE1490");
                throw err;
            }
            this.addUnavailableOutputDestination(documentURI);
        }
    }

    public void setThereHasBeenAnExplicitResultDocument() {
        this.thereHasBeenAnExplicitResultDocument = true;
    }

    public boolean hasThereBeenAnExplicitResultDocument() {
        return this.thereHasBeenAnExplicitResultDocument;
    }

    public synchronized SequenceOutputter allocateSequenceOutputter(int size) {
        PipelineConfiguration pipe = this.makePipelineConfiguration();
        SequenceOutputter so = this.reusableSequenceOutputter;
        if (so != null) {
            so.setPipelineConfiguration(pipe);
            so.setSystemId(null);
            this.reusableSequenceOutputter = null;
            return so;
        }
        return new SequenceOutputter(pipe, this, size);
    }

    public void reuseSequenceOutputter(SequenceOutputter out) {
        this.reusableSequenceOutputter = out;
    }

    public void setInitialTemplate(String expandedName) throws XPathException {
        if (expandedName == null || expandedName.length() == 0) {
            this.initialTemplate = null;
            return;
        }
        StructuredQName qName = StructuredQName.fromClarkName(expandedName);
        Template t = ((PreparedStylesheet)this.getExecutable()).getNamedTemplate(qName);
        if (t == null) {
            XPathException err = new XPathException("The requested initial template, with expanded name " + expandedName + ", does not exist");
            err.setErrorCode("XTDE0040");
            this.reportFatalError(err);
            throw err;
        }
        if (t.hasRequiredParams()) {
            XPathException err = new XPathException("The named template " + expandedName + " has required parameters, so cannot be used as the entry point");
            err.setErrorCode("XTDE0060");
            this.reportFatalError(err);
            throw err;
        }
        this.initialTemplate = t;
    }

    public String getInitialTemplate() {
        if (this.initialTemplate == null) {
            return null;
        }
        return this.initialTemplate.getTemplateName().getClarkName();
    }

    public PipelineConfiguration makePipelineConfiguration() {
        PipelineConfiguration pipe = new PipelineConfiguration(this.getConfiguration());
        pipe.setURIResolver(this.userURIResolver == null ? this.standardURIResolver : this.userURIResolver);
        pipe.setSchemaURIResolver(this.schemaURIResolver);
        pipe.setExpandAttributeDefaults(this.getConfiguration().isExpandAttributeDefaults());
        pipe.setParseOptions(new ParseOptions(this.config.getParseOptions()));
        pipe.setErrorListener(this.getErrorListener());
        pipe.setController(this);
        Executable executable = this.getExecutable();
        if (executable != null) {
            pipe.setLocationProvider(executable.getLocationMap());
            pipe.setHostLanguage(executable.getHostLanguage());
        }
        return pipe;
    }

    private Receiver makeMessageReceiver() throws XPathException {
        Object messageReceiver = this.config.getInstance(this.messageReceiverClassName, this.getClassLoader());
        if (!(messageReceiver instanceof Receiver)) {
            throw new XPathException(this.messageReceiverClassName + " is not a Receiver");
        }
        ((Receiver)messageReceiver).setPipelineConfiguration(this.makePipelineConfiguration());
        this.setMessageEmitter((Receiver)messageReceiver);
        return (Receiver)messageReceiver;
    }

    public void setMessageEmitter(Receiver receiver) {
        this.messageReceiver = receiver;
        receiver.setPipelineConfiguration(this.makePipelineConfiguration());
        if (receiver instanceof Emitter && ((Emitter)receiver).getOutputProperties() == null) {
            try {
                Properties props = new Properties();
                props.setProperty("method", "xml");
                props.setProperty("indent", "yes");
                props.setProperty("omit-xml-declaration", "yes");
                ((Emitter)receiver).setOutputProperties(props);
            }
            catch (XPathException xPathException) {
                // empty catch block
            }
        }
    }

    public Receiver getMessageEmitter() {
        return this.messageReceiver;
    }

    public void setRecoveryPolicy(int policy) {
        this.recoveryPolicy = policy;
        if (this.errorListener instanceof StandardErrorListener) {
            ((StandardErrorListener)this.errorListener).setRecoveryPolicy(policy);
        }
    }

    public int getRecoveryPolicy() {
        return this.recoveryPolicy;
    }

    public void setErrorListener(ErrorListener listener) {
        this.errorListener = listener;
    }

    public ErrorListener getErrorListener() {
        return this.errorListener;
    }

    public void recoverableError(XPathException err) throws XPathException {
        if (this.executable.getHostLanguage() == 51 || this.recoveryPolicy == 2) {
            throw err;
        }
        try {
            this.errorListener.error(err);
        }
        catch (TransformerException e) {
            XPathException de = XPathException.makeXPathException(e);
            de.setHasBeenReported(true);
            throw de;
        }
    }

    public void reportFatalError(XPathException err) {
        if (!err.hasBeenReported()) {
            try {
                this.getErrorListener().fatalError(err);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            err.setHasBeenReported(true);
        }
    }

    public void warning(String message, String errorCode) {
        try {
            this.getErrorListener().warning(new XPathException(message, errorCode));
        }
        catch (TransformerException transformerException) {
            // empty catch block
        }
    }

    public Executable getExecutable() {
        return this.executable;
    }

    public DocumentPool getDocumentPool() {
        return this.sourceDocumentPool;
    }

    public void clearDocumentPool() {
        this.sourceDocumentPool.discardIndexes(this.getKeyManager());
        this.sourceDocumentPool = new DocumentPool();
    }

    public void setInitialContextItem(Item item) {
        this.initialContextItem = item;
        this.contextForGlobalVariables = item;
    }

    public Bindery getBindery() {
        return this.bindery;
    }

    public Item getInitialContextItem() {
        return this.initialContextItem;
    }

    public Item getContextForGlobalVariables() {
        return this.contextForGlobalVariables;
    }

    public void setURIResolver(URIResolver resolver) {
        this.userURIResolver = resolver;
        if (resolver instanceof StandardURIResolver) {
            ((StandardURIResolver)resolver).setConfiguration(this.getConfiguration());
        }
    }

    public URIResolver getURIResolver() {
        return this.userURIResolver;
    }

    public URIResolver getStandardURIResolver() {
        return this.standardURIResolver;
    }

    public void setOutputURIResolver(OutputURIResolver resolver) {
        this.outputURIResolver = resolver == null ? this.config.getOutputURIResolver() : resolver;
    }

    public OutputURIResolver getOutputURIResolver() {
        return this.outputURIResolver;
    }

    public void setUnparsedTextURIResolver(UnparsedTextURIResolver resolver) {
        this.unparsedTextResolver = resolver;
    }

    public UnparsedTextURIResolver getUnparsedTextURIResolver() {
        return this.unparsedTextResolver;
    }

    public void setSchemaURIResolver(SchemaURIResolver resolver) {
        this.schemaURIResolver = resolver;
    }

    public SchemaURIResolver getSchemaURIResolver() {
        return this.schemaURIResolver;
    }

    public void setCollectionURIResolver(CollectionURIResolver resolver) {
        this.collectionURIResolver = resolver;
    }

    public CollectionURIResolver getCollectionURIResolver() {
        return this.collectionURIResolver == null ? this.getConfiguration().getCollectionURIResolver() : this.collectionURIResolver;
    }

    public void setDefaultCollection(String uri) {
        this.defaultCollectionURI = uri;
    }

    public String getDefaultCollection() {
        return this.defaultCollectionURI == null ? this.getConfiguration().getDefaultCollection() : this.defaultCollectionURI;
    }

    public int getSchemaValidationMode() {
        return this.validationMode;
    }

    public void setSchemaValidationMode(int validationMode) {
        this.validationMode = validationMode;
    }

    public KeyManager getKeyManager() {
        return this.executable.getKeyManager();
    }

    public NamePool getNamePool() {
        return this.namePool;
    }

    public void setTreeModel(int model) {
        this.treeModel = TreeModel.getTreeModel(model);
    }

    public int getTreeModel() {
        return this.treeModel.getSymbolicValue();
    }

    public void setModel(TreeModel model) {
        this.treeModel = model;
    }

    public TreeModel getModel() {
        return this.treeModel;
    }

    public Builder makeBuilder() {
        Builder b = this.treeModel.makeBuilder(this.makePipelineConfiguration());
        b.setTiming(this.config.isTiming());
        b.setLineNumbering(this.config.isLineNumbering());
        return b;
    }

    public void setStripSourceTrees(boolean strip) {
        this.stripSourceTrees = strip;
    }

    public boolean isStripSourceTree() {
        return this.stripSourceTrees;
    }

    public Stripper makeStripper(Receiver next) {
        if (next == null) {
            next = new Sink(this.makePipelineConfiguration());
        }
        return new Stripper(this.getSpaceStrippingRule(), next);
    }

    public SpaceStrippingRule getSpaceStrippingRule() {
        if (this.config.isStripsAllWhiteSpace()) {
            return AllElementsSpaceStrippingRule.getInstance();
        }
        if (this.executable == null) {
            return NoElementsSpaceStrippingRule.getInstance();
        }
        return this.executable.getStripperRules();
    }

    public void registerDocument(DocumentInfo doc, DocumentURI uri) throws XPathException {
        if (doc == null) {
            throw new NullPointerException("null");
        }
        if (!this.getExecutable().isSchemaAware() && !Untyped.getInstance().equals(doc.getSchemaType())) {
            String task = this.getExecutable().getHostLanguage() == 50 ? "transformation" : "query";
            throw new XPathException("The " + task + " is not schema-aware, so the source document must be untyped");
        }
        if (uri != null) {
            this.sourceDocumentPool.add(doc, uri);
        }
    }

    public void setRuleManager(RuleManager r) {
        this.ruleManager = r;
    }

    public RuleManager getRuleManager() {
        return this.ruleManager;
    }

    public void setTraceListener(TraceListener listener) {
        this.traceListener = listener;
    }

    public TraceListener getTraceListener() {
        return this.traceListener;
    }

    public final boolean isTracing() {
        return this.traceListener != null && !this.tracingPaused;
    }

    public final void pauseTracing(boolean pause) {
        this.tracingPaused = pause;
    }

    public void addTraceListener(TraceListener trace) {
        if (trace != null) {
            this.traceListener = TraceEventMulticaster.add(this.traceListener, trace);
        }
    }

    public void removeTraceListener(TraceListener trace) {
        this.traceListener = TraceEventMulticaster.remove(this.traceListener, trace);
    }

    public void setTraceFunctionDestination(PrintStream stream) {
        this.traceFunctionDestination = stream;
    }

    public PrintStream getTraceFunctionDestination() {
        return this.traceFunctionDestination;
    }

    public void setPreparedStylesheet(PreparedStylesheet sheet) {
        this.preparedStylesheet = sheet;
        this.executable = sheet;
        this.messageReceiverClassName = sheet.getCompilerInfo().getMessageReceiverClassName();
        this.outputURIResolver = sheet.getCompilerInfo().getOutputURIResolver();
        this.recoveryPolicy = sheet.getCompilerInfo().getRecoveryPolicy();
    }

    public void setExecutable(Executable exec) {
        this.executable = exec;
    }

    private void initializeController() throws XPathException {
        if (this.preparedStylesheet != null) {
            this.setRuleManager(this.preparedStylesheet.getRuleManager());
        }
        if (this.traceListener != null) {
            this.traceListener.open(this);
        }
        this.bindery = new Bindery();
        this.executable.initializeBindery(this.bindery);
        this.defineGlobalParameters();
    }

    public void defineGlobalParameters() throws XPathException {
        this.executable.checkAllRequiredParamsArePresent(this.parameters);
        this.bindery.defineGlobalParameters(this.parameters);
    }

    public void allocateGlobalVariables(int numberOfVariables) {
        SlotManager map = this.executable.getGlobalVariableMap();
        map.setNumberOfVariables(numberOfVariables);
        this.bindery.allocateGlobals(map);
    }

    public Object getUserData(Object key, String name) {
        String keyValue = key.hashCode() + " " + name;
        return this.userDataTable.get(keyValue);
    }

    public void setUserData(Object key, String name, Object data) {
        String keyVal = key.hashCode() + " " + name;
        if (data == null) {
            this.userDataTable.remove(keyVal);
        } else {
            this.userDataTable.put(keyVal, data);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void transform(Source source, Result result) throws TransformerException {
        if (this.inUse) {
            throw new IllegalStateException("The Transformer is being used recursively or concurrently. This is not permitted.");
        }
        this.clearPerTransformationData();
        if (this.preparedStylesheet == null) {
            throw new XPathException("Stylesheet has not been prepared");
        }
        if (!this.dateTimePreset) {
            this.currentDateTime = null;
        }
        if (source instanceof SAXSource && this.config.getBooleanProperty("http://saxon.sf.net/feature/ignoreSAXSourceParser")) {
            ((SAXSource)source).setXMLReader(null);
        }
        boolean close = false;
        try {
            Source s2;
            NodeInfo startNode = null;
            boolean wrap = true;
            boolean streaming = false;
            int validationMode = this.getSchemaValidationMode();
            Source underSource = source;
            if (source instanceof AugmentedSource) {
                Boolean localWrap = ((AugmentedSource)source).getWrapDocument();
                if (localWrap != null) {
                    wrap = localWrap;
                }
                close = ((AugmentedSource)source).isPleaseCloseAfterUse();
                int localValidate = ((AugmentedSource)source).getSchemaValidation();
                if (localValidate != 0) {
                    validationMode = localValidate;
                }
                if (validationMode == 1 || validationMode == 2) {
                    wrap = false;
                }
                underSource = ((AugmentedSource)source).getContainedSource();
            }
            if ((s2 = this.config.getSourceResolver().resolveSource(underSource, this.config)) != null) {
                underSource = s2;
            }
            if (wrap && (underSource instanceof NodeInfo || underSource instanceof DOMSource)) {
                startNode = this.prepareInputTree(underSource);
                String uri = underSource.getSystemId();
                DocumentInfo root = startNode.getDocumentRoot();
                if (root != null) {
                    this.registerDocument(startNode.getDocumentRoot(), uri == null ? null : new DocumentURI(uri));
                }
            } else if (source == null) {
                if (this.initialTemplate == null) {
                    throw new XPathException("Either a source document or an initial template must be specified");
                }
            } else {
                Mode mode = this.preparedStylesheet.getRuleManager().getMode(this.initialMode, false);
                if (mode == null || this.initialMode != null && mode.isEmpty()) {
                    throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getDisplayName()) + " does not exist", "XTDE0045");
                }
                if (mode.isStreamable()) {
                    if (!(source instanceof StreamSource) && !(source instanceof SAXSource) && !(source instanceof Transmitter)) throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getDisplayName()) + " is streamable: must supply a SAXSource or StreamSource", "SXST0061");
                    streaming = true;
                    this.transformStream(source, mode, result);
                } else {
                    Builder sourceBuilder = this.makeBuilder();
                    Receiver r = sourceBuilder;
                    if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace() || validationMode == 1 || validationMode == 2) {
                        r = this.makeStripper(sourceBuilder);
                    }
                    if (this.executable.stripsInputTypeAnnotations()) {
                        r = this.config.getAnnotationStripper(r);
                    }
                    r.setPipelineConfiguration(sourceBuilder.getPipelineConfiguration());
                    Sender.send(source, r, null);
                    if (close) {
                        ((AugmentedSource)source).close();
                    }
                    DocumentInfo doc = (DocumentInfo)sourceBuilder.getCurrentRoot();
                    sourceBuilder.reset();
                    if (source.getSystemId() != null) {
                        this.registerDocument(doc, new DocumentURI(source.getSystemId()));
                    }
                    startNode = doc;
                }
            }
            if (streaming) return;
            this.transformDocument(startNode, result);
            return;
        }
        catch (TerminationException err) {
            if (err.hasBeenReported()) throw err;
            this.reportFatalError(err);
            throw err;
        }
        catch (XPathException err) {
            Throwable cause = err.getException();
            if (cause != null && cause instanceof SAXParseException) {
                SAXParseException spe = (SAXParseException)cause;
                if (!((cause = spe.getException()) instanceof RuntimeException)) throw err;
                this.reportFatalError(err);
                throw err;
            } else {
                this.reportFatalError(err);
            }
            throw err;
        }
        catch (NullPointerException err) {
            err.printStackTrace();
            throw err;
        }
        finally {
            this.inUse = false;
            if (close && source instanceof AugmentedSource) {
                ((AugmentedSource)source).close();
            }
            this.principalResultURI = null;
        }
    }

    public NodeInfo prepareInputTree(Source source) {
        AbstractVirtualNode strippedDoc;
        DocumentInfo docInfo;
        NodeInfo start = this.getConfiguration().unravel(source);
        if (this.stripSourceTrees && this.executable.stripsWhitespace()) {
            docInfo = start.getDocumentRoot();
            strippedDoc = new SpaceStrippedDocument(docInfo, this.getSpaceStrippingRule());
            start = ((SpaceStrippedDocument)strippedDoc).wrap(start);
        }
        if (this.executable.stripsInputTypeAnnotations()) {
            docInfo = start.getDocumentRoot();
            if (!Untyped.getInstance().equals(docInfo.getSchemaType())) {
                strippedDoc = new TypeStrippedDocument(docInfo);
                start = ((TypeStrippedDocument)strippedDoc).wrap(start);
            }
        }
        return start;
    }

    public void transformDocument(NodeInfo startNode, Result result) throws TransformerException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        boolean mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        this.principalResult = result;
        if (this.principalResultURI == null) {
            this.principalResultURI = result.getSystemId();
        }
        XPathContextMajor initialContext = this.newXPathContext();
        initialContext.createThreadManager();
        initialContext.setOriginatingConstructType(2000);
        if (startNode != null) {
            this.initialContextItem = startNode;
            this.contextForGlobalVariables = startNode.getRoot();
            if (startNode.getConfiguration() == null) {
                throw new TransformerException("The supplied source document must be associated with a Configuration");
            }
            if (!startNode.getConfiguration().isCompatible(this.preparedStylesheet.getConfiguration())) {
                throw new XPathException("Source document and stylesheet must use the same or compatible Configurations", "SXXP0004");
            }
            if (startNode instanceof DocumentInfo && ((DocumentInfo)startNode).isTyped() && !this.preparedStylesheet.isSchemaAware()) {
                throw new XPathException("Cannot use a schema-validated source document unless the stylesheet is schema-aware");
            }
            UnfailingIterator<NodeInfo> currentIter = SingletonIterator.makeIterator(startNode);
            if (this.initialTemplate != null) {
                currentIter.next();
            }
            initialContext.setCurrentIterator(currentIter);
        }
        this.initializeController();
        if (this.traceListener != null) {
            this.preEvaluateGlobals(initialContext);
        }
        result = this.openResult(result, initialContext);
        if (this.initialTemplate == null) {
            Object topElement;
            this.initialContextItem = startNode;
            Mode mode = this.getRuleManager().getMode(this.initialMode, false);
            if (mode == null || this.initialMode != null && mode.isEmpty()) {
                throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getDisplayName()) + " does not exist", "XTDE0045");
            }
            if (mode.isStreamable()) {
                throw new XPathException("Requested initial mode " + (this.initialMode == null ? "" : this.initialMode.getDisplayName()) + " is streamable: must supply a StreamSource or SAXSource");
            }
            if (startNode instanceof DocumentInfo && (topElement = startNode.iterateAxis((byte)3, NodeKindTest.ELEMENT).next()) != null) {
                String uri = topElement.getURI();
                Set<String> explicitNamespaces = mode.getExplicitNamespaces(this.namePool);
                if (!explicitNamespaces.isEmpty() && !explicitNamespaces.contains(uri)) {
                    if (explicitNamespaces.size() == 1 && explicitNamespaces.contains("")) {
                        this.warning("The source document is in namespace " + uri + ", but all the template rules match elements in no namespace", "SXXP0005");
                    } else if (uri.equals("")) {
                        this.warning("The source document is in no namespace, but the template rules all expect elements in a namespace", "SXXP0005");
                    } else {
                        this.warning("The source document is in namespace " + uri + ", but none of the template rules match elements in this namespace", "SXXP0005");
                    }
                }
            }
            initialContext.setCurrentMode(mode);
            for (TailCall tc = mode.applyTemplates(null, null, initialContext, 0); tc != null; tc = tc.processLeavingTail()) {
            }
        } else {
            Template t = this.initialTemplate;
            XPathContextMajor c2 = initialContext.newContext();
            initialContext.setOriginatingConstructType(2000);
            c2.openStackFrame(t.getStackFrameMap());
            c2.setLocalParameters(new ParameterSet());
            c2.setTunnelParameters(new ParameterSet());
            for (TailCall tc = t.expand(c2); tc != null; tc = tc.processLeavingTail()) {
            }
        }
        if (this.traceListener != null) {
            this.traceListener.close();
        }
        initialContext.notifyChildThreads();
        this.closeMessageEmitter();
        this.closeResult(result, mustClose, initialContext);
    }

    public void transformStream(Source source, Mode mode, Result result) throws TransformerException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        boolean mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        this.principalResult = result;
        if (this.principalResultURI == null) {
            this.principalResultURI = result.getSystemId();
        }
        XPathContextMajor initialContext = this.newXPathContext();
        initialContext.setOriginatingConstructType(2000);
        this.initialContextItem = null;
        this.contextForGlobalVariables = null;
        this.initializeController();
        result = this.openResult(result, initialContext);
        if (!mode.isStreamable()) {
            throw new XPathException("mode supplied to transformStream() must be streamable");
        }
        Receiver despatcher = this.config.makeStreamingTransformer(initialContext, mode);
        if (despatcher == null) {
            throw new TransformerException("Streaming requires Saxon-EE");
        }
        if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace()) {
            despatcher = this.makeStripper(despatcher);
        }
        Sender.send(source, despatcher, null);
        if (this.traceListener != null) {
            this.traceListener.close();
        }
        this.closeResult(result, mustClose, initialContext);
        this.closeMessageEmitter();
    }

    public Receiver getStreamingReceiver(Mode mode, Result result) throws TransformerException {
        if (this.executable == null) {
            throw new XPathException("Stylesheet has not been compiled");
        }
        this.openMessageEmitter();
        final boolean mustClose = result instanceof StreamResult && ((StreamResult)result).getOutputStream() == null;
        this.principalResult = result;
        if (this.principalResultURI == null) {
            this.principalResultURI = result.getSystemId();
        }
        final XPathContextMajor initialContext = this.newXPathContext();
        initialContext.setOriginatingConstructType(2000);
        this.initialContextItem = null;
        this.contextForGlobalVariables = null;
        this.initializeController();
        final Result result2 = this.openResult(result, initialContext);
        if (!mode.isStreamable()) {
            throw new XPathException("mode supplied to getStreamingReceiver() must be streamable");
        }
        Receiver despatcher = this.config.makeStreamingTransformer(initialContext, mode);
        if (despatcher == null) {
            throw new TransformerException("Streaming requires Saxon-EE");
        }
        if (this.config.isStripsAllWhiteSpace() || this.executable.stripsWhitespace()) {
            despatcher = this.makeStripper(despatcher);
        }
        despatcher.setPipelineConfiguration(this.makePipelineConfiguration());
        return new ProxyReceiver(despatcher){

            public void close() throws XPathException {
                if (Controller.this.traceListener != null) {
                    Controller.this.traceListener.close();
                }
                Controller.this.closeResult(result2, mustClose, initialContext);
                Controller.this.closeMessageEmitter();
            }
        };
    }

    private void closeMessageEmitter() throws XPathException {
        this.getMessageEmitter().close();
    }

    private void closeResult(Result result, boolean mustClose, XPathContextMajor initialContext) throws XPathException {
        OutputStream os;
        SequenceReceiver out = initialContext.getReceiver();
        out.endDocument();
        out.close();
        if (mustClose && result instanceof StreamResult && (os = ((StreamResult)result).getOutputStream()) != null) {
            try {
                os.close();
            }
            catch (IOException err) {
                throw new XPathException(err);
            }
        }
    }

    private Result openResult(Result result, XPathContextMajor initialContext) throws TransformerException {
        Properties xslOutputProps = this.localOutputProperties == null ? this.executable.getDefaultOutputProperties() : this.localOutputProperties;
        String nextInChain = xslOutputProps.getProperty("{http://saxon.sf.net/}next-in-chain");
        if (nextInChain != null && nextInChain.length() > 0) {
            SerializerFactory factory = this.getConfiguration().getSerializerFactory();
            String baseURI = xslOutputProps.getProperty("{http://saxon.sf.net/}next-in-chain-base-uri");
            result = factory.prepareNextStylesheet(this, nextInChain, baseURI, result);
        }
        SerializerFactory sf = this.getConfiguration().getSerializerFactory();
        PipelineConfiguration pipe = this.makePipelineConfiguration();
        pipe.setHostLanguage(50);
        Receiver receiver = sf.getReceiver(result, pipe, xslOutputProps);
        boolean openNow = false;
        if (this.getExecutable().createsSecondaryResult()) {
            receiver = new ImplicitResultChecker(receiver, this);
            receiver.setPipelineConfiguration(pipe);
        } else {
            openNow = true;
        }
        initialContext.changeOutputDestination(receiver, null);
        if (openNow) {
            SequenceReceiver out = initialContext.getReceiver();
            out.open();
            out.startDocument(0);
        }
        return result;
    }

    private void openMessageEmitter() throws XPathException {
        if (this.getMessageEmitter() == null) {
            Receiver me = this.makeMessageReceiver();
            this.setMessageEmitter(me);
            if (me instanceof Emitter && ((Emitter)me).getWriter() == null) {
                try {
                    ((Emitter)me).setWriter(new OutputStreamWriter(this.getConfiguration().getStandardErrorOutput()));
                }
                catch (Exception err) {
                    try {
                        ((Emitter)me).setWriter(new OutputStreamWriter((OutputStream)this.getConfiguration().getStandardErrorOutput(), "utf8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new XPathException(e);
                    }
                }
            }
        }
        this.getMessageEmitter().open();
    }

    public void preEvaluateGlobals(XPathContext context) throws XPathException {
        HashMap<StructuredQName, GlobalVariable> vars = this.getExecutable().getCompiledGlobalVariables();
        if (vars != null) {
            for (GlobalVariable var : vars.values()) {
                try {
                    var.evaluateVariable(context);
                }
                catch (XPathException err) {
                    SingletonClosure closure = new SingletonClosure(new ErrorExpression(err), context);
                    this.getBindery().setGlobalVariable(var, closure);
                }
            }
        }
    }

    public void setGlobalParameterSet(GlobalParameterSet params) {
        this.parameters = params;
    }

    public void setParameter(String expandedName, Object value) {
        if (expandedName == null) {
            throw new NullPointerException("Transformer.setParameter() - expandedName is null");
        }
        if (this.parameters == null) {
            this.parameters = new GlobalParameterSet();
        }
        this.parameters.put(StructuredQName.fromClarkName(expandedName), value);
    }

    public void setParameter(StructuredQName qName, Sequence value) {
        if (this.parameters == null) {
            this.parameters = new GlobalParameterSet();
        }
        this.parameters.put(qName, value);
    }

    public void clearParameters() {
        this.parameters = null;
    }

    public Object getParameter(String expandedName) {
        if (this.parameters == null) {
            return null;
        }
        return this.parameters.get(StructuredQName.fromClarkName(expandedName));
    }

    public Iterator iterateParameters() {
        if (this.parameters == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        int k = this.parameters.getNumberOfKeys();
        ArrayList<String> list = new ArrayList<String>(k);
        Collection<StructuredQName> keys = this.parameters.getKeys();
        for (StructuredQName qName : keys) {
            String clarkName = qName.getClarkName();
            list.add(clarkName);
        }
        return list.iterator();
    }

    public void setCurrentDateTime(DateTimeValue dateTime) throws XPathException {
        if (this.currentDateTime == null) {
            if (dateTime.getComponent(7) == null) {
                throw new XPathException("No timezone is present in supplied value of current date/time");
            }
        } else {
            throw new IllegalStateException("Current date and time can only be set once, and cannot subsequently be changed");
        }
        this.currentDateTime = dateTime;
        this.dateTimePreset = true;
    }

    public DateTimeValue getCurrentDateTime() {
        if (this.currentDateTime == null) {
            this.currentDateTime = new DateTimeValue(new GregorianCalendar(), true);
        }
        return this.currentDateTime;
    }

    public int getImplicitTimezone() {
        return this.getCurrentDateTime().getTimezoneInMinutes();
    }

    public XPathContextMajor newXPathContext() {
        return new XPathContextMajor(this);
    }

    public void setRememberedNumber(NodeInfo node, int number) {
        this.lastRememberedNode = node;
        this.lastRememberedNumber = number;
    }

    public int getRememberedNumber(NodeInfo node) {
        if (this.lastRememberedNode == node) {
            return this.lastRememberedNumber;
        }
        return -1;
    }

    public void setUseDocumentProjection(PathMap pathMap) {
        this.pathMap = pathMap;
    }

    public PathMap getPathMapForDocumentProjection() {
        return this.pathMap;
    }

    public void setClassLoader(ClassLoader loader) {
        this.classLoader = loader;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

