/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.parsing.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.aries.jpa.container.parsing.ParsedPersistenceUnit;
import org.osgi.framework.Bundle;

public class PersistenceUnitImpl
implements ParsedPersistenceUnit {
    private final Map<String, Object> metadata = new HashMap<String, Object>();
    private final Bundle bundle;

    public PersistenceUnitImpl(Bundle b, String name, String transactionType, String version) {
        this.bundle = b;
        this.metadata.put("org.apache.aries.jpa.schema.version", version);
        this.metadata.put("org.apache.aries.jpa.properties", new Properties());
        if (name == null) {
            name = "";
        }
        this.metadata.put("org.apache.aries.jpa.unit.name", name);
        if (transactionType != null) {
            this.metadata.put("org.apache.aries.jpa.transaction.type", transactionType);
        }
    }

    public Bundle getDefiningBundle() {
        return this.bundle;
    }

    public Map<String, Object> getPersistenceXmlMetadata() {
        HashMap<String, Object> data = new HashMap<String, Object>(this.metadata);
        if (data.containsKey("org.apache.aries.jpa.mapping.files")) {
            data.put("org.apache.aries.jpa.mapping.files", ((ArrayList)this.metadata.get("org.apache.aries.jpa.mapping.files")).clone());
        }
        if (data.containsKey("org.apache.aries.jpa.jar.files")) {
            data.put("org.apache.aries.jpa.jar.files", ((ArrayList)this.metadata.get("org.apache.aries.jpa.jar.files")).clone());
        }
        if (data.containsKey("org.apache.aries.jpa.managed.classes")) {
            data.put("org.apache.aries.jpa.managed.classes", ((ArrayList)this.metadata.get("org.apache.aries.jpa.managed.classes")).clone());
        }
        if (data.containsKey("org.apache.aries.jpa.properties")) {
            data.put("org.apache.aries.jpa.properties", ((Properties)this.metadata.get("org.apache.aries.jpa.properties")).clone());
        }
        return data;
    }

    public void setProviderClassName(String provider) {
        this.metadata.put("org.apache.aries.jpa.provider", provider);
    }

    public void setJtaDataSource(String jtaDataSource) {
        this.metadata.put("org.apache.aries.jpa.jta.datasource", jtaDataSource);
    }

    public void setNonJtaDataSource(String nonJtaDataSource) {
        this.metadata.put("org.apache.aries.jpa.non.jta.datasource", nonJtaDataSource);
    }

    public void addMappingFileName(String mappingFileName) {
        ArrayList<String> files = (ArrayList<String>)this.metadata.get("org.apache.aries.jpa.mapping.files");
        if (files == null) {
            files = new ArrayList<String>();
            this.metadata.put("org.apache.aries.jpa.mapping.files", files);
        }
        files.add(mappingFileName);
    }

    public void addJarFileName(String jarFile) {
        ArrayList<String> jars = (ArrayList<String>)this.metadata.get("org.apache.aries.jpa.jar.files");
        if (jars == null) {
            jars = new ArrayList<String>();
            this.metadata.put("org.apache.aries.jpa.jar.files", jars);
        }
        jars.add(jarFile);
    }

    public void addClassName(String className) {
        ArrayList<String> classes = (ArrayList<String>)this.metadata.get("org.apache.aries.jpa.managed.classes");
        if (classes == null) {
            classes = new ArrayList<String>();
            this.metadata.put("org.apache.aries.jpa.managed.classes", classes);
        }
        classes.add(className);
    }

    public void setExcludeUnlisted(boolean exclude) {
        this.metadata.put("org.apache.aries.jpa.exclude.unlisted", exclude);
    }

    public void addProperty(String name, String value) {
        Properties props = (Properties)this.metadata.get("org.apache.aries.jpa.properties");
        props.setProperty(name, value);
    }

    public void setSharedCacheMode(String sharedCacheMode) {
        this.metadata.put("org.apache.aries.jpa2.shared.cache.mode", sharedCacheMode);
    }

    public void setValidationMode(String validationMode) {
        this.metadata.put("org.apache.aries.jpa2.validation.mode", validationMode);
    }

    public String toString() {
        return "Persistence unit " + this.metadata.get("org.apache.aries.jpa.unit.name") + " in bundle " + this.bundle.getSymbolicName() + "_" + this.bundle.getVersion();
    }
}

