/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jpa.container.tx.impl;

import java.util.concurrent.atomic.AtomicReference;
import javax.transaction.InvalidTransactionException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.aries.jpa.container.impl.NLS;
import org.apache.aries.util.tracker.SingleServiceTracker;
import org.osgi.framework.BundleContext;

public class OSGiTransactionManager
implements SingleServiceTracker.SingleServiceListener {
    private static final AtomicReference<OSGiTransactionManager> INSTANCE = new AtomicReference();
    private final SingleServiceTracker<TransactionManager> tracker;

    public static void init(BundleContext ctx) {
        try {
            Class<TransactionManager> txMgrClass = Class.forName("javax.transaction.TransactionManager", false, OSGiTransactionManager.class.getClassLoader());
            OSGiTransactionManager otm = new OSGiTransactionManager(txMgrClass, ctx);
            if (!INSTANCE.compareAndSet(null, otm)) {
                otm.destroy();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static OSGiTransactionManager get() {
        return INSTANCE.get();
    }

    private OSGiTransactionManager(Class<TransactionManager> txMgrClass, BundleContext ctx) {
        this.tracker = new SingleServiceTracker(ctx, txMgrClass, (SingleServiceTracker.SingleServiceListener)this);
        this.tracker.open();
    }

    private TransactionManager getTransactionManager() {
        TransactionManager txMgr = (TransactionManager)this.tracker.getService();
        if (txMgr == null) {
            throw new IllegalStateException(NLS.MESSAGES.getMessage("unable.to.get.tx.mgr", new Object[0]));
        }
        return txMgr;
    }

    public void destroy() {
        this.tracker.close();
    }

    public int getStatus() throws SystemException {
        return this.getTransactionManager().getStatus();
    }

    public void resume(Transaction arg0) throws IllegalStateException, InvalidTransactionException, SystemException {
        this.getTransactionManager().resume(arg0);
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        this.getTransactionManager().setRollbackOnly();
    }

    public Object getTransaction() throws SystemException {
        return this.getTransactionManager().getTransaction();
    }

    public void serviceFound() {
    }

    public void serviceLost() {
    }

    public void serviceReplaced() {
    }
}

