/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.component.camel.common.handler;

import javax.xml.namespace.QName;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.Processor;
import org.apache.camel.ProducerTemplate;
import org.jboss.logging.Logger;
import org.switchyard.Exchange;
import org.switchyard.ExchangePattern;
import org.switchyard.HandlerException;
import org.switchyard.Message;
import org.switchyard.Scope;
import org.switchyard.ServiceDomain;
import org.switchyard.common.camel.SwitchYardCamelContext;
import org.switchyard.common.xml.QNameUtil;
import org.switchyard.component.camel.common.CommonCamelMessages;
import org.switchyard.component.camel.common.composer.CamelBindingData;
import org.switchyard.component.camel.common.handler.DefaultProcessor;
import org.switchyard.component.camel.common.model.CamelBindingModel;
import org.switchyard.component.camel.common.transaction.TransactionHelper;
import org.switchyard.component.common.composer.BindingData;
import org.switchyard.component.common.composer.MessageComposer;
import org.switchyard.deploy.BaseServiceHandler;
import org.switchyard.deploy.Lifecycle;
import org.switchyard.label.BehaviorLabel;

public class OutboundHandler
extends BaseServiceHandler {
    private static Logger _logger = Logger.getLogger(OutboundHandler.class);
    private final MessageComposer<CamelBindingData> _messageComposer;
    private final ProducerTemplate _producerTemplate;
    private final SwitchYardCamelContext _camelContext;
    private final String _bindingName;
    private final String _referenceName;
    private final String _uri;
    private final ServiceDomain _domain;

    public OutboundHandler(CamelBindingModel binding, SwitchYardCamelContext context, MessageComposer<CamelBindingData> messageComposer, ServiceDomain domain) {
        this(binding, context, messageComposer, null, domain);
    }

    public OutboundHandler(CamelBindingModel binding, SwitchYardCamelContext context, MessageComposer<CamelBindingData> messageComposer, ProducerTemplate producerTemplate, ServiceDomain domain) {
        super(domain);
        this._domain = domain;
        if (binding == null) {
            throw CommonCamelMessages.MESSAGES.bindingArgumentMustNotBeNull();
        }
        if (context == null) {
            throw CommonCamelMessages.MESSAGES.camelContextArgumentMustNotBeNull();
        }
        if (binding.getComponentURI() == null) {
            throw CommonCamelMessages.MESSAGES.bindingUriMustNotBeNull();
        }
        this._uri = binding.getComponentURI().toString();
        this._bindingName = binding.getName();
        this._referenceName = binding.getReference().getName();
        this._camelContext = context;
        this._messageComposer = messageComposer;
        this._producerTemplate = producerTemplate == null ? this._camelContext.createProducerTemplate() : producerTemplate;
        TransactionHelper.useTransactionManager(this._uri, context);
    }

    protected void doStart() {
        try {
            this._producerTemplate.start();
            _logger.debug((Object)("Started producer template for " + this._uri));
        }
        catch (Exception e) {
            throw CommonCamelMessages.MESSAGES.failedToStartCamelProducerTemplateFor(this._uri, e);
        }
    }

    protected void doStop() {
        try {
            this._producerTemplate.stop();
            _logger.debug((Object)("Stopped producer template for " + this._uri));
        }
        catch (Exception ex) {
            throw CommonCamelMessages.MESSAGES.failedToStopCamelProducerTemplateFor(this._uri.toString(), ex);
        }
    }

    public void handleMessage(Exchange exchange) throws HandlerException {
        exchange.getContext().setProperty("org.switchyard.exchangeGatewayName", (Object)this._bindingName, Scope.EXCHANGE).addLabels(new String[]{BehaviorLabel.TRANSIENT.label()});
        if (this.getState() != Lifecycle.State.STARTED) {
            throw CommonCamelMessages.MESSAGES.referenceBindingIsNotStarted(this._referenceName, this._bindingName);
        }
        if (this.isInOnly(exchange)) {
            this.handleInOnly(exchange);
        } else {
            this.handleInOut(exchange);
        }
    }

    private boolean isInOnly(Exchange exchange) {
        return exchange.getContract().getConsumerOperation().getExchangePattern() == ExchangePattern.IN_ONLY;
    }

    private void handleInOnly(Exchange exchange) throws HandlerException {
        try {
            org.apache.camel.Exchange camelExchange = this._producerTemplate.send(this._uri, this.createProcessor(exchange));
            Object propagateException = this._domain.getProperty("org.switchyard.propagateExceptionOnInOnly");
            if ((propagateException == null || Boolean.parseBoolean(propagateException.toString())) && camelExchange.isFailed()) {
                Exception camelException = camelExchange.getException();
                if (camelException != null) {
                    throw new HandlerException((Throwable)camelException);
                }
                throw CommonCamelMessages.MESSAGES.camelExchangeFailedWithoutAnException("");
            }
        }
        catch (CamelExecutionException e) {
            throw new HandlerException((Throwable)e);
        }
    }

    private void handleInOut(Exchange switchyardExchange) throws HandlerException {
        org.apache.camel.Exchange camelExchange = this._producerTemplate.request(this._uri, this.createProcessor(switchyardExchange));
        CamelBindingData bindingData = new CamelBindingData(camelExchange.getOut());
        Exception camelException = camelExchange.getException();
        if (!camelExchange.isFailed()) {
            this.sendResponseToSwitchyard(switchyardExchange, bindingData);
        } else {
            QName faultName = switchyardExchange.getContract().getProviderOperation().getFaultType();
            Class declaredFault = faultName != null && QNameUtil.isJavaMessageType((QName)faultName) ? QNameUtil.toJavaMessageType((QName)faultName) : null;
            Object camelFault = camelException;
            if (camelFault == null && camelExchange.hasOut() && bindingData.getMessage().isFault()) {
                camelFault = bindingData.getMessage().getBody();
            }
            if (camelFault != null && declaredFault != null && declaredFault.isAssignableFrom(camelFault.getClass())) {
                Message msg = null;
                try {
                    msg = this._messageComposer.compose((BindingData)bindingData, switchyardExchange);
                }
                catch (Exception e) {
                    throw new HandlerException((Throwable)e);
                }
                switchyardExchange.sendFault(msg);
            } else {
                if (camelFault instanceof Throwable) {
                    throw new HandlerException((Throwable)Throwable.class.cast(camelFault));
                }
                if (camelFault == null) {
                    throw CommonCamelMessages.MESSAGES.camelExchangeFailedWithoutAnException("");
                }
                throw CommonCamelMessages.MESSAGES.camelExchangeFailedWithoutAnException(camelFault.toString());
            }
        }
    }

    private void sendResponseToSwitchyard(Exchange switchyardExchange, CamelBindingData bindingData) throws HandlerException {
        Message msg = null;
        try {
            msg = this._messageComposer.compose((BindingData)bindingData, switchyardExchange);
        }
        catch (Exception e) {
            throw new HandlerException((Throwable)e);
        }
        switchyardExchange.send(msg);
    }

    private Processor createProcessor(Exchange switchyardExchange) {
        return new DefaultProcessor(this._messageComposer, switchyardExchange);
    }

    public CamelContext getCamelContext() {
        return this._camelContext;
    }

    public String getUri() {
        return this._uri;
    }
}

