/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.jaas.command;

import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.TreeMap;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.karaf.jaas.config.JaasRealm;
import org.apache.karaf.jaas.modules.BackingEngine;
import org.apache.karaf.jaas.modules.BackingEngineService;
import org.apache.karaf.shell.console.OsgiCommandSupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class JaasCommandSupport
extends OsgiCommandSupport {
    public static final String JAAS_REALM = "JaasCommand.REALM";
    public static final String JAAS_ENTRY = "JaasCommand.ENTRY";
    public static final String JAAS_CMDS = "JaasCommand.COMMANDS";
    private List<JaasRealm> realms;
    protected BackingEngineService backingEngineService;

    protected abstract Object doExecute(BackingEngine var1) throws Exception;

    protected Object doExecute() throws Exception {
        JaasRealm realm = (JaasRealm)this.session.get(JAAS_REALM);
        AppConfigurationEntry entry = (AppConfigurationEntry)this.session.get(JAAS_ENTRY);
        Queue commandQueue = (Queue)this.session.get(JAAS_CMDS);
        if (realm != null && entry != null) {
            if (commandQueue != null) {
                commandQueue.add(this);
            }
        } else {
            System.err.println("No JAAS Realm / Module has been selected.");
        }
        return null;
    }

    public List<JaasRealm> getRealms() {
        return this.getRealms(false);
    }

    public List<JaasRealm> getRealms(boolean hidden) {
        if (hidden) {
            return this.realms;
        }
        TreeMap<String, JaasRealm> map = new TreeMap<String, JaasRealm>();
        for (JaasRealm realm : this.realms) {
            if (map.containsKey(realm.getName()) && realm.getRank() <= ((JaasRealm)map.get(realm.getName())).getRank()) continue;
            map.put(realm.getName(), realm);
        }
        return new ArrayList<JaasRealm>(map.values());
    }

    public void setRealms(List<JaasRealm> realms) {
        this.realms = realms;
    }

    public BackingEngineService getBackingEngineService() {
        return this.backingEngineService;
    }

    public void setBackingEngineService(BackingEngineService backingEngineService) {
        this.backingEngineService = backingEngineService;
    }
}

