/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.servlets;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.UnavailableException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlets.ProxyServlet;

public class BalancerServlet
extends ProxyServlet {
    private static final String BALANCER_MEMBER_PREFIX = "BalancerMember.";
    private static final List<String> FORBIDDEN_CONFIG_PARAMETERS;
    private static final List<String> REVERSE_PROXY_HEADERS;
    private static final String JSESSIONID = "jsessionid";
    private static final String JSESSIONID_URL_PREFIX = "jsessionid=";
    private boolean _stickySessions;
    private Set<BalancerMember> _balancerMembers = new HashSet<BalancerMember>();
    private boolean _proxyPassReverse;
    private RoundRobinIterator _roundRobinIterator;

    @Override
    public void init(ServletConfig config) throws ServletException {
        this.validateConfig(config);
        super.init(config);
        this.initStickySessions(config);
        this.initBalancers(config);
        this.initProxyPassReverse(config);
        this.postInit();
    }

    private void validateConfig(ServletConfig config) throws ServletException {
        ArrayList<String> initParameterNames = Collections.list(config.getInitParameterNames());
        for (String initParameterName : initParameterNames) {
            if (!FORBIDDEN_CONFIG_PARAMETERS.contains(initParameterName)) continue;
            throw new UnavailableException(initParameterName + " not supported in " + this.getClass().getName());
        }
    }

    private void initStickySessions(ServletConfig config) throws ServletException {
        this._stickySessions = "true".equalsIgnoreCase(config.getInitParameter("StickySessions"));
    }

    private void initBalancers(ServletConfig config) throws ServletException {
        Set<String> balancerNames = this.getBalancerNames(config);
        for (String balancerName : balancerNames) {
            String memberProxyToParam = BALANCER_MEMBER_PREFIX + balancerName + ".ProxyTo";
            String proxyTo = config.getInitParameter(memberProxyToParam);
            if (proxyTo == null || proxyTo.trim().length() == 0) {
                throw new UnavailableException(memberProxyToParam + " parameter is empty.");
            }
            this._balancerMembers.add(new BalancerMember(balancerName, proxyTo));
        }
    }

    private void initProxyPassReverse(ServletConfig config) {
        this._proxyPassReverse = "true".equalsIgnoreCase(config.getInitParameter("ProxyPassReverse"));
    }

    private void postInit() {
        this._roundRobinIterator = new RoundRobinIterator(this._balancerMembers);
    }

    private Set<String> getBalancerNames(ServletConfig config) throws ServletException {
        HashSet<String> names = new HashSet<String>();
        ArrayList<String> initParameterNames = Collections.list(config.getInitParameterNames());
        for (String initParameterName : initParameterNames) {
            if (!initParameterName.startsWith(BALANCER_MEMBER_PREFIX)) continue;
            int endOfNameIndex = initParameterName.lastIndexOf(".");
            if (endOfNameIndex <= BALANCER_MEMBER_PREFIX.length()) {
                throw new UnavailableException(initParameterName + " parameter does not provide a balancer member name");
            }
            names.add(initParameterName.substring(BALANCER_MEMBER_PREFIX.length(), endOfNameIndex));
        }
        return names;
    }

    @Override
    protected HttpURI proxyHttpURI(HttpServletRequest request, String uri) throws MalformedURLException {
        BalancerMember balancerMember = this.selectBalancerMember(request);
        try {
            URI dstUri = new URI(balancerMember.getProxyTo() + "/" + uri).normalize();
            return new HttpURI(dstUri.toString());
        }
        catch (URISyntaxException e) {
            throw new MalformedURLException(e.getMessage());
        }
    }

    private BalancerMember selectBalancerMember(HttpServletRequest request) {
        String name;
        BalancerMember balancerMember = null;
        if (this._stickySessions && (name = this.getBalancerMemberNameFromSessionId(request)) != null && (balancerMember = this.findBalancerMemberByName(name)) != null) {
            return balancerMember;
        }
        return this._roundRobinIterator.next();
    }

    private BalancerMember findBalancerMemberByName(String name) {
        BalancerMember example = new BalancerMember(name, "");
        for (BalancerMember balancerMember : this._balancerMembers) {
            if (!balancerMember.equals(example)) continue;
            return balancerMember;
        }
        return null;
    }

    private String getBalancerMemberNameFromSessionId(HttpServletRequest request) {
        String name = this.getBalancerMemberNameFromSessionCookie(request);
        if (name == null) {
            name = this.getBalancerMemberNameFromURL(request);
        }
        return name;
    }

    private String getBalancerMemberNameFromSessionCookie(HttpServletRequest request) {
        Cookie[] cookies = request.getCookies();
        String name = null;
        for (Cookie cookie : cookies) {
            if (!JSESSIONID.equalsIgnoreCase(cookie.getName())) continue;
            name = this.extractBalancerMemberNameFromSessionId(cookie.getValue());
            break;
        }
        return name;
    }

    private String getBalancerMemberNameFromURL(HttpServletRequest request) {
        String requestURISuffix;
        String name = null;
        String requestURI = request.getRequestURI();
        int idx = requestURI.lastIndexOf(";");
        if (idx != -1 && (requestURISuffix = requestURI.substring(idx)).startsWith(JSESSIONID_URL_PREFIX)) {
            name = this.extractBalancerMemberNameFromSessionId(requestURISuffix.substring(JSESSIONID_URL_PREFIX.length()));
        }
        return name;
    }

    private String extractBalancerMemberNameFromSessionId(String sessionId) {
        String name = null;
        int idx = sessionId.lastIndexOf(".");
        if (idx != -1) {
            String sessionIdSuffix = sessionId.substring(idx + 1);
            name = sessionIdSuffix.length() > 0 ? sessionIdSuffix : null;
        }
        return name;
    }

    @Override
    protected String filterResponseHeaderValue(String headerName, String headerValue, HttpServletRequest request) {
        HttpURI locationURI;
        if (this._proxyPassReverse && REVERSE_PROXY_HEADERS.contains(headerName) && this.isAbsoluteLocation(locationURI = new HttpURI(headerValue)) && this.isBackendLocation(locationURI)) {
            Request jettyRequest = (Request)request;
            try {
                URI reverseUri = new URI(jettyRequest.getRootURL().append(locationURI.getCompletePath()).toString()).normalize();
                return reverseUri.toURL().toString();
            }
            catch (Exception e) {
                this._log.warn("Not filtering header response", e);
                return headerValue;
            }
        }
        return headerValue;
    }

    private boolean isBackendLocation(HttpURI locationURI) {
        for (BalancerMember balancerMember : this._balancerMembers) {
            HttpURI backendURI = balancerMember.getBackendURI();
            if (!backendURI.getHost().equals(locationURI.getHost()) || !backendURI.getScheme().equals(locationURI.getScheme()) || backendURI.getPort() != locationURI.getPort()) continue;
            return true;
        }
        return false;
    }

    private boolean isAbsoluteLocation(HttpURI locationURI) {
        return locationURI.getHost() != null;
    }

    @Override
    public String getHostHeader() {
        throw new UnsupportedOperationException("HostHeader not supported in " + this.getClass().getName());
    }

    @Override
    public void setHostHeader(String hostHeader) {
        throw new UnsupportedOperationException("HostHeader not supported in " + this.getClass().getName());
    }

    @Override
    public boolean validateDestination(String host, String path) {
        return true;
    }

    static {
        LinkedList<String> params = new LinkedList<String>();
        params.add("HostHeader");
        params.add("whiteList");
        params.add("blackList");
        FORBIDDEN_CONFIG_PARAMETERS = Collections.unmodifiableList(params);
        params = new LinkedList();
        params.add("Location");
        params.add("Content-Location");
        params.add("URI");
        REVERSE_PROXY_HEADERS = Collections.unmodifiableList(params);
    }

    private static final class RoundRobinIterator
    implements Iterator<BalancerMember> {
        private BalancerMember[] _balancerMembers;
        private AtomicInteger _index;

        public RoundRobinIterator(Collection<BalancerMember> balancerMembers) {
            this._balancerMembers = balancerMembers.toArray(new BalancerMember[balancerMembers.size()]);
            this._index = new AtomicInteger(-1);
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public BalancerMember next() {
            BalancerMember balancerMember = null;
            while (balancerMember == null) {
                int nextIndex;
                int currentIndex = this._index.get();
                if (!this._index.compareAndSet(currentIndex, nextIndex = (currentIndex + 1) % this._balancerMembers.length)) continue;
                balancerMember = this._balancerMembers[nextIndex];
            }
            return balancerMember;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class BalancerMember {
        private String _name;
        private String _proxyTo;
        private HttpURI _backendURI;

        public BalancerMember(String name, String proxyTo) {
            this._name = name;
            this._proxyTo = proxyTo;
            this._backendURI = new HttpURI(this._proxyTo);
        }

        public String getProxyTo() {
            return this._proxyTo;
        }

        public HttpURI getBackendURI() {
            return this._backendURI;
        }

        public String toString() {
            return "BalancerMember [_name=" + this._name + ", _proxyTo=" + this._proxyTo + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._name == null ? 0 : this._name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BalancerMember other = (BalancerMember)obj;
            return !(this._name == null ? other._name != null : !this._name.equals(other._name));
        }
    }
}

