/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.cdi.extension.impl.component;

import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.ops4j.pax.cdi.api.OsgiService;
import org.ops4j.pax.cdi.api.OsgiServiceProvider;
import org.ops4j.pax.cdi.api.Properties;
import org.ops4j.pax.cdi.api.Property;
import org.ops4j.pax.cdi.extension.impl.compat.PrototypeScopeUtils;
import org.ops4j.pax.cdi.extension.impl.component.ComponentDependencyListener;
import org.ops4j.pax.cdi.extension.impl.component.ComponentDescriptor;
import org.ops4j.pax.cdi.extension.impl.component.ComponentRegistry;
import org.ops4j.pax.cdi.extension.impl.component.DefaultComponentDependencyListener;
import org.ops4j.pax.cdi.extension.impl.context.Osgi6ServiceFactoryBuilder;
import org.ops4j.pax.cdi.extension.impl.context.ServiceFactoryBuilder;
import org.ops4j.pax.cdi.extension.impl.context.SingletonScopeContext;
import org.ops4j.pax.cdi.extension.impl.util.InjectionPointOsgiUtils;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceException;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class ComponentLifecycleManager
implements ComponentDependencyListener {
    private static Logger log = LoggerFactory.getLogger(ComponentLifecycleManager.class);
    @Inject
    private BeanManager beanManager;
    @Inject
    private ComponentRegistry componentRegistry;
    @Inject
    private BundleContext bundleContext;
    @Inject
    private SingletonScopeContext context;
    private ServiceFactoryBuilder serviceFactoryBuilder;

    public void start() {
        this.componentRegistry.setBundleContext(this.bundleContext);
        this.serviceFactoryBuilder = PrototypeScopeUtils.hasPrototypeScope(this.bundleContext) ? new Osgi6ServiceFactoryBuilder(this.beanManager) : new ServiceFactoryBuilder(this.beanManager);
        for (Bean<?> bean : this.componentRegistry.getComponents()) {
            if (!this.isBeanFromCurrentBundle(bean)) continue;
            ComponentDescriptor<?> descriptor = this.componentRegistry.getDescriptor(bean);
            descriptor.setListener(this);
            if (descriptor.isSatisfied()) {
                log.info("component {} is available", bean);
                Object service = this.serviceFactoryBuilder.buildServiceFactory(descriptor);
                this.registerService(bean, service, descriptor);
            }
            descriptor.start();
        }
        this.verifyRequiredNonComponentDependencies();
    }

    private void verifyRequiredNonComponentDependencies() {
        for (InjectionPoint ip : this.componentRegistry.getNonComponentDependencies()) {
            this.verifyRequiredDependency(ip);
        }
    }

    private void verifyRequiredDependency(InjectionPoint ip) {
        BundleContext bc = InjectionPointOsgiUtils.getBundleContext(ip);
        OsgiService qualifier = (OsgiService)ip.getAnnotated().getAnnotation(OsgiService.class);
        Type serviceType = ip.getType();
        Class klass = (Class)serviceType;
        String filter = InjectionPointOsgiUtils.getFilter(klass, qualifier);
        try {
            Collection serviceReferences = bc.getServiceReferences(klass, filter);
            if (serviceReferences.isEmpty()) {
                String msg = "no matching service reference for injection point " + ip;
                throw new ServiceException(msg, 1);
            }
        }
        catch (InvalidSyntaxException e) {
            String msg = "invalid filter syntax: " + filter;
            throw new ServiceException(msg, 0);
        }
    }

    public void stop() {
        DefaultComponentDependencyListener noop = new DefaultComponentDependencyListener();
        for (Bean<?> bean : this.componentRegistry.getComponents()) {
            ComponentDescriptor<?> descriptor = this.componentRegistry.getDescriptor(bean);
            descriptor.setListener(noop);
            descriptor.stop();
        }
    }

    private boolean isBeanFromCurrentBundle(Bean<?> bean) {
        long extendedBundleId = this.bundleContext.getBundle().getBundleId();
        Class klass = bean.getBeanClass();
        long serviceBundleId = FrameworkUtil.getBundle((Class)klass).getBundleId();
        return serviceBundleId == extendedBundleId;
    }

    private <S> void registerService(Bean<S> bean, S service, ComponentDescriptor descriptor) {
        if (!this.isBeanFromCurrentBundle(bean)) {
            return;
        }
        Class klass = bean.getBeanClass();
        AnnotatedType annotatedType = this.beanManager.createAnnotatedType(klass);
        OsgiServiceProvider provider = (OsgiServiceProvider)annotatedType.getAnnotation(OsgiServiceProvider.class);
        String[] typeNames = provider.classes().length == 0 ? this.getTypeNamesForBeanTypes(bean) : this.getTypeNamesForClasses(provider.classes());
        Dictionary<String, Object> props = this.createProperties(klass, service);
        log.debug("publishing service {}, props = {}", (Object)typeNames[0], props);
        ServiceRegistration reg = this.bundleContext.registerService(typeNames, service, props);
        descriptor.setServiceRegistration(reg);
    }

    private <S> void unregisterService(Bean<S> bean, Object service, ComponentDescriptor<S> descriptor) {
        ServiceRegistration<S> reg = descriptor.getServiceRegistration();
        if (reg != null) {
            log.debug("removing service {}", reg);
            try {
                reg.unregister();
            }
            catch (IllegalStateException exc) {
                // empty catch block
            }
        }
    }

    private String[] getTypeNamesForBeanTypes(Bean<?> bean) {
        Set closure = bean.getTypes();
        String[] typeNames = new String[closure.size()];
        int i = 0;
        for (Type type : closure) {
            Class c = (Class)type;
            if (!c.isInterface()) continue;
            typeNames[i++] = c.getName();
        }
        if (i == 0) {
            typeNames[i++] = bean.getBeanClass().getName();
        }
        return Arrays.copyOf(typeNames, i);
    }

    private String[] getTypeNamesForClasses(Class<?>[] classes) {
        String[] typeNames = new String[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            typeNames[i] = classes[i].getName();
        }
        return typeNames;
    }

    private Dictionary<String, Object> createProperties(Class<?> klass, Object service) {
        Properties props = klass.getAnnotation(Properties.class);
        if (props == null) {
            return null;
        }
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        for (Property property : props.value()) {
            dict.put(property.name(), property.value());
        }
        return dict;
    }

    @Override
    public <S> void onComponentSatisfied(ComponentDescriptor<S> descriptor) {
        Bean<S> bean = descriptor.getBean();
        log.info("component {} is available", bean);
        Object sf = this.serviceFactoryBuilder.buildServiceFactory(descriptor);
        this.registerService(bean, sf, descriptor);
    }

    @Override
    public <S> void onComponentUnsatisfied(ComponentDescriptor<S> descriptor) {
        Bean<S> bean = descriptor.getBean();
        S service = this.context.get(bean);
        if (service != null) {
            this.unregisterService(bean, service, descriptor);
            this.context.destroy((Contextual<?>)bean);
        }
    }
}

