/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.deploy.karaf;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.felix.service.command.CommandSession;
import org.apache.karaf.shell.console.Completer;
import org.apache.karaf.shell.console.completer.ArgumentCompleter;
import org.apache.karaf.shell.console.completer.StringsCompleter;
import org.apache.karaf.shell.console.jline.CommandSessionHolder;
import org.switchyard.admin.Application;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;

public class ServiceNameCompleter
implements Completer {
    private SwitchYard _switchYard;
    private Integer _applicationArgumentIndex;
    private String[] _applicationOptions;
    private Set<String> _optionsWithParameters = Collections.emptySet();

    public int complete(String buffer, int cursor, List<String> candidates) {
        StringsCompleter delegate = new StringsCompleter();
        Pattern applicationNamePattern = this.getApplicationNamePattern();
        List applications = this._switchYard.getApplications();
        for (Application application : applications) {
            if (!applicationNamePattern.matcher(application.getName().toString()).find()) continue;
            for (Service service : application.getServices()) {
                delegate.getStrings().add(service.getName().toString());
            }
        }
        return delegate.complete(buffer, cursor, candidates);
    }

    public void setSwitchYard(SwitchYard switchYard) {
        this._switchYard = switchYard;
    }

    public void setApplicationArgumentIndex(Integer applicationArgumentIndex) {
        this._applicationArgumentIndex = applicationArgumentIndex;
    }

    public void setApplicationOptions(String[] applicationOptions) {
        this._applicationOptions = applicationOptions;
    }

    public void setOptionsWithParameters(String[] optionsWithParameters) {
        this._optionsWithParameters = optionsWithParameters == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(optionsWithParameters));
    }

    private Pattern getApplicationNamePattern() {
        boolean isRegex;
        CommandSession session = CommandSessionHolder.getSession();
        if (session == null) {
            return this.compilePattern(null, false);
        }
        ArgumentCompleter.ArgumentList argList = (ArgumentCompleter.ArgumentList)session.get("ARGUMENTS_LIST");
        if (argList == null || argList.getArguments() == null || argList.getArguments().length == 0) {
            return this.compilePattern(null, false);
        }
        List<String> arguments = Arrays.asList(argList.getArguments());
        boolean bl = isRegex = arguments.indexOf("--regex") > 0;
        if (this._applicationArgumentIndex == null) {
            if (this._applicationOptions == null || this._applicationOptions.length == 0) {
                return this.compilePattern(null, false);
            }
            for (String option : this._applicationOptions) {
                int index = arguments.indexOf(option);
                if (index < 0 || arguments.size() - 1 <= index) continue;
                return this.compilePattern(Collections.singletonList(arguments.get(index + 1)), isRegex);
            }
        } else {
            int argumentOffset = 1;
            int count = arguments.size();
            for (int index = 0; index < count; ++index) {
                if (!arguments.get(index).startsWith("-")) continue;
                argumentOffset = index;
                if (!this._optionsWithParameters.contains(arguments.get(index))) continue;
                ++argumentOffset;
            }
            if (this._applicationArgumentIndex + argumentOffset < arguments.size()) {
                return this.compilePattern(Collections.singletonList(arguments.get(this._applicationArgumentIndex + argumentOffset)), isRegex);
            }
        }
        return this.compilePattern(null, false);
    }

    private Pattern compilePattern(List<String> patterns, boolean isRegex) {
        if (patterns == null || patterns.size() == 0) {
            patterns = Collections.singletonList(".*");
            isRegex = true;
        }
        StringBuffer regex = new StringBuffer();
        for (String name : patterns) {
            if (!isRegex) {
                regex.append("\\Q");
            }
            regex.append(name);
            if (!isRegex) {
                regex.append("\\E");
            }
            regex.append('|');
        }
        regex.deleteCharAt(regex.length() - 1);
        return Pattern.compile(regex.toString());
    }
}

