/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml2.core.validator;

import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.xml.util.DatatypeHelper;
import org.opensaml.xml.validation.ValidationException;
import org.opensaml.xml.validation.Validator;

public abstract class StatusResponseTypeSchemaValidator<StatusResponse extends StatusResponseType>
implements Validator<StatusResponse> {
    @Override
    public void validate(StatusResponse response) throws ValidationException {
        this.validateStatus(response);
        this.validateID(response);
        this.validateVersion(response);
        this.validateIssueInstant(response);
    }

    protected void validateStatus(StatusResponse response) throws ValidationException {
        if (response.getStatus() == null) {
            throw new ValidationException("Status is required");
        }
    }

    protected void validateID(StatusResponse response) throws ValidationException {
        if (DatatypeHelper.isEmpty(response.getID())) {
            throw new ValidationException("ID attribute must not be empty");
        }
    }

    protected void validateVersion(StatusResponse response) throws ValidationException {
        if (response.getVersion() == null) {
            throw new ValidationException("Version attribute must not be null");
        }
        if (!DatatypeHelper.safeEquals(response.getVersion().toString(), SAMLVersion.VERSION_20.toString())) {
            throw new ValidationException("Wrong SAML Version");
        }
    }

    protected void validateIssueInstant(StatusResponse response) throws ValidationException {
        if (response.getIssueInstant() == null) {
            throw new ValidationException("IssueInstant attribute must not be null");
        }
    }
}

