/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.AsyncCallback;
import org.apache.camel.AsyncProcessor;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.Rejectable;
import org.apache.camel.ThreadPoolRejectedPolicy;
import org.apache.camel.spi.IdAware;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.AsyncProcessorHelper;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadsProcessor
extends ServiceSupport
implements AsyncProcessor,
IdAware {
    private static final Logger LOG = LoggerFactory.getLogger(ThreadsProcessor.class);
    private String id;
    private final CamelContext camelContext;
    private final ExecutorService executorService;
    private volatile boolean shutdownExecutorService;
    private final AtomicBoolean shutdown = new AtomicBoolean(true);
    private boolean callerRunsWhenRejected = true;
    private ThreadPoolRejectedPolicy rejectedPolicy;

    public ThreadsProcessor(CamelContext camelContext, ExecutorService executorService, boolean shutdownExecutorService) {
        ObjectHelper.notNull(camelContext, "camelContext");
        ObjectHelper.notNull(executorService, "executorService");
        this.camelContext = camelContext;
        this.executorService = executorService;
        this.shutdownExecutorService = shutdownExecutorService;
    }

    @Override
    public void process(Exchange exchange) throws Exception {
        AsyncProcessorHelper.process(this, exchange);
    }

    @Override
    public boolean process(Exchange exchange, AsyncCallback callback) {
        if (this.shutdown.get()) {
            throw new IllegalStateException("ThreadsProcessor is not running.");
        }
        if (exchange.isTransacted()) {
            LOG.trace("Transacted Exchange must be routed synchronously for exchangeId: {} -> {}", (Object)exchange.getExchangeId(), (Object)exchange);
            callback.done(true);
            return true;
        }
        ProcessCall call = new ProcessCall(exchange, callback);
        try {
            LOG.trace("Submitting task {}", (Object)call);
            this.executorService.submit(call);
            return false;
        }
        catch (RejectedExecutionException e) {
            boolean callerRuns = this.isCallerRunsWhenRejected();
            if (!callerRuns) {
                exchange.setException(e);
            }
            LOG.trace("{} executing task {}", (Object)(callerRuns ? "CallerRuns" : "Aborted"), (Object)call);
            if (this.shutdown.get()) {
                exchange.setException(new RejectedExecutionException());
            }
            callback.done(true);
            return true;
        }
    }

    public boolean isCallerRunsWhenRejected() {
        return this.callerRunsWhenRejected;
    }

    public void setCallerRunsWhenRejected(boolean callerRunsWhenRejected) {
        this.callerRunsWhenRejected = callerRunsWhenRejected;
    }

    public ThreadPoolRejectedPolicy getRejectedPolicy() {
        return this.rejectedPolicy;
    }

    public void setRejectedPolicy(ThreadPoolRejectedPolicy rejectedPolicy) {
        this.rejectedPolicy = rejectedPolicy;
    }

    public String toString() {
        return "Threads";
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    protected void doStart() throws Exception {
        this.shutdown.set(false);
    }

    @Override
    protected void doStop() throws Exception {
        this.shutdown.set(true);
    }

    @Override
    protected void doShutdown() throws Exception {
        if (this.shutdownExecutorService) {
            this.camelContext.getExecutorServiceManager().shutdownNow(this.executorService);
        }
        super.doShutdown();
    }

    private final class ProcessCall
    implements Runnable,
    Rejectable {
        private final Exchange exchange;
        private final AsyncCallback callback;

        public ProcessCall(Exchange exchange, AsyncCallback callback) {
            this.exchange = exchange;
            this.callback = callback;
        }

        @Override
        public void run() {
            LOG.trace("Continue routing exchange {} ", (Object)this.exchange);
            if (ThreadsProcessor.this.shutdown.get()) {
                this.exchange.setException(new RejectedExecutionException("ThreadsProcessor is not running."));
            }
            this.callback.done(false);
        }

        @Override
        public void reject() {
            boolean abort;
            boolean bl = abort = ThreadPoolRejectedPolicy.Abort == ThreadsProcessor.this.rejectedPolicy;
            if (abort) {
                this.exchange.setException(new RejectedExecutionException());
            }
            LOG.trace("{} routing exchange {} ", (Object)(abort ? "Aborted" : "Rejected"), (Object)this.exchange);
            this.exchange.setProperty("CamelRouteStop", true);
            this.exchange.setProperty("CamelRedeliveryExhausted", true);
            if (ThreadsProcessor.this.shutdown.get()) {
                this.exchange.setException(new RejectedExecutionException("ThreadsProcessor is not running."));
            }
            this.callback.done(false);
        }

        public String toString() {
            return "ProcessCall[" + this.exchange + "]";
        }
    }
}

