/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.bpel.engine.cron;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.engine.BpelServerImpl;
import org.apache.ode.bpel.engine.Contexts;
import org.apache.ode.bpel.engine.cron.RuntimeDataCleanupRunnable;
import org.apache.ode.bpel.engine.cron.SystemSchedulesConfig;
import org.apache.ode.bpel.iapi.ClusterAware;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.Scheduler;
import org.apache.ode.utils.CronExpression;

public class CronScheduler {
    static final Log __log = LogFactory.getLog(CronScheduler.class);
    private final long MIN_INTERVAL = 0L;
    private final long TOLERABLE_SCHEDULE_DELAY = 0L;
    private ExecutorService _scheduledTaskExec;
    private Contexts _contexts;
    private final Timer _schedulerTimer = new Timer("CronScheduler", true);
    private final Collection<TerminationListener> _systemTerminationListeners = new ArrayList<TerminationListener>();
    private final Map<QName, Collection<TerminationListener>> _terminationListenersByPid = new HashMap<QName, Collection<TerminationListener>>();
    private volatile boolean _shuttingDown = false;

    public void setScheduledTaskExec(ExecutorService taskExec) {
        this._scheduledTaskExec = taskExec;
    }

    public void setContexts(Contexts _contexts) {
        this._contexts = _contexts;
    }

    public void shutdown() {
        this._shuttingDown = true;
        this._schedulerTimer.cancel();
        for (TerminationListener terminationListener : this._systemTerminationListeners) {
            terminationListener.terminate();
        }
        this._systemTerminationListeners.clear();
        for (Collection collection : this._terminationListenersByPid.values()) {
            for (TerminationListener listener : collection) {
                listener.terminate();
            }
        }
        this._terminationListenersByPid.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelProcessCronJobs(QName pid, boolean undeployed) {
        assert (pid != null);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Cancelling PROCESS CRON jobs for: " + pid));
        }
        ArrayList<TerminationListener> listenersToTerminate = new ArrayList<TerminationListener>();
        Object object = this._terminationListenersByPid;
        synchronized (object) {
            Collection<TerminationListener> listeners = this._terminationListenersByPid.get(pid);
            if (listeners != null) {
                listenersToTerminate.addAll(listeners);
                listeners.clear();
            }
            if (undeployed) {
                this._terminationListenersByPid.remove(pid);
            }
        }
        object = pid;
        synchronized (object) {
            for (TerminationListener listener : listenersToTerminate) {
                listener.terminate();
            }
        }
        __log.info((Object)("Cancelled PROCESS CRON jobs for: " + pid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleProcessCronJobs(QName pid, ProcessConf pconf) {
        if (this._shuttingDown) {
            return;
        }
        assert (pid != null);
        this.cancelProcessCronJobs(pid, false);
        ArrayList<TerminationListener> newListeners = new ArrayList<TerminationListener>();
        Object object = pid;
        synchronized (object) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)("Scheduling PROCESS CRON jobs for: " + pid));
            }
            for (final ProcessConf.CronJob job : pconf.getCronJobs()) {
                if (__log.isDebugEnabled()) {
                    __log.debug((Object)("Scheduling PROCESS CRON job: " + job.getCronExpression() + " for: " + pid));
                }
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (__log.isDebugEnabled()) {
                            __log.debug((Object)("Running cron cleanup with details list size: " + job.getRunnableDetailList().size()));
                        }
                        for (Scheduler.JobDetails details : job.getRunnableDetailList()) {
                            try {
                                RuntimeDataCleanupRunnable cleanup = new RuntimeDataCleanupRunnable();
                                cleanup.restoreFromDetails(details);
                                cleanup.setContexts(CronScheduler.this._contexts);
                                cleanup.run();
                                if (!__log.isDebugEnabled()) continue;
                                __log.debug((Object)("Finished running runtime data cleanup from a PROCESS CRON job: " + cleanup));
                            }
                            catch (Exception re) {
                                __log.error((Object)("Error during runtime data cleanup from a PROCESS CRON: " + details + "; check your cron settings in deploy.xml."), (Throwable)re);
                            }
                        }
                    }
                };
                newListeners.add(this.schedule(job.getCronExpression(), runnable, null, null));
            }
        }
        if (!newListeners.isEmpty()) {
            object = this._terminationListenersByPid;
            synchronized (object) {
                Collection<TerminationListener> oldListeners = this._terminationListenersByPid.get(pid);
                if (oldListeners == null) {
                    this._terminationListenersByPid.put(pid, newListeners);
                } else {
                    oldListeners.addAll(newListeners);
                }
            }
        }
        __log.info((Object)("Scheduled PROCESS CRON jobs for: " + pid));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshSystemCronJobs(SystemSchedulesConfig systemSchedulesConf) {
        if (this._shuttingDown) {
            return;
        }
        Collection<TerminationListener> collection = this._systemTerminationListeners;
        synchronized (collection) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"Refreshing SYSTEM CRON jobs.");
            }
            try {
                List<ProcessConf.CronJob> systemCronJobs = systemSchedulesConf.getSystemCronJobs();
                for (TerminationListener listener : this._systemTerminationListeners) {
                    listener.terminate();
                }
                this._systemTerminationListeners.clear();
                for (final ProcessConf.CronJob job : systemCronJobs) {
                    if (__log.isDebugEnabled()) {
                        __log.debug((Object)("Scheduling SYSTEM CRON job:" + job));
                    }
                    Runnable runnable = new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            for (Scheduler.JobDetails details : job.getRunnableDetailList()) {
                                try {
                                    RuntimeDataCleanupRunnable cleanup = new RuntimeDataCleanupRunnable();
                                    Map map = CronScheduler.this._terminationListenersByPid;
                                    synchronized (map) {
                                        if (!CronScheduler.this._terminationListenersByPid.isEmpty()) {
                                            details.getDetailsExt().put("pidsToExclude", CronScheduler.this._terminationListenersByPid.keySet());
                                        }
                                    }
                                    cleanup.restoreFromDetails(details);
                                    cleanup.setContexts(CronScheduler.this._contexts);
                                    cleanup.run();
                                    if (!__log.isDebugEnabled()) continue;
                                    __log.debug((Object)("Finished running runtime data cleanup from a SYSTEM CRON job:" + cleanup));
                                }
                                catch (Exception e) {
                                    __log.error((Object)("Error running a runtime data cleanup from a SYSTEM CRON job: " + details + "; check your system cron setup."), (Throwable)e);
                                }
                            }
                        }
                    };
                    this._systemTerminationListeners.add(this.schedule(job.getCronExpression(), runnable, null, null));
                }
            }
            catch (Exception e) {
                __log.error((Object)"Error during refreshing SYSTEM CRON schedules: ", (Throwable)e);
            }
        }
    }

    public TerminationListener schedule(final CronExpression cronExpression, final Runnable runnable, Scheduler.JobDetails runnableDetails, TerminationListener terminationListener) {
        if (this._shuttingDown) {
            __log.info((Object)"CRON Scheduler is being shut down. This new scheduling request is ignored.");
            return new TerminationListener(){

                @Override
                public void terminate() {
                }
            };
        }
        assert (cronExpression != null);
        assert (runnable != null);
        Date nextScheduleTime = cronExpression.getNextValidTimeAfter(new Date(System.currentTimeMillis() + 0L));
        final CronScheduledJob job = new CronScheduledJob(nextScheduleTime, runnable, runnableDetails, cronExpression, terminationListener);
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("CRON will run in " + (nextScheduleTime.getTime() - System.currentTimeMillis()) + "ms."));
        }
        try {
            this._schedulerTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    __log.debug((Object)("Cron scheduling timer kicked in: " + cronExpression));
                    if (!(((CronScheduler)CronScheduler.this)._contexts.scheduler instanceof ClusterAware) || ((ClusterAware)((Object)((CronScheduler)CronScheduler.this)._contexts.scheduler)).amICoordinator()) {
                        CronScheduler.this._scheduledTaskExec.submit(job);
                        __log.debug((Object)("CRON job scheduled " + runnable));
                    }
                }
            }, nextScheduleTime);
        }
        catch (IllegalStateException ise) {
            if (this._shuttingDown) {
                __log.info((Object)"CRON Scheduler is being shut down. This new scheduling request is ignored.");
            }
            throw ise;
        }
        return job.terminationListener;
    }

    private class CronScheduledJob
    implements Callable<TerminationListener> {
        private volatile boolean terminated = false;
        private Date nextScheduleTime;
        private Runnable runnable;
        private Scheduler.JobDetails runnableDetails;
        private CronExpression cronExpression;
        private TerminationListener terminationListener;

        public CronScheduledJob(Date nextScheduleTime, Runnable runnable, Scheduler.JobDetails runnableDetails, CronExpression cronExpression, TerminationListener terminationListener) {
            this.nextScheduleTime = nextScheduleTime;
            this.runnable = runnable;
            this.runnableDetails = runnableDetails;
            this.cronExpression = cronExpression;
            if (terminationListener == null) {
                terminationListener = new TerminationListener(){

                    @Override
                    public void terminate() {
                        CronScheduledJob.this.terminated = true;
                    }
                };
            }
            this.terminationListener = terminationListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public TerminationListener call() throws Exception {
            block11: {
                try {
                    if (this.runnableDetails != null && this.runnable instanceof Scheduler.MapSerializableRunnable) {
                        ((Scheduler.MapSerializableRunnable)this.runnable).restoreFromDetails(this.runnableDetails);
                    }
                    if (this.runnable instanceof BpelServerImpl.ContextsAware) {
                        ((BpelServerImpl.ContextsAware)((Object)this.runnable)).setContexts(CronScheduler.this._contexts);
                    }
                    if (!CronScheduler.this._shuttingDown && !this.terminated) {
                        __log.debug((Object)("Running CRON job: " + this.runnable + " for " + this.nextScheduleTime.getTime()));
                        this.runnable.run();
                    }
                }
                catch (Exception e) {
                    if (CronScheduler.this._shuttingDown) {
                        __log.info((Object)("A cron job threw an Exception during ODE shutdown: " + e.getMessage() + ", you can ignore the error."));
                        break block11;
                    }
                    if (e instanceof RuntimeException) {
                        throw e;
                    }
                    throw new RuntimeException("Exception during running cron scheduled job: " + this.runnable, e);
                }
                finally {
                    if (!CronScheduler.this._shuttingDown && !this.terminated) {
                        CronScheduler.this.schedule(this.cronExpression, this.runnable, this.runnableDetails, this.terminationListener);
                    }
                }
            }
            return this.terminationListener;
        }
    }

    public static interface TerminationListener {
        public void terminate();
    }
}

