/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.utils;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;

public class LoggingInterceptor<T>
implements InvocationHandler {
    private static final Set<String> PARAMSTYPES = new HashSet<String>();
    private Log _log;
    private T _delegate;
    private Map<String, Object> _paramsByName = new TreeMap<String, Object>();
    private Map<Integer, Object> _paramsByIdx = new TreeMap<Integer, Object>();

    public LoggingInterceptor(T delegate, Log log) {
        this._log = log;
        this._delegate = delegate;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            if (method.getDeclaringClass() == DataSource.class && "getConnection".equals(method.getName())) {
                Connection conn = (Connection)method.invoke(this._delegate, args);
                this.print("getConnection (tx=" + conn.getTransactionIsolation() + ")");
                return Proxy.newProxyInstance(this._delegate.getClass().getClassLoader(), new Class[]{Connection.class}, new LoggingInterceptor<Connection>(conn, this._log));
            }
            if (method.getDeclaringClass() == Connection.class && Statement.class.isAssignableFrom(method.getReturnType())) {
                Statement stmt = (Statement)method.invoke(this._delegate, args);
                this.print(method, args);
                return Proxy.newProxyInstance(this._delegate.getClass().getClassLoader(), new Class[]{method.getReturnType()}, new LoggingInterceptor<Statement>(stmt, this._log));
            }
            this.print(method, args);
            return method.invoke(this._delegate, args);
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }

    private void print(Method method, Object[] args) {
        if (this.shouldPrint()) {
            if ("prepareStatement".equals(method.getName())) {
                this.print("prepareStatement: " + args[0]);
            } else if ("prepareCall".equals(method.getName())) {
                this.print("prepareCall: " + args[0]);
            } else if ("close".equals(method.getName())) {
                this.print("close()");
            } else if ("commit".equals(method.getName())) {
                this.print("commit()");
            } else if ("rollback".equals(method.getName())) {
                this.print("rollback()");
            } else if ("setTransactionIsolation".equals(method.getName())) {
                this.print("Set isolation level to " + args[0]);
            } else if (method.getName().startsWith("execute")) {
                this.print(method.getName() + ", " + this.getParams());
            } else if ("clearParameters".equals(method.getName())) {
                this._paramsByIdx.clear();
                this._paramsByName.clear();
            } else if ("setNull".equals(method.getName())) {
                if (String.class.isAssignableFrom(args[0].getClass())) {
                    this._paramsByName.put((String)args[0], null);
                } else if (Integer.class.isAssignableFrom(args[0].getClass())) {
                    this._paramsByIdx.put((Integer)args[0], null);
                }
            } else if (PARAMSTYPES.contains(method.getName())) {
                if (String.class.isAssignableFrom(args[0].getClass())) {
                    this._paramsByName.put((String)args[0], args[1]);
                } else if (Integer.class.isAssignableFrom(args[0].getClass())) {
                    this._paramsByIdx.put((Integer)args[0], args[1]);
                }
            }
        }
    }

    private String getParams() {
        if (this._paramsByIdx.size() > 0 || this._paramsByName.size() > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append("bound ");
            for (Map.Entry<Integer, Object> entry : this._paramsByIdx.entrySet()) {
                try {
                    buf.append("(").append(entry.getKey()).append(",").append(entry.getValue()).append(") ");
                }
                catch (Throwable e) {
                    return "[e]";
                }
            }
            for (Map.Entry<Object, Object> entry : this._paramsByName.entrySet()) {
                try {
                    buf.append("(").append((String)entry.getKey()).append(",").append(entry.getValue()).append(") ");
                }
                catch (Throwable e) {
                    return "[e]";
                }
            }
            return buf.toString();
        }
        return "w/o params";
    }

    private boolean shouldPrint() {
        if (this._log != null) {
            return this._log.isDebugEnabled();
        }
        return true;
    }

    private void print(String str) {
        if (this._log != null) {
            this._log.debug((Object)str);
        } else {
            System.out.println(str);
        }
    }

    public static DataSource createLoggingDS(DataSource ds, Log log) {
        return (DataSource)Proxy.newProxyInstance(ds.getClass().getClassLoader(), new Class[]{DataSource.class}, new LoggingInterceptor<DataSource>(ds, log));
    }

    static {
        PARAMSTYPES.add("setArray");
        PARAMSTYPES.add("setBigDecimal");
        PARAMSTYPES.add("setBoolean");
        PARAMSTYPES.add("setByte");
        PARAMSTYPES.add("setBytes");
        PARAMSTYPES.add("setDate");
        PARAMSTYPES.add("setDouble");
        PARAMSTYPES.add("setFloat");
        PARAMSTYPES.add("setInt");
        PARAMSTYPES.add("setLong");
        PARAMSTYPES.add("setObject");
        PARAMSTYPES.add("setRef");
        PARAMSTYPES.add("setShort");
        PARAMSTYPES.add("setString");
        PARAMSTYPES.add("setTime");
        PARAMSTYPES.add("setTimestamp");
        PARAMSTYPES.add("setURL");
    }
}

